/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlinesPlayerAttributes;
import com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound.DefaultGraveboundAction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;

public class GraveboundForceEndMistFormAction
extends DefaultGraveboundAction {
    public boolean isEnabled() {
        return true;
    }

    protected boolean activate(IHunterPlayer iHunterPlayer, IAction.ActivationContext activationContext) {
        Player player = iHunterPlayer.asEntity();
        BloodlinesPlayerAttributes atts = BloodlinesPlayerAttributes.get(player);
        if (!atts.getGraveboundData().mistForm) {
            return false;
        }
        DamageSource killingDamageSource = atts.getGraveboundData().lastDamageSource;
        atts.getGraveboundData().mistForm = false;
        if (killingDamageSource != null) {
            player.hurt(killingDamageSource, 1000.0f);
        } else {
            player.kill();
        }
        return true;
    }

    public int getCooldown(IHunterPlayer iHunterPlayer) {
        return 20;
    }

    @Override
    public boolean canBeUsedBy(IHunterPlayer player) {
        return BloodlinesPlayerAttributes.get((Player)player.asEntity()).getGraveboundData().mistForm;
    }

    @Override
    public boolean showInSelectAction(Player player) {
        return BloodlinesPlayerAttributes.get((Player)player).getGraveboundData().mistForm;
    }

    public boolean showHudCooldown(Player player) {
        return BloodlinesPlayerAttributes.get((Player)player).getGraveboundData().mistForm;
    }
}

