/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.hunter.BloodlineGravebound;
import com.thedrofdoctoring.bloodlines.config.HunterBloodlinesConfig;
import com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound.DefaultGraveboundAction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class GraveboundDevourSoulAction
extends DefaultGraveboundAction {
    protected boolean activate(IHunterPlayer iHunterPlayer, IAction.ActivationContext activationContext) {
        Player player = iHunterPlayer.asEntity();
        if (activationContext.targetEntity().isPresent()) {
            Entity entity = (Entity)activationContext.targetEntity().get();
            BloodlineManager manager = BloodlineManager.get(iHunterPlayer.asEntity());
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                IBloodline iBloodline = manager.getBloodline();
                if (iBloodline instanceof BloodlineGravebound) {
                    BloodlineGravebound gravebound = (BloodlineGravebound)iBloodline;
                    if (gravebound.canDevour((Entity)living, player)) {
                        gravebound.devour(living, player);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public int getCooldown(IHunterPlayer iHunterPlayer) {
        int blRank = BloodlineManager.get(iHunterPlayer.asEntity()).getRank() - 1;
        return (Integer)((List)HunterBloodlinesConfig.devourSoulCooldownsSeconds.get()).get(blRank) * 20;
    }

    public boolean showHudCooldown(Player player) {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }
}

