/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlinesPlayerAttributes;
import com.thedrofdoctoring.bloodlines.config.HunterBloodlinesConfig;
import com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound.DefaultGraveboundAction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.particle.GenericParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class GraveboundCritStrikeAction
extends DefaultGraveboundAction
implements ILastingAction<IHunterPlayer> {
    public boolean isEnabled() {
        return true;
    }

    protected boolean activate(IHunterPlayer iHunterPlayer, IAction.ActivationContext activationContext) {
        BloodlinesPlayerAttributes.get((Player)iHunterPlayer.asEntity()).getGraveboundData().critStrikeActive = true;
        return true;
    }

    public void onActivatedClient(IHunterPlayer iHunterPlayer) {
        BloodlinesPlayerAttributes.get((Player)iHunterPlayer.asEntity()).getGraveboundData().critStrikeActive = true;
    }

    public void onDeactivated(IHunterPlayer iHunterPlayer) {
        BloodlinesPlayerAttributes.get((Player)iHunterPlayer.asEntity()).getGraveboundData().critStrikeActive = false;
    }

    public void onReActivated(IHunterPlayer iHunterPlayer) {
        BloodlinesPlayerAttributes.get((Player)iHunterPlayer.asEntity()).getGraveboundData().critStrikeActive = true;
    }

    public int getDuration(IHunterPlayer iHunterPlayer) {
        return (Integer)HunterBloodlinesConfig.sorcerousStrikeDuration.get() * 20;
    }

    public boolean onUpdate(IHunterPlayer iHunterPlayer) {
        if (iHunterPlayer.asEntity().tickCount % 10 == 0) {
            return BloodlinesPlayerAttributes.get((Player)iHunterPlayer.asEntity()).getGraveboundData().critStrikeActive;
        }
        if (!iHunterPlayer.asEntity().getCommandSenderWorld().isClientSide) {
            Player player = iHunterPlayer.asEntity();
            ModParticles.spawnParticlesServer((Level)player.getCommandSenderWorld(), (ParticleOptions)new GenericParticleOptions(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"generic_4"), 5, 0x800080, 0.1f), (double)player.getX(), (double)player.getY(), (double)player.getZ(), (int)3, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        return false;
    }

    public int getCooldown(IHunterPlayer iHunterPlayer) {
        return (Integer)HunterBloodlinesConfig.sorcerousStrikeCooldown.get() * 20;
    }

    public boolean showHudCooldown(Player player) {
        return true;
    }
}

