/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record BloodlineSubPredicate(IBloodline bloodline) implements EntitySubPredicate
{
    public static final MapCodec<BloodlineSubPredicate> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)IBloodline.CODEC.fieldOf("bloodline").forGetter(p -> p.bloodline)).apply((Applicative)inst, BloodlineSubPredicate::new));

    @NotNull
    public MapCodec<? extends EntitySubPredicate> codec() {
        return CODEC;
    }

    public boolean matches(@NotNull Entity pEntity, @NotNull ServerLevel pLevel, @Nullable Vec3 p_218830_) {
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            BloodlineManager manager = BloodlineManager.get(player);
            IPlayableFaction faction = FactionPlayerHandler.get((Player)player).getCurrentFaction();
            IBloodline bl = manager.getBloodline();
            if (bl == null || bl.getFaction() != faction) {
                return false;
            }
            return bl == this.bloodline;
        }
        return false;
    }
}

