/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlinesPlayerAttributes;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.IVampSpecialAttributes;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import com.thedrofdoctoring.bloodlines.skills.BloodlineActionSkill;
import com.thedrofdoctoring.bloodlines.skills.BloodlineParentSkill;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkill;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSubPredicate;
import com.thedrofdoctoring.bloodlines.skills.actions.BloodlineActions;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.ISkillNode;
import de.teamlapen.vampirism.api.entity.factions.ISkillTree;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.player.skills.SkillNode;
import de.teamlapen.vampirism.entity.player.skills.SkillTree;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class BloodlineSkills {
    public static final HashMap<IBloodline, ArrayList<ISkill<?>>> bloodlineSkills = new HashMap();
    public static final DeferredRegister<ISkill<?>> SKILLS = DeferredRegister.create((ResourceKey)VampirismRegistries.Keys.SKILL, (String)"bloodlines");
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> NOBLE_SKILL = SKILLS.register("noble", () -> new BloodlineParentSkill((IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get(), true, 0, 1));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ZEALOT_SKILL = SKILLS.register("zealot", () -> new BloodlineParentSkill((IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get(), true, 0, 1));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ECTOTHERM_SKILL = SKILLS.register("ectotherm", () -> new BloodlineParentSkill((IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get(), true, 0, 1).setToggleActions(player -> {
        ((VampirePlayer)player).getSpecialAttributes().waterResistance = true;
    }, player -> {
        ((VampirePlayer)player).getSpecialAttributes().waterResistance = false;
    }));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOODKNIGHT_SKILL = SKILLS.register("bloodknight", () -> new BloodlineParentSkill((IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get(), true, 0, 1));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_SKILL = SKILLS.register("gravebound", () -> new BloodlineParentSkill<IHunterPlayer>((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 0, 1){

        protected void getActions(@NotNull Collection<IAction<IHunterPlayer>> list) {
            list.add((IAction<IHunterPlayer>)((IAction)BloodlineActions.GRAVEBOUND_DEVOUR_SOUL.get()));
        }
    });
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ZEALOT_RANK_2 = SKILLS.register("zealot_rank_2", () -> new BloodlineParentSkill((IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get(), true, 0, 2));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ZEALOT_RANK_3 = SKILLS.register("zealot_rank_3", () -> new BloodlineParentSkill((IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get(), false, 0, 3));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ZEALOT_RANK_4 = SKILLS.register("zealot_rank_4", () -> new BloodlineParentSkill((IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get(), true, 0, 4));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ZEALOT_POISONED_STRIKE = SKILLS.register("zealot_poisoned_strike", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get(), true, 0, false));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ZEALOT_STONE_SPEED = SKILLS.register("zealot_stone_speed", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ZEALOT_DARKCLOAK = SKILLS.register("zealot_darkcloak", () -> new BloodlineActionSkill(BloodlineActions.ZEALOT_DARK_CLOAK_ACTION, 1, true, (IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get(), true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ZEALOT_SHADOWWALK = SKILLS.register("zealot_shadowwalk", () -> new BloodlineActionSkill(BloodlineActions.ZEALOT_SHADOWWALK_ACTION, 2, true, (IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get(), true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ZEALOT_WALL_CLIMB = SKILLS.register("zealot_wall_climb", () -> new BloodlineActionSkill(BloodlineActions.ZEALOT_WALL_CLIMB_ACTION, 0, true, (IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get(), true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ZEALOT_FALL_DAMAGE = SKILLS.register("zealot_fall_damage", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ZEALOT_FLESH_EATING = SKILLS.register("zealot_flesh_eating", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ZEALOT_TUNNELER = SKILLS.register("zealot_tunneler", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get(), true, 0, true).setToggleActions(player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getZealotAtts().hasTunneler = true;
    }, player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getZealotAtts().hasTunneler = false;
    }));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ZEALOT_SPIDER_FRIEND = SKILLS.register("zealot_spider_friend", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get(), true, 1, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ZEALOT_SHADOW_MASTERY = SKILLS.register("zealot_shadow_mastery", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ZEALOT_SWIFT_SNEAK = SKILLS.register("zealot_swift_sneak", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ZEALOT_OBSCURED_POWER = SKILLS.register("zealot_obscured_power", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get(), true, 1, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ZEALOT_HEX_PROTECTION = SKILLS.register("zealot_hex_protection", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get(), true, 1, true).setToggleActions(player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getZealotAtts().hasHexProtection = true;
    }, player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getZealotAtts().hasHexProtection = false;
    }));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ZEALOT_FRENZY = SKILLS.register("zealot_frenzy", () -> new BloodlineActionSkill(BloodlineActions.ZEALOT_FRENZY_ACTION, 0, true, (IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get(), true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ZEALOT_SHADOW_ARMOUR = SKILLS.register("zealot_shadow_armour", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get(), true, 0).setToggleActions(player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getZealotAtts().hasShadowArmour = true;
    }, player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getZealotAtts().hasShadowArmour = false;
    }));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> NOBLE_RANK_2 = SKILLS.register("noble_rank_2", () -> new BloodlineParentSkill((IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get(), true, 0, 2));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> NOBLE_RANK_3 = SKILLS.register("noble_rank_3", () -> new BloodlineParentSkill((IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get(), true, 0, 3));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> NOBLE_RANK_4 = SKILLS.register("noble_rank_4", () -> new BloodlineParentSkill((IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get(), true, 0, 4));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> NOBLE_BETTER_TRADE_PRICES = SKILLS.register("noble_better_prices", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get(), false, 0, true, 2));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> NOBLE_BETTER_BLOOD_DRAIN = SKILLS.register("noble_better_blood_drain", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get(), true, 0));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> NOBLE_FASTER_RESURRECT = SKILLS.register("noble_faster_resurrect", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get(), false, 0));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> NOBLE_MORE_TICKS_IN_SUN = SKILLS.register("noble_more_ticks_in_sun", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get(), true, 1).setToggleActions(player -> ((IVampSpecialAttributes)((VampirePlayer)player).getSpecialAttributes()).bloodlines$setSlowSun(true), player -> ((IVampSpecialAttributes)((VampirePlayer)player).getSpecialAttributes()).bloodlines$setSlowSun(false)));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> NOBLE_BAT_FLIGHT_SPEED = SKILLS.register("noble_bat_flying_speed", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get(), false, 1));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> NOBLE_FASTER_MOVEMENT_SPEED = SKILLS.register("noble_faster_movement_speed", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get(), false, 0));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> NOBLE_CHALICE_SKILL = SKILLS.register("noble_bottomless_chalice", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get(), true, 0));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> NOBLE_ENHANCED_LEECHING = SKILLS.register("noble_enhanced_leeching", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get(), true, 0));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> NOBLE_INTRIGUE = SKILLS.register("noble_intrigue", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get(), true, 0));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> NOBLE_CELERITY = SKILLS.register("noble_celerity", () -> new BloodlineActionSkill(BloodlineActions.NOBLE_CELERITY_ACTION, 0, false, (IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get(), true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> NOBLE_MESMERISE = SKILLS.register("noble_mesmerise", () -> new BloodlineActionSkill(BloodlineActions.NOBLE_MESMERISE_ACTION, 0, true, (IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get(), true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> NOBLE_LEECHING = SKILLS.register("noble_leeching", () -> new BloodlineActionSkill(BloodlineActions.NOBLE_LEECHING_ACTION, 0, true, (IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get(), true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> NOBLE_INVISIBILITY = SKILLS.register("noble_invisibility", () -> new BloodlineActionSkill(BloodlineActions.NOBLE_INVISIBILITY_ACTION, 0, true, (IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get(), true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> NOBLE_FLANK = SKILLS.register("noble_flank", () -> new BloodlineActionSkill(BloodlineActions.NOBLE_FLANK_ACTION, 0, true, (IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get(), true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> NOBLE_BAT_ARMOUR = SKILLS.register("noble_bat_armour", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get(), true, 0));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ECTOTHERM_RANK_2 = SKILLS.register("ectotherm_rank_2", () -> new BloodlineParentSkill<IVampirePlayer>((IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get(), true, 0, 2){

        protected void getActions(@NotNull Collection<IAction<IVampirePlayer>> list) {
            list.add((IAction<IVampirePlayer>)((IAction)BloodlineActions.ECTOTHERM_FROST_LORD_ACTION.get()));
        }
    });
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ECTOTHERM_RANK_3 = SKILLS.register("ectotherm_rank_3", () -> new BloodlineParentSkill((IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get(), true, 0, 3));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ECTOTHERM_RANK_4 = SKILLS.register("ectotherm_rank_4", () -> new BloodlineParentSkill((IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get(), true, 0, 4));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> FISHMONGER = SKILLS.register("ectotherm_fishmonger", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ECTOTHERM_REFRACTION = SKILLS.register("ectotherm_refraction", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get(), true, 0).setToggleActions(player -> ((IVampSpecialAttributes)((VampirePlayer)player).getSpecialAttributes()).bloodlines$setRefraction(true), player -> ((IVampSpecialAttributes)((VampirePlayer)player).getSpecialAttributes()).bloodlines$setRefraction(false)));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ECTOTHERM_DIFFUSION = SKILLS.register("ectotherm_diffusion", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get(), true, 0).setToggleActions(player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getEctothermAtts().hasHolyWaterDiffusion = true;
    }, player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getEctothermAtts().hasHolyWaterDiffusion = false;
    }));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ECTOTHERM_TENTACLES = SKILLS.register("ectotherm_tentacles", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get(), true, 0));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ECTOTHERM_ICELORD = SKILLS.register("ectotherm_icelord", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ECTOTHERM_FROST_CONTROL = SKILLS.register("ectotherm_frost_control", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get(), true, 0).setToggleActions(player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getEctothermAtts().frostControl = true;
    }, player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getEctothermAtts().frostControl = false;
    }));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ECTOTHERM_MINING_SPEED_UNDERWATER = SKILLS.register("ectotherm_mining_speed_underwater", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ECTOTHERM_FROZEN_ATTACK = SKILLS.register("ectotherm_frozen_attack", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ECTOTHERM_SLOWNESS_ATTACK = SKILLS.register("ectotherm_slowness_attack", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ECTOTHERM_DOLPHIN_LEAP = SKILLS.register("ectotherm_dolphin_leap", () -> new BloodlineActionSkill(BloodlineActions.ECTOTHERM_DOLPHIN_LEAP_ACTION, 0, true, (IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get(), true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ECTOTHERM_SNOW_WALKER = SKILLS.register("ectotherm_snow_walker", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get(), true, 0, true).setToggleActions(player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getEctothermAtts().snowWalker = true;
    }, player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getEctothermAtts().snowWalker = false;
    }));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ECTOTHERM_LORD_OF_FROST_MULTIPLIER = SKILLS.register("ectotherm_lord_of_frost_multiplier", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ECTOTHERM_UNDERWATER_DURATION = SKILLS.register("ectotherm_underwater_duration", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ECTOTHERM_HYDRODYNAMIC_FORM = SKILLS.register("ectotherm_hydrodynamic_form", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> ECTOTHERM_INK_SPLASH = SKILLS.register("ectotherm_ink_splash", () -> new BloodlineActionSkill(BloodlineActions.ECTOTHERM_INK_SPLASH_ACTION, 0, true, (IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get(), true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOODKNIGHT_RANK_2 = SKILLS.register("bloodknight_rank_2", () -> new BloodlineParentSkill((IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get(), true, 0, 2));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOODKNIGHT_RANK_3 = SKILLS.register("bloodknight_rank_3", () -> new BloodlineParentSkill((IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get(), true, 0, 3));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOODKNIGHT_RANK_4 = SKILLS.register("bloodknight_rank_4", () -> new BloodlineParentSkill((IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get(), true, 0, 4));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOODKNIGHT_STILL_BLOOD = SKILLS.register("bloodknight_still_water", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get(), true, 0, true, 3));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOODKNIGHT_FEIGNED_MERCY = SKILLS.register("bloodknight_feigned_mercy", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOODKNIGHT_FEEDING_FRENZY_1 = SKILLS.register("bloodknight_feeding_frenzy_1", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOODKNIGHT_FEEDING_FRENZY_2 = SKILLS.register("bloodknight_feeding_frenzy_2", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOODKNIGHT_CRIMSON_LEAP = SKILLS.register("bloodknight_crimson_leap", () -> new BloodlineActionSkill(BloodlineActions.BLOODKNIGHT_CRIMSON_LEAP, 0, true, (IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get(), true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOODKNIGHT_SANGUINE_INFUSION = SKILLS.register("bloodknight_sanguine_infusion", () -> new BloodlineActionSkill(BloodlineActions.BLOODKNIGHT_SANGUINE_INFUSION, 0, true, (IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get(), true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOODKNIGHT_BLOOD_HUNT = SKILLS.register("bloodknight_blood_hunt", () -> new BloodlineActionSkill(BloodlineActions.BLOODKNIGHT_BLOOD_HUNT, 0, true, (IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get(), true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOODKNIGHT_VAMPIRE_BLOOD_BONUS = SKILLS.register("bloodknight_vampire_blood_bonus", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOODKNIGHT_INFUSION_HASTE = SKILLS.register("bloodknight_infusion_haste", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOODKNIGHT_INFUSION_STEP_ASSIST = SKILLS.register("bloodknight_infusion_step_assist", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOODKNIGHT_SAPPING_STRIKE = SKILLS.register("bloodknight_sapping_strike", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOODKNIGHT_DAY_WALKER = SKILLS.register("bloodknight_day_walker", () -> new BloodlineActionSkill(BloodlineActions.BLOODKNIGHT_DAY_WALKER, 2, true, (IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get(), true, 4));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOODKNIGHT_BAT_FRENZY = SKILLS.register("bloodknight_bat_frenzy", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOODKNIGHT_BLOOD_EXTRACTION = SKILLS.register("bloodknight_blood_extraction", () -> new BloodlineActionSkill(BloodlineActions.BLOODKNIGHT_BLOOD_EXTRACTION, 0, true, (IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get(), true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOODKNIGHT_FRENZIED_STRIKES = SKILLS.register("bloodknight_frenzied_attacks", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IVampirePlayer>> BLOODKNIGHT_HIDDEN_STRIKE = SKILLS.register("bloodknight_hidden_strike", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_RANK_2 = SKILLS.register("gravebound_rank_2", () -> new BloodlineParentSkill((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 0, 2));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_RANK_3 = SKILLS.register("gravebound_rank_3", () -> new BloodlineParentSkill((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 0, 3));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_RANK_4 = SKILLS.register("gravebound_rank_4", () -> new BloodlineParentSkill((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 0, 4));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_SOUL_INFUSION = SKILLS.register("gravebound_soul_infusion", () -> new BloodlineActionSkill(BloodlineActions.GRAVEBOUND_SOUL_INFUSION, 0, true, (IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_REGEN_DEVOUR = SKILLS.register("gravebound_regen_devour", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_POWERFUL_DEVOUR = SKILLS.register("gravebound_powerful_devour", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 0, true).setToggleActions(player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getGraveboundData().hasPowerfulDevour = true;
    }, player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getGraveboundData().hasPowerfulDevour = false;
    }));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_SORCEROUS_STRIKE = SKILLS.register("gravebound_crit_ability", () -> new BloodlineActionSkill(BloodlineActions.GRAVEBOUND_SORCEROUS_STRIKE, 0, true, (IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 2));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_LINGERING_DEVOUR = SKILLS.register("gravebound_linger_devour", () -> new BloodlineActionSkill(BloodlineActions.GRAVEBOUND_LINGERING_DEVOUR, 0, true, (IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 2));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_SOUL_CLAIMING = SKILLS.register("gravebound_soul_claim", () -> new BloodlineActionSkill(BloodlineActions.GRAVEBOUND_SOUL_CLAIMING, 0, true, (IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 3));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_PASSIVE_SOUL_CLAIMING = SKILLS.register("gravebound_passive_soul_claim", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 2, true, 4).setToggleActions(player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getGraveboundData().passiveSoulClaiming = true;
    }, player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getGraveboundData().passiveSoulClaiming = false;
    }));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_MIST_FORM = SKILLS.register("gravebound_mist_form", () -> new BloodlineSkill<IHunterPlayer>((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 0, false){

        protected void getActions(@NotNull Collection<IAction<IHunterPlayer>> list) {
            list.add((IAction<IHunterPlayer>)((IAction)BloodlineActions.GRAVEBOUND_MIST_FORM.get()));
            list.add((IAction<IHunterPlayer>)((IAction)BloodlineActions.GRAVEBOUND_END_FORM_ACTION.get()));
        }
    });
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_TELEPORT_SKILL = SKILLS.register("gravebound_teleport", () -> new BloodlineActionSkill(BloodlineActions.GRAVEBOUND_PHYLACTERY_TELEPORT_ACTION, 2, true, (IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 3));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_POISON_IMMUNITY = SKILLS.register("gravebound_poison_immunity", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 0, true).setToggleActions(player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getGraveboundData().poisonImmunity = true;
    }, player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getGraveboundData().poisonImmunity = false;
    }));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_POISON_HEALING = SKILLS.register("gravebound_poison_healing", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 1, true, 3).setToggleActions(player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getGraveboundData().poisonHealing = true;
    }, player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getGraveboundData().poisonHealing = false;
    }));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_SOUL_TRANSFER = SKILLS.register("gravebound_soul_transfer", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 1, true, 2));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_GHOST_WALK_ACTION = SKILLS.register("gravebound_ghost_walk", () -> new BloodlineActionSkill(BloodlineActions.GRAVEBOUND_GHOST_WALK_ACTION, 3, true, (IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 4));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_CHEAPER_RESURRECTION = SKILLS.register("gravebound_cheaper_resurrection", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 1, true).setToggleActions(player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getGraveboundData().cheaperResurrection = true;
    }, player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getGraveboundData().cheaperResurrection = false;
    }));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_REDUCED_RESURRECTION_COOLDOWN = SKILLS.register("gravebound_reduced_resurrection_cooldown", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 0, true).setToggleActions(player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getGraveboundData().fasterResurrection = true;
    }, player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getGraveboundData().fasterResurrection = false;
    }));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_SOUL_PHYLACTERY_ACTION = SKILLS.register("gravebound_phylactery_transfer", () -> new BloodlineActionSkill(BloodlineActions.GRAVEBOUND_SOUL_PHYLACTERY_ACTION, 1, true, (IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 3));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_SOUL_SPEED = SKILLS.register("gravebound_soul_speed", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 0, true));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_UNDEAD_LORD = SKILLS.register("gravebound_undead_lord", () -> new BloodlineSkill((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 1, true, 2).setToggleActions(player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getGraveboundData().undeadLord = true;
    }, player -> {
        BloodlinesPlayerAttributes.get((Player)player.asEntity()).getGraveboundData().undeadLord = false;
    }));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_POSSESSION_ACTION = SKILLS.register("gravebound_possession_action", () -> new BloodlineActionSkill(BloodlineActions.GRAVEBOUND_POSSESSION_ACTION, 1, true, (IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 3));
    public static final DeferredHolder<ISkill<?>, ISkill<IHunterPlayer>> GRAVEBOUND_POSSESSION_SWAP_ACTION = SKILLS.register("gravebound_possession_swap_action", () -> new BloodlineActionSkill(BloodlineActions.GRAVEBOUND_POSSESSION_SWAP_ACTION, 1, true, (IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), true, 4));

    public static void addSkill(ISkill<?> skill, IBloodline type) {
        if (!bloodlineSkills.containsKey(type)) {
            bloodlineSkills.put(type, new ArrayList());
        }
        bloodlineSkills.get(type).add(skill);
    }

    public static ArrayList<ISkill<?>> getBloodlineTypeSkills(IBloodline type) {
        return bloodlineSkills.get(type);
    }

    public static class Nodes {
        public static final ResourceKey<ISkillNode> NOBLE_ROOT = Nodes.node("root", "noble");
        public static final ResourceKey<ISkillNode> ZEALOT_ROOT = Nodes.node("root", "zealot");
        public static final ResourceKey<ISkillNode> ECTOTHERM_ROOT = Nodes.node("root", "ectotherm");
        public static final ResourceKey<ISkillNode> BLOODKNIGHT_ROOT = Nodes.node("root", "bloodknight");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_ROOT = Nodes.node("root", "gravebound");
        public static final ResourceKey<ISkillNode> ZEALOT_RANK_2 = Nodes.node("rank_2", "zealot");
        public static final ResourceKey<ISkillNode> ZEALOT_RANK_3 = Nodes.node("rank_3", "zealot");
        public static final ResourceKey<ISkillNode> ZEALOT_RANK_4 = Nodes.node("rank_4", "zealot");
        public static final ResourceKey<ISkillNode> ZEALOT_STONE_SPEED = Nodes.node("stone_speed", "zealot");
        public static final ResourceKey<ISkillNode> ZEALOT_SHADOWWALK = Nodes.node("shadow_walk", "zealot");
        public static final ResourceKey<ISkillNode> ZEALOT_SHADOWARMOUR = Nodes.node("shadow_armour", "zealot");
        public static final ResourceKey<ISkillNode> ZEALOT_DARKCLOAK = Nodes.node("dark_cloak", "zealot");
        public static final ResourceKey<ISkillNode> ZEALOT_WALL_CLIMB = Nodes.node("wall_climb", "zealot");
        public static final ResourceKey<ISkillNode> ZEALOT_FALL_DAMAGE = Nodes.node("fall_damage", "zealot");
        public static final ResourceKey<ISkillNode> ZEALOT_FLESH_ARMOUR = Nodes.node("flesh_shadow_armour", "zealot");
        public static final ResourceKey<ISkillNode> ZEALOT_TUNNELER = Nodes.node("tunneler", "zealot");
        public static final ResourceKey<ISkillNode> ZEALOT_SPIDER_FRIEND = Nodes.node("spider_friend", "zealot");
        public static final ResourceKey<ISkillNode> ZEALOT_SHADOW_MASTERY = Nodes.node("shadow_mastery", "zealot");
        public static final ResourceKey<ISkillNode> ZEALOT_OBSCURED_POWER = Nodes.node("obscured_power", "zealot");
        public static final ResourceKey<ISkillNode> ZEALOT_HEX_PROTECTION = Nodes.node("hex_protection", "zealot");
        public static final ResourceKey<ISkillNode> ZEALOT_FRENZY = Nodes.node("frenzy", "zealot");
        public static final ResourceKey<ISkillNode> ZEALOT_SWIFT_SNEAK = Nodes.node("swift_sneak", "zealot");
        public static final ResourceKey<ISkillNode> ECTOTHERM_RANK_2 = Nodes.node("rank_2", "ectotherm");
        public static final ResourceKey<ISkillNode> ECTOTHERM_RANK_3 = Nodes.node("rank_3", "ectotherm");
        public static final ResourceKey<ISkillNode> ECTOTHERM_RANK_4 = Nodes.node("rank_4", "ectotherm");
        public static final ResourceKey<ISkillNode> ECTOTHERM_ICE_LORD = Nodes.node("ice_lord", "ectotherm");
        public static final ResourceKey<ISkillNode> ECTOTHERM_FISHMONGER = Nodes.node("fishmonger", "ectotherm");
        public static final ResourceKey<ISkillNode> ECTOTHERM_REFRACTION = Nodes.node("refraction", "ectotherm");
        public static final ResourceKey<ISkillNode> ECTOTHERM_DIFFUSION = Nodes.node("diffusion", "ectotherm");
        public static final ResourceKey<ISkillNode> ECTOTHERM_TENTACLES = Nodes.node("tentacles", "ectotherm");
        public static final ResourceKey<ISkillNode> ECTOTHERM_FROST_CONTROL = Nodes.node("frost_control", "ectotherm");
        public static final ResourceKey<ISkillNode> ECTOTHERM_UNDERWATER_MINING_SPEED = Nodes.node("underwater_mining_speed", "ectotherm");
        public static final ResourceKey<ISkillNode> ECTOTHERM_FROZEN_SLOWNESS = Nodes.node("frozen_slowness", "ectotherm");
        public static final ResourceKey<ISkillNode> ECTOTHERM_DOLPHIN_LEAP = Nodes.node("dolphin_leap", "ectotherm");
        public static final ResourceKey<ISkillNode> ECTOTHERM_SNOW_WALKER = Nodes.node("snow_walker", "ectotherm");
        public static final ResourceKey<ISkillNode> ECTOTHERM_LORD_OF_FROST_DURATION = Nodes.node("frost_duration", "ectotherm");
        public static final ResourceKey<ISkillNode> ECTOTHERM_UNDERWATER_DURATION = Nodes.node("underwater_duration", "ectotherm");
        public static final ResourceKey<ISkillNode> ECTOTHERM_INK_SPLASH = Nodes.node("ink_splash", "ectotherm");
        public static final ResourceKey<ISkillNode> ECTOTHERM_HYDRODYNAMIC_FORM = Nodes.node("hydrodynamic_form", "ectotherm");
        public static final ResourceKey<ISkillNode> NOBLE_RANK_2 = Nodes.node("rank_2", "noble");
        public static final ResourceKey<ISkillNode> NOBLE_RANK_3 = Nodes.node("rank_3", "noble");
        public static final ResourceKey<ISkillNode> NOBLE_RANK_4 = Nodes.node("rank_4", "noble");
        public static final ResourceKey<ISkillNode> NOBLE_BETTER_TRADE_PRICES = Nodes.node("better_trade_prices", "noble");
        public static final ResourceKey<ISkillNode> NOBLE_BETTER_BLOOD_DRAIN = Nodes.node("better_blood_drain", "noble");
        public static final ResourceKey<ISkillNode> NOBLE_FASTER_RESURRECT = Nodes.node("better_faster_resurrect", "noble");
        public static final ResourceKey<ISkillNode> NOBLE_MORE_TICKS_IN_SUN = Nodes.node("better_more_ticks_in_sun", "noble");
        public static final ResourceKey<ISkillNode> NOBLE_BAT_FLIGHT_SPEED = Nodes.node("better_bat_flight_speed", "noble");
        public static final ResourceKey<ISkillNode> NOBLE_FASTER_MOVEMENT_SPEED = Nodes.node("faster_movement_speed", "noble");
        public static final ResourceKey<ISkillNode> NOBLE_CHALICE_SKILL = Nodes.node("bottomless_chalice", "noble");
        public static final ResourceKey<ISkillNode> NOBLE_CELERITY = Nodes.node("celerity", "noble");
        public static final ResourceKey<ISkillNode> NOBLE_MESMERISE = Nodes.node("mesmerise", "noble");
        public static final ResourceKey<ISkillNode> NOBLE_LEECHING = Nodes.node("leeching", "noble");
        public static final ResourceKey<ISkillNode> NOBLE_ENHANCED_LEECHING = Nodes.node("enhanced_leeching", "noble");
        public static final ResourceKey<ISkillNode> NOBLE_INVISIBILITY = Nodes.node("invisibility", "noble");
        public static final ResourceKey<ISkillNode> NOBLE_INTRIGUE = Nodes.node("noble_intrigue", "noble");
        public static final ResourceKey<ISkillNode> NOBLE_FLANK = Nodes.node("noble_flank", "noble");
        public static final ResourceKey<ISkillNode> NOBLE_BAT_ARMOUR = Nodes.node("noble_bat_armour", "noble");
        public static final ResourceKey<ISkillNode> BLOODKNIGHT_RANK_2 = Nodes.node("rank_2", "bloodknight");
        public static final ResourceKey<ISkillNode> BLOODKNIGHT_RANK_3 = Nodes.node("rank_3", "bloodknight");
        public static final ResourceKey<ISkillNode> BLOODKNIGHT_RANK_4 = Nodes.node("rank_4", "bloodknight");
        public static final ResourceKey<ISkillNode> BLOODKNIGHT_STILL_BLOOD = Nodes.node("still_blood", "bloodknight");
        public static final ResourceKey<ISkillNode> BLOODKNIGHT_FEIGNED_MERCY = Nodes.node("feigned_mercy", "bloodknight");
        public static final ResourceKey<ISkillNode> BLOODKNIGHT_FEEDING_FRENZY_1 = Nodes.node("feeding_frenzy_1", "bloodknight");
        public static final ResourceKey<ISkillNode> BLOODKNIGHT_FEEDING_FRENZY_2 = Nodes.node("feeding_frenzy_2", "bloodknight");
        public static final ResourceKey<ISkillNode> BLOODKNIGHT_CRIMSON_LEAP = Nodes.node("crimson_leap", "bloodknight");
        public static final ResourceKey<ISkillNode> BLOODKNIGHT_BLOOD_HUNT = Nodes.node("blood_hunt", "bloodknight");
        public static final ResourceKey<ISkillNode> BLOODKNIGHT_SANGUINE_INFUSION = Nodes.node("sanguine_infusion", "bloodknight");
        public static final ResourceKey<ISkillNode> BLOODKNIGHT_VAMPIRE_BLOOD_BONUS = Nodes.node("vampire_blood_bonus", "bloodknight");
        public static final ResourceKey<ISkillNode> BLOODKNIGHT_HASTE_STEP_INFUSION = Nodes.node("haste_step_infusion", "bloodknight");
        public static final ResourceKey<ISkillNode> BLOODKNIGHT_SAPPING_STRIKE = Nodes.node("sapping_strike", "bloodknight");
        public static final ResourceKey<ISkillNode> BLOODKNIGHT_DAY_WALKER = Nodes.node("day_walker", "bloodknight");
        public static final ResourceKey<ISkillNode> BLOODKNIGHT_BAT_FRENZY = Nodes.node("bat_frenzy", "bloodknight");
        public static final ResourceKey<ISkillNode> BLOODKNIGHT_BLOOD_EXTRACTION = Nodes.node("blood_extraction", "bloodknight");
        public static final ResourceKey<ISkillNode> BLOODKNIGHT_FRENZIED_ATTACKS = Nodes.node("frenzied_attacks", "bloodknight");
        public static final ResourceKey<ISkillNode> BLOODKNIGHT_HIDDEN_STRIKE = Nodes.node("hidden_strike", "bloodknight");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_RANK_2 = Nodes.node("rank_2", "gravebound");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_RANK_3 = Nodes.node("rank_3", "gravebound");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_RANK_4 = Nodes.node("rank_4", "gravebound");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_SOUL_INFUSION = Nodes.node("soul_infusion", "gravebound");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_REGEN_DEVOUR = Nodes.node("regen_devour", "gravebound");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_POWERFUL_DEVOUR = Nodes.node("powerful_devour", "gravebound");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_SORCEROUS_STRIKE = Nodes.node("sorcerous_strike", "gravebound");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_LINGERING_DEVOUR = Nodes.node("lingering_devour", "gravebound");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_SOUL_CLAIMING = Nodes.node("soul_claiming", "gravebound");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_PHYLACTERY_TELEPORT = Nodes.node("phylactery_teleport", "gravebound");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_POISON_IMMUNITY = Nodes.node("poison_immunity", "gravebound");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_POISON_HEALING = Nodes.node("poison_healing", "gravebound");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_SOUL_TRANSFER = Nodes.node("soul_transfer", "gravebound");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_GHOST_WALK = Nodes.node("ghost_walk", "gravebound");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_CHEAPER_RESURRECTION = Nodes.node("cheaper_resurrection", "gravebound");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_FASTER_RESURRECTION = Nodes.node("faster_resurrection", "gravebound");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_SOUL_TRANSFER_PHYLACTERY = Nodes.node("soul_transfer_phylactery", "gravebound");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_SOUL_SPEED = Nodes.node("soul_speed", "gravebound");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_UNDEAD_LORD = Nodes.node("gravebound_undead_lord", "gravebound");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_PASSIVE_SOUL_CLAIMING = Nodes.node("gravebound_passive_soul_claiming", "gravebound");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_POSSESSION_ACTION = Nodes.node("gravebound_possession_action", "gravebound");
        public static final ResourceKey<ISkillNode> GRAVEBOUND_POSSESSION_SWAP_ACTION = Nodes.node("gravebound_possession_swap_action", "gravebound");

        private static ResourceKey<ISkillNode> node(String path, String bloodline) {
            return ResourceKey.create((ResourceKey)VampirismRegistries.Keys.SKILL_NODE, (ResourceLocation)Bloodlines.rl(bloodline + "_" + path));
        }

        public static void createSkillNodes(BootstrapContext<ISkillNode> context) {
            context.register(NOBLE_ROOT, (Object)new SkillNode(new Holder[]{NOBLE_SKILL}));
            context.register(ECTOTHERM_ROOT, (Object)new SkillNode(new Holder[]{ECTOTHERM_SKILL}));
            context.register(ZEALOT_ROOT, (Object)new SkillNode(new Holder[]{ZEALOT_SKILL}));
            context.register(BLOODKNIGHT_ROOT, (Object)new SkillNode(new Holder[]{BLOODKNIGHT_SKILL}));
            context.register(GRAVEBOUND_ROOT, (Object)new SkillNode(new Holder[]{GRAVEBOUND_SKILL}));
            context.register(ZEALOT_RANK_2, (Object)new SkillNode(new Holder[]{ZEALOT_RANK_2}));
            context.register(ZEALOT_RANK_3, (Object)new SkillNode(new Holder[]{ZEALOT_RANK_3}));
            context.register(ZEALOT_RANK_4, (Object)new SkillNode(new Holder[]{ZEALOT_RANK_4}));
            context.register(ZEALOT_STONE_SPEED, (Object)new SkillNode(new Holder[]{ZEALOT_STONE_SPEED}));
            context.register(ZEALOT_SHADOWWALK, (Object)new SkillNode(new Holder[]{ZEALOT_SHADOWWALK}));
            context.register(ZEALOT_SHADOWARMOUR, (Object)new SkillNode(new Holder[]{ZEALOT_SHADOW_ARMOUR}));
            context.register(ZEALOT_DARKCLOAK, (Object)new SkillNode(new Holder[]{ZEALOT_DARKCLOAK}));
            context.register(ZEALOT_WALL_CLIMB, (Object)new SkillNode(new Holder[]{ZEALOT_WALL_CLIMB}));
            context.register(ZEALOT_FALL_DAMAGE, (Object)new SkillNode(new Holder[]{ZEALOT_FALL_DAMAGE}));
            context.register(ZEALOT_FLESH_ARMOUR, (Object)new SkillNode(new Holder[]{ZEALOT_FLESH_EATING, ZEALOT_SHADOW_ARMOUR}));
            context.register(ZEALOT_TUNNELER, (Object)new SkillNode(new Holder[]{ZEALOT_TUNNELER}));
            context.register(ZEALOT_SPIDER_FRIEND, (Object)new SkillNode(new Holder[]{ZEALOT_SPIDER_FRIEND}));
            context.register(ZEALOT_SHADOW_MASTERY, (Object)new SkillNode(new Holder[]{ZEALOT_SHADOW_MASTERY}));
            context.register(ZEALOT_OBSCURED_POWER, (Object)new SkillNode(new Holder[]{ZEALOT_OBSCURED_POWER}));
            context.register(ZEALOT_HEX_PROTECTION, (Object)new SkillNode(new Holder[]{ZEALOT_HEX_PROTECTION}));
            context.register(ZEALOT_FRENZY, (Object)new SkillNode(new Holder[]{ZEALOT_FRENZY, ZEALOT_POISONED_STRIKE}));
            context.register(ZEALOT_SWIFT_SNEAK, (Object)new SkillNode(new Holder[]{ZEALOT_SWIFT_SNEAK}));
            context.register(ECTOTHERM_RANK_2, (Object)new SkillNode(new Holder[]{ECTOTHERM_RANK_2}));
            context.register(ECTOTHERM_RANK_3, (Object)new SkillNode(new Holder[]{ECTOTHERM_RANK_3}));
            context.register(ECTOTHERM_RANK_4, (Object)new SkillNode(new Holder[]{ECTOTHERM_RANK_4}));
            context.register(ECTOTHERM_FISHMONGER, (Object)new SkillNode(new Holder[]{FISHMONGER}));
            context.register(ECTOTHERM_REFRACTION, (Object)new SkillNode(new Holder[]{ECTOTHERM_REFRACTION}));
            context.register(ECTOTHERM_DIFFUSION, (Object)new SkillNode(new Holder[]{ECTOTHERM_DIFFUSION}));
            context.register(ECTOTHERM_ICE_LORD, (Object)new SkillNode(new Holder[]{ECTOTHERM_ICELORD}));
            context.register(ECTOTHERM_FROST_CONTROL, (Object)new SkillNode(new Holder[]{ECTOTHERM_FROST_CONTROL}));
            context.register(ECTOTHERM_UNDERWATER_MINING_SPEED, (Object)new SkillNode(new Holder[]{ECTOTHERM_MINING_SPEED_UNDERWATER}));
            context.register(ECTOTHERM_FROZEN_SLOWNESS, (Object)new SkillNode(new Holder[]{ECTOTHERM_FROZEN_ATTACK, ECTOTHERM_SLOWNESS_ATTACK}));
            context.register(ECTOTHERM_DOLPHIN_LEAP, (Object)new SkillNode(new Holder[]{ECTOTHERM_DOLPHIN_LEAP}));
            context.register(ECTOTHERM_TENTACLES, (Object)new SkillNode(new Holder[]{ECTOTHERM_TENTACLES}));
            context.register(ECTOTHERM_SNOW_WALKER, (Object)new SkillNode(new Holder[]{ECTOTHERM_SNOW_WALKER}));
            context.register(ECTOTHERM_LORD_OF_FROST_DURATION, (Object)new SkillNode(new Holder[]{ECTOTHERM_LORD_OF_FROST_MULTIPLIER}));
            context.register(ECTOTHERM_UNDERWATER_DURATION, (Object)new SkillNode(new Holder[]{ECTOTHERM_UNDERWATER_DURATION}));
            context.register(ECTOTHERM_HYDRODYNAMIC_FORM, (Object)new SkillNode(new Holder[]{ECTOTHERM_HYDRODYNAMIC_FORM}));
            context.register(ECTOTHERM_INK_SPLASH, (Object)new SkillNode(new Holder[]{ECTOTHERM_INK_SPLASH}));
            context.register(NOBLE_RANK_2, (Object)new SkillNode(new Holder[]{NOBLE_RANK_2}));
            context.register(NOBLE_RANK_3, (Object)new SkillNode(new Holder[]{NOBLE_RANK_3}));
            context.register(NOBLE_RANK_4, (Object)new SkillNode(new Holder[]{NOBLE_RANK_4}));
            context.register(NOBLE_BETTER_TRADE_PRICES, (Object)new SkillNode(new Holder[]{NOBLE_BETTER_TRADE_PRICES}));
            context.register(NOBLE_BETTER_BLOOD_DRAIN, (Object)new SkillNode(new Holder[]{NOBLE_BETTER_BLOOD_DRAIN}));
            context.register(NOBLE_FASTER_RESURRECT, (Object)new SkillNode(new Holder[]{NOBLE_FASTER_RESURRECT}));
            context.register(NOBLE_MORE_TICKS_IN_SUN, (Object)new SkillNode(new Holder[]{NOBLE_MORE_TICKS_IN_SUN}));
            context.register(NOBLE_BAT_FLIGHT_SPEED, (Object)new SkillNode(new Holder[]{NOBLE_BAT_FLIGHT_SPEED}));
            context.register(NOBLE_FASTER_MOVEMENT_SPEED, (Object)new SkillNode(new Holder[]{NOBLE_FASTER_MOVEMENT_SPEED}));
            context.register(NOBLE_CHALICE_SKILL, (Object)new SkillNode(new Holder[]{NOBLE_CHALICE_SKILL}));
            context.register(NOBLE_CELERITY, (Object)new SkillNode(new Holder[]{NOBLE_CELERITY}));
            context.register(NOBLE_MESMERISE, (Object)new SkillNode(new Holder[]{NOBLE_MESMERISE}));
            context.register(NOBLE_LEECHING, (Object)new SkillNode(new Holder[]{NOBLE_LEECHING}));
            context.register(NOBLE_ENHANCED_LEECHING, (Object)new SkillNode(new Holder[]{NOBLE_ENHANCED_LEECHING}));
            context.register(NOBLE_INVISIBILITY, (Object)new SkillNode(new Holder[]{NOBLE_INVISIBILITY}));
            context.register(NOBLE_INTRIGUE, (Object)new SkillNode(new Holder[]{NOBLE_INTRIGUE}));
            context.register(NOBLE_FLANK, (Object)new SkillNode(new Holder[]{NOBLE_FLANK}));
            context.register(NOBLE_BAT_ARMOUR, (Object)new SkillNode(new Holder[]{NOBLE_BAT_ARMOUR}));
            context.register(BLOODKNIGHT_RANK_2, (Object)new SkillNode(new Holder[]{BLOODKNIGHT_RANK_2}));
            context.register(BLOODKNIGHT_RANK_3, (Object)new SkillNode(new Holder[]{BLOODKNIGHT_RANK_3}));
            context.register(BLOODKNIGHT_RANK_4, (Object)new SkillNode(new Holder[]{BLOODKNIGHT_RANK_4}));
            context.register(BLOODKNIGHT_STILL_BLOOD, (Object)new SkillNode(new Holder[]{BLOODKNIGHT_STILL_BLOOD}));
            context.register(BLOODKNIGHT_FEIGNED_MERCY, (Object)new SkillNode(new Holder[]{BLOODKNIGHT_FEIGNED_MERCY}));
            context.register(BLOODKNIGHT_FEEDING_FRENZY_1, (Object)new SkillNode(new Holder[]{BLOODKNIGHT_FEEDING_FRENZY_1}));
            context.register(BLOODKNIGHT_FEEDING_FRENZY_2, (Object)new SkillNode(new Holder[]{BLOODKNIGHT_FEEDING_FRENZY_2}));
            context.register(BLOODKNIGHT_BLOOD_HUNT, (Object)new SkillNode(new Holder[]{BLOODKNIGHT_BLOOD_HUNT}));
            context.register(BLOODKNIGHT_SANGUINE_INFUSION, (Object)new SkillNode(new Holder[]{BLOODKNIGHT_SANGUINE_INFUSION}));
            context.register(BLOODKNIGHT_CRIMSON_LEAP, (Object)new SkillNode(new Holder[]{BLOODKNIGHT_CRIMSON_LEAP}));
            context.register(BLOODKNIGHT_VAMPIRE_BLOOD_BONUS, (Object)new SkillNode(new Holder[]{BLOODKNIGHT_VAMPIRE_BLOOD_BONUS}));
            context.register(BLOODKNIGHT_HASTE_STEP_INFUSION, (Object)new SkillNode(new Holder[]{BLOODKNIGHT_INFUSION_HASTE, BLOODKNIGHT_INFUSION_STEP_ASSIST}));
            context.register(BLOODKNIGHT_SAPPING_STRIKE, (Object)new SkillNode(new Holder[]{BLOODKNIGHT_SAPPING_STRIKE}));
            context.register(BLOODKNIGHT_DAY_WALKER, (Object)new SkillNode(new Holder[]{BLOODKNIGHT_DAY_WALKER}));
            context.register(BLOODKNIGHT_BAT_FRENZY, (Object)new SkillNode(new Holder[]{BLOODKNIGHT_BAT_FRENZY}));
            context.register(BLOODKNIGHT_BLOOD_EXTRACTION, (Object)new SkillNode(new Holder[]{BLOODKNIGHT_BLOOD_EXTRACTION}));
            context.register(BLOODKNIGHT_HIDDEN_STRIKE, (Object)new SkillNode(new Holder[]{BLOODKNIGHT_HIDDEN_STRIKE}));
            context.register(BLOODKNIGHT_FRENZIED_ATTACKS, (Object)new SkillNode(new Holder[]{BLOODKNIGHT_FRENZIED_STRIKES}));
            context.register(GRAVEBOUND_RANK_2, (Object)new SkillNode(new Holder[]{GRAVEBOUND_RANK_2}));
            context.register(GRAVEBOUND_RANK_3, (Object)new SkillNode(new Holder[]{GRAVEBOUND_RANK_3}));
            context.register(GRAVEBOUND_RANK_4, (Object)new SkillNode(new Holder[]{GRAVEBOUND_RANK_4}));
            context.register(GRAVEBOUND_SOUL_INFUSION, (Object)new SkillNode(new Holder[]{GRAVEBOUND_SOUL_INFUSION}));
            context.register(GRAVEBOUND_REGEN_DEVOUR, (Object)new SkillNode(new Holder[]{GRAVEBOUND_REGEN_DEVOUR}));
            context.register(GRAVEBOUND_POWERFUL_DEVOUR, (Object)new SkillNode(new Holder[]{GRAVEBOUND_POWERFUL_DEVOUR}));
            context.register(GRAVEBOUND_SORCEROUS_STRIKE, (Object)new SkillNode(new Holder[]{GRAVEBOUND_SORCEROUS_STRIKE}));
            context.register(GRAVEBOUND_LINGERING_DEVOUR, (Object)new SkillNode(new Holder[]{GRAVEBOUND_LINGERING_DEVOUR}));
            context.register(GRAVEBOUND_SOUL_CLAIMING, (Object)new SkillNode(new Holder[]{GRAVEBOUND_SOUL_CLAIMING}));
            context.register(GRAVEBOUND_PHYLACTERY_TELEPORT, (Object)new SkillNode(new Holder[]{GRAVEBOUND_TELEPORT_SKILL}));
            context.register(GRAVEBOUND_POISON_IMMUNITY, (Object)new SkillNode(new Holder[]{GRAVEBOUND_POISON_IMMUNITY}));
            context.register(GRAVEBOUND_POISON_HEALING, (Object)new SkillNode(new Holder[]{GRAVEBOUND_POISON_HEALING}));
            context.register(GRAVEBOUND_SOUL_TRANSFER, (Object)new SkillNode(new Holder[]{GRAVEBOUND_SOUL_TRANSFER}));
            context.register(GRAVEBOUND_GHOST_WALK, (Object)new SkillNode(new Holder[]{GRAVEBOUND_GHOST_WALK_ACTION}));
            context.register(GRAVEBOUND_CHEAPER_RESURRECTION, (Object)new SkillNode(new Holder[]{GRAVEBOUND_CHEAPER_RESURRECTION}));
            context.register(GRAVEBOUND_FASTER_RESURRECTION, (Object)new SkillNode(new Holder[]{GRAVEBOUND_REDUCED_RESURRECTION_COOLDOWN}));
            context.register(GRAVEBOUND_SOUL_TRANSFER_PHYLACTERY, (Object)new SkillNode(new Holder[]{GRAVEBOUND_SOUL_PHYLACTERY_ACTION}));
            context.register(GRAVEBOUND_SOUL_SPEED, (Object)new SkillNode(new Holder[]{GRAVEBOUND_SOUL_SPEED}));
            context.register(GRAVEBOUND_UNDEAD_LORD, (Object)new SkillNode(new Holder[]{GRAVEBOUND_UNDEAD_LORD}));
            context.register(GRAVEBOUND_PASSIVE_SOUL_CLAIMING, (Object)new SkillNode(new Holder[]{GRAVEBOUND_PASSIVE_SOUL_CLAIMING}));
            context.register(GRAVEBOUND_POSSESSION_ACTION, (Object)new SkillNode(new Holder[]{GRAVEBOUND_POSSESSION_ACTION}));
            context.register(GRAVEBOUND_POSSESSION_SWAP_ACTION, (Object)new SkillNode(new Holder[]{GRAVEBOUND_POSSESSION_SWAP_ACTION}));
        }
    }

    public static class Trees {
        public static final ResourceKey<ISkillTree> NOBLE = Trees.vampTree("noble");
        public static final ResourceKey<ISkillTree> ZEALOT = Trees.vampTree("zealot");
        public static final ResourceKey<ISkillTree> ECTOTHERM = Trees.vampTree("ectotherm");
        public static final ResourceKey<ISkillTree> BLOOD_KNIGHT = Trees.vampTree("bloodknight");
        public static final ResourceKey<ISkillTree> GRAVEBOUND = Trees.hunterTree("gravebound");

        private static ResourceKey<ISkillTree> vampTree(String path) {
            return ResourceKey.create((ResourceKey)VampirismRegistries.Keys.SKILL_TREE, (ResourceLocation)Bloodlines.rl("vampire/" + path));
        }

        private static ResourceKey<ISkillTree> hunterTree(String path) {
            return ResourceKey.create((ResourceKey)VampirismRegistries.Keys.SKILL_TREE, (ResourceLocation)Bloodlines.rl("hunter/" + path));
        }

        public static void createSkillTrees(BootstrapContext<ISkillTree> context) {
            context.register(ECTOTHERM, (Object)new SkillTree(VReference.VAMPIRE_FACTION, EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)new BloodlineSubPredicate((IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get())).build(), new ItemStack((ItemLike)ModItems.PURE_BLOOD_4.asItem()), (Component)Component.translatable((String)"text.bloodlines.skills.ectotherm")));
            context.register(ZEALOT, (Object)new SkillTree(VReference.VAMPIRE_FACTION, EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)new BloodlineSubPredicate((IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get())).build(), new ItemStack((ItemLike)ModItems.PURE_BLOOD_4.asItem()), (Component)Component.translatable((String)"text.bloodlines.skills.zealot")));
            context.register(NOBLE, (Object)new SkillTree(VReference.VAMPIRE_FACTION, EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)new BloodlineSubPredicate((IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get())).build(), new ItemStack((ItemLike)ModItems.PURE_BLOOD_4.asItem()), (Component)Component.translatable((String)"text.bloodlines.skills.noble")));
            context.register(BLOOD_KNIGHT, (Object)new SkillTree(VReference.VAMPIRE_FACTION, EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)new BloodlineSubPredicate((IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get())).build(), new ItemStack((ItemLike)ModItems.PURE_BLOOD_4.asItem()), (Component)Component.translatable((String)"text.bloodlines.skills.bloodknight")));
            context.register(GRAVEBOUND, (Object)new SkillTree(VReference.HUNTER_FACTION, EntityPredicate.Builder.entity().subPredicate((EntitySubPredicate)new BloodlineSubPredicate((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get())).build(), new ItemStack((ItemLike)ModItems.PURE_BLOOD_4.asItem()), (Component)Component.translatable((String)"text.bloodlines.skills.gravebound")));
        }
    }
}

