/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.networking.packets.from_server;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ClientboundLeapPacket
implements CustomPacketPayload {
    private static ClientboundLeapPacket INSTANCE;
    public static final CustomPacketPayload.Type<ClientboundLeapPacket> TYPE;
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundLeapPacket> CODEC;

    private ClientboundLeapPacket() {
    }

    public static ClientboundLeapPacket getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ClientboundLeapPacket();
        }
        return INSTANCE;
    }

    @NotNull
    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull @NotNull CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleLeapPacket(ClientboundLeapPacket ignoredUseless, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            double distanceMult = (Double)CommonConfig.ectothermDolphinLeapDistance.get();
            Vec3 vec = player.getViewVector(1.0f);
            player.setDeltaMovement(new Vec3(vec.x * distanceMult, vec.y * distanceMult, player.getLookAngle().z * distanceMult));
        });
    }

    static {
        TYPE = new CustomPacketPayload.Type(Bloodlines.rl("leap"));
        CODEC = StreamCodec.unit((Object)ClientboundLeapPacket.getInstance());
    }
}

