/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.networking.packets.from_client;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.blocks.SpecialIceBlock;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlinesPlayerAttributes;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.BloodlineFrost;
import com.thedrofdoctoring.bloodlines.core.BloodlinesBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ServerboundIcePacket
implements CustomPacketPayload {
    private static ServerboundIcePacket INSTANCE;
    public static final CustomPacketPayload.Type<ServerboundIcePacket> TYPE;
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundIcePacket> CODEC;

    private ServerboundIcePacket() {
    }

    public static ServerboundIcePacket getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ServerboundIcePacket();
        }
        return INSTANCE;
    }

    @NotNull
    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull @NotNull CustomPacketPayload.Type<ServerboundIcePacket> type() {
        return TYPE;
    }

    public static void handleIcePacket(ServerboundIcePacket ignoredData, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            Level level = context.player().level();
            HitResult result = player.pick(10.0, 1.0f, true);
            if (!(result instanceof BlockHitResult)) {
                return;
            }
            BlockHitResult blockResult = (BlockHitResult)result;
            BlockPos pos = blockResult.getBlockPos();
            if (level.getBlockState(pos).is(Blocks.WATER)) {
                BlockPos[] possiblePositions = new BlockPos[]{new BlockPos(pos.getX(), pos.getY(), pos.getZ() + 1), new BlockPos(pos.getX(), pos.getY(), pos.getZ() - 1), new BlockPos(pos.getX() + 1, pos.getY(), pos.getZ()), new BlockPos(pos.getX() - 1, pos.getY(), pos.getZ())};
                FluidState fState = level.getFluidState(pos);
                BlockState wasSource = (BlockState)((SpecialIceBlock)((Object)((Object)BloodlinesBlocks.ICE_BLOCK.get()))).defaultBlockState().setValue((Property)SpecialIceBlock.WAS_WATER, (Comparable)Boolean.valueOf(true));
                BlockState notSource = (BlockState)((SpecialIceBlock)((Object)((Object)BloodlinesBlocks.ICE_BLOCK.get()))).defaultBlockState().setValue((Property)SpecialIceBlock.WAS_WATER, (Comparable)Boolean.valueOf(false));
                BloodlineFrost.SpecialAttributes atts = BloodlinesPlayerAttributes.get(player).getEctothermAtts();
                if (atts.icePhasing && atts.frostControl) {
                    level.setBlock(pos, fState.isSource() ? wasSource : notSource, 3);
                    for (BlockPos possiblePos : possiblePositions) {
                        if (!level.getBlockState(possiblePos).is(Blocks.WATER)) continue;
                        level.setBlock(possiblePos, fState.isSource() ? wasSource : notSource, 3);
                    }
                }
            }
        });
    }

    static {
        TYPE = new CustomPacketPayload.Type(Bloodlines.rl("ice"));
        CODEC = StreamCodec.unit((Object)ServerboundIcePacket.getInstance());
    }
}

