/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.mixin;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.config.HunterBloodlinesConfig;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkills;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModTags;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager {
    @Shadow
    public abstract VillagerData getVillagerData();

    public VillagerMixin(EntityType<? extends AbstractVillager> vil, Level level) {
        super(vil, level);
    }

    @Inject(method={"updateSpecialPrices"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/npc/Villager;getPlayerReputation(Lnet/minecraft/world/entity/player/Player;)I")})
    private void updateSpecialPrices(Player player, CallbackInfo ci) {
        block5: {
            int rank;
            IBloodline bloodline;
            block8: {
                block7: {
                    block6: {
                        if (BuiltInRegistries.VILLAGER_PROFESSION.wrapAsHolder((Object)this.getVillagerData().getProfession()).is(ModTags.Professions.HAS_FACTION)) break block5;
                        bloodline = BloodlineManager.get(player).getBloodline();
                        rank = BloodlineManager.get(player).getRank() - 1;
                        if (bloodline == null) {
                            return;
                        }
                        if (bloodline.getSkillHandler(player) == null || !bloodline.getSkillHandler(player).isSkillEnabled((ISkill)BloodlineSkills.NOBLE_BETTER_TRADE_PRICES.get())) break block6;
                        for (MerchantOffer merchantoffer1 : this.getOffers()) {
                            double rankMult = ((Double)((List)CommonConfig.nobleTradePricesMultiplier.get()).get(rank)).floatValue();
                            int diff = (rankMult = 1.0 - rankMult) != 0.0 ? (int)Math.floor((double)merchantoffer1.getBaseCostA().getCount() * (rankMult - 1.0)) : 0;
                            merchantoffer1.addToSpecialPriceDiff(diff);
                        }
                        break block5;
                    }
                    if (bloodline != BloodlineRegistry.BLOODLINE_ZEALOT.get()) break block7;
                    for (MerchantOffer merchantoffer1 : this.getOffers()) {
                        double rankMult = ((Double)((List)CommonConfig.zealotTradePricesMultiplier.get()).get(rank)).floatValue();
                        int diff = rankMult != 0.0 ? (int)Math.floor((double)merchantoffer1.getBaseCostA().getCount() * (rankMult - 1.0)) : 0;
                        merchantoffer1.addToSpecialPriceDiff(diff);
                    }
                    break block5;
                }
                if (bloodline != BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get()) break block8;
                for (MerchantOffer merchantoffer1 : this.getOffers()) {
                    double rankMult = ((Double)((List)CommonConfig.bloodknightTradePricesMultiplier.get()).get(rank)).floatValue();
                    int diff = rankMult != 0.0 ? (int)Math.floor((double)merchantoffer1.getBaseCostA().getCount() * (rankMult - 1.0)) : 0;
                    merchantoffer1.addToSpecialPriceDiff(diff);
                }
                break block5;
            }
            if (bloodline != BloodlineRegistry.BLOODLINE_GRAVEBOUND.get()) break block5;
            for (MerchantOffer merchantoffer1 : this.getOffers()) {
                double rankMult = ((Double)((List)HunterBloodlinesConfig.graveboundTradePricesMultiplier.get()).get(rank)).floatValue();
                int diff = rankMult != 0.0 ? (int)Math.floor((double)merchantoffer1.getBaseCostA().getCount() * (rankMult - 1.0)) : 0;
                merchantoffer1.addToSpecialPriceDiff(diff);
            }
        }
    }
}

