/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.IVampSpecialAttributes;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkills;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.entity.player.FactionBasePlayer;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayerSpecialAttributes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={VampirePlayer.class})
public abstract class VampirePlayerMixin
extends FactionBasePlayer<IVampirePlayer>
implements IVampirePlayer {
    @Shadow
    private boolean sundamage_cache;
    @Unique
    private final int bloodlines$sunTicksPerIncrease = (Integer)CommonConfig.sunTicksPerIncrease.get();

    @Shadow
    @NotNull
    public abstract ISkillHandler<IVampirePlayer> getSkillHandler();

    @Shadow
    @NotNull
    public abstract VampirePlayerSpecialAttributes getSpecialAttributes();

    public VampirePlayerMixin(Player player) {
        super(player);
    }

    @WrapOperation(method={"handleSunDamage"}, at={@At(value="FIELD", target="Lde/teamlapen/vampirism/entity/player/vampire/VampirePlayer;ticksInSun:I", opcode=181, ordinal=0)})
    private void modifyTicksInSun(VampirePlayer instance, int value, Operation<Void> original) {
        if (this.player.tickCount % this.bloodlines$sunTicksPerIncrease == 0 && ((IVampSpecialAttributes)this.getSpecialAttributes()).bloodlines$getSlowSun()) {
            original.call(new Object[]{instance, value + 1});
        } else if (!((IVampSpecialAttributes)this.getSpecialAttributes()).bloodlines$getSlowSun()) {
            original.call(new Object[]{instance, value + 1});
        }
        if (BloodlineManager.get(this.player).getBloodline() == BloodlineRegistry.BLOODLINE_ZEALOT.get() && BloodlineManager.get(this.player).getRank() >= (Integer)CommonConfig.zealotDoubleSunTickRank.get()) {
            original.call(new Object[]{instance, value + 1});
        }
    }

    @Inject(method={"isGettingSundamage"}, at={@At(value="RETURN")}, cancellable=true)
    private void ectothermDiffraction(LevelAccessor iWorld, boolean forcerefresh, CallbackInfoReturnable<Boolean> cir) {
        if (((IVampSpecialAttributes)this.getSpecialAttributes()).bloodlines$getRefraction()) {
            BlockPos eyePos = BlockPos.containing((Position)this.player.getEyePosition());
            if (this.player.level().getBlockState(eyePos).is(Blocks.WATER)) {
                this.sundamage_cache = false;
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"onUpdate"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;setAirSupply(I)V", ordinal=1)}, remap=false)
    public void nobleWorsenedWaterEffects(CallbackInfo ci) {
        if (((Boolean)CommonConfig.nobleWaterWeakness.get()).booleanValue() && this.getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.NOBLE_RANK_3.get()) && this.player.tickCount % 16 == 4 && !this.player.getAbilities().instabuild && this.player.isInWater()) {
            Level world = this.player.getCommandSenderWorld();
            FluidState state1 = world.getFluidState(this.player.blockPosition());
            FluidState state2 = world.getFluidState(this.player.blockPosition().above());
            if (state1.is(FluidTags.WATER) && state1.getFlow((BlockGetter)world, this.player.blockPosition()).lengthSqr() > 0.0 || state2.is(FluidTags.WATER) && state2.getFlow((BlockGetter)world, this.player.blockPosition().above()).lengthSqr() > 0.0) {
                int amplifier = this.getSpecialAttributes().waterResistance ? 1 : 2;
                this.player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 80, amplifier));
            }
        }
    }
}

