/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlinesPlayerAttributes;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.IBloodlinesPlayer;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import com.thedrofdoctoring.bloodlines.data.BloodlinesTagsProviders;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements IBloodlinesPlayer {
    @Unique
    private final BloodlinesPlayerAttributes bloodlines$bloodlinesPlayerAttributes = new BloodlinesPlayerAttributes();

    protected PlayerMixin(EntityType<? extends LivingEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @ModifyReturnValue(method={"getBlockSpeedFactor"}, at={@At(value="RETURN")})
    private float zealotStoneSpeed(float originalSpeed) {
        Player player = (Player)this;
        IBloodline bloodline = this.bloodlines$bloodlinesPlayerAttributes.bloodline;
        if (bloodline == BloodlineRegistry.BLOODLINE_ZEALOT.get() && this.bloodlines$onStone(player)) {
            float speedMultiplier = this.bloodlines$bloodlinesPlayerAttributes.getZealotAtts().stoneSpeed;
            return originalSpeed * speedMultiplier;
        }
        if (bloodline == BloodlineRegistry.BLOODLINE_GRAVEBOUND.get() && this.bloodlines$soulSpeed(player)) {
            float speedMultiplier = this.bloodlines$bloodlinesPlayerAttributes.getGraveboundData().soulSpeed;
            return originalSpeed * speedMultiplier;
        }
        return originalSpeed;
    }

    @Unique
    private boolean bloodlines$onStone(Player player) {
        return player.level().getBlockState(player.getOnPos()).is(BloodlinesTagsProviders.BloodlinesBlockTagProvider.ZEALOT_STONE);
    }

    @Unique
    private boolean bloodlines$soulSpeed(Player player) {
        return player.level().getBlockState(player.getOnPos()).is(BlockTags.SOUL_SPEED_BLOCKS);
    }

    @Override
    @Unique
    public BloodlinesPlayerAttributes bloodlines$getBloodlinesAtts() {
        return this.bloodlines$bloodlinesPlayerAttributes;
    }
}

