/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.items;

import com.thedrofdoctoring.bloodlines.blocks.entities.PhylacteryBlockEntity;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.hunter.BloodlineGravebound;
import com.thedrofdoctoring.bloodlines.core.BloodlinesBlocks;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class SoulBinderItem
extends Item {
    private boolean forceBind;

    public SoulBinderItem(boolean creative) {
        super(new Item.Properties().stacksTo(1));
        if (creative) {
            this.forceBind = true;
        }
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext pContext) {
        Level level = pContext.getLevel();
        BlockPos pos = pContext.getClickedPos();
        BlockState target = level.getBlockState(pos);
        if (!level.isClientSide && target.is(BloodlinesBlocks.PHYLACTERY) && pContext.getPlayer() != null) {
            BlockEntity be = level.getBlockEntity(pos);
            Player user = pContext.getPlayer();
            BloodlineManager manager = BloodlineManager.get(user);
            IBloodline bloodline = manager.getBloodline();
            if (be instanceof PhylacteryBlockEntity) {
                PhylacteryBlockEntity phylactery = (PhylacteryBlockEntity)be;
                if (bloodline == BloodlineRegistry.BLOODLINE_GRAVEBOUND.get() && manager.getBloodlineState().isPresent()) {
                    Player owner = phylactery.getOwner();
                    BloodlineGravebound.State state = (BloodlineGravebound.State)manager.getBloodlineState().get();
                    if (!phylactery.hasOwner() && !state.hasPhylactery()) {
                        phylactery.setOwner(user);
                        state.setPhylactery(pos, level.dimension().location());
                        user.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.phylactery_bound", (Object[])new Object[]{pos.toShortString()}), true);
                        manager.sync(false);
                        state.updateCache(manager.getRank());
                        return InteractionResult.SUCCESS;
                    }
                    if (phylactery.getOwnerUUID().equals(user.getUUID())) {
                        int amount;
                        int n = amount = user.isShiftKeyDown() ? 5 : 1;
                        if (state.getSouls() <= 0) {
                            return InteractionResult.SUCCESS;
                        }
                        int used = state.addSouls(-amount);
                        int usedAfter = phylactery.addSouls(used);
                        state.addSouls(used - usedAfter);
                        int remaining = phylactery.getStoredSouls();
                        state.updateCache(manager.getRank());
                        phylactery.setChanged();
                        if (remaining == phylactery.getMaxStoredSouls()) {
                            user.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.phylactery_max", (Object[])new Object[]{remaining}), true);
                        } else {
                            user.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.phylactery_souls", (Object[])new Object[]{remaining}), true);
                        }
                        manager.sync(false);
                        user.getCooldowns().addCooldown((Item)this, 10);
                        return InteractionResult.SUCCESS;
                    }
                    if (this.forceBind) {
                        BloodlineManager ownerBloodline;
                        boolean shouldRebind;
                        boolean bl = shouldRebind = !user.isShiftKeyDown();
                        if (phylactery.hasOwner() && (ownerBloodline = BloodlineManager.get(owner)).getBloodlineState().isPresent() && ownerBloodline.getBloodline() == BloodlineRegistry.BLOODLINE_GRAVEBOUND.get()) {
                            BloodlineGravebound.State ownerState = (BloodlineGravebound.State)ownerBloodline.getBloodlineState().get();
                            ownerState.removePhylactery();
                        }
                        if (shouldRebind) {
                            BlockEntity old;
                            if (state.getPhylacteryPos() != null && (old = level.getBlockEntity(state.getPhylacteryPos())) instanceof PhylacteryBlockEntity) {
                                PhylacteryBlockEntity oldPhylactery = (PhylacteryBlockEntity)old;
                                oldPhylactery.setOwner(null);
                            }
                            phylactery.setOwner(user);
                            state.setPhylactery(pos, level.dimension().location());
                            user.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.phylactery_bound", (Object[])new Object[]{pos.toShortString()}), true);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    manager.sync(false);
                    state.updateCache(manager.getRank());
                    phylactery.setChanged();
                    phylactery.requestModelDataUpdate();
                }
            }
        }
        return super.useOn(pContext);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        if (BloodlineHelper.hasBloodline((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), pPlayer)) {
            boolean hasPhylactery;
            BloodlineGravebound.State state = BloodlineGravebound.getGraveboundState(pPlayer);
            if (state == null) {
                return super.use(pLevel, pPlayer, pUsedHand);
            }
            boolean bl = hasPhylactery = state.getPhylacteryPos() != null;
            if (hasPhylactery && state.getPhylacteryDimension() != null) {
                ResourceLocation currentDimension = pLevel.dimension().location();
                ResourceLocation phylacteryDimension = state.getPhylacteryDimension();
                if (phylacteryDimension.equals((Object)currentDimension)) {
                    pPlayer.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.phylactery_location", (Object[])new Object[]{state.getPhylacteryPos().toShortString()}), true);
                } else {
                    pPlayer.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.phylactery_wrong_dimension"), true);
                }
            }
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }
}

