/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.items;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.BloodlineNoble;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class LordslayerInjectionItem
extends Item {
    public LordslayerInjectionItem(Item.Properties pProperties) {
        super(pProperties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hurtEnemy(@NotNull ItemStack pStack, @NotNull LivingEntity pTarget, @NotNull LivingEntity pAttacker) {
        if (pAttacker instanceof Player) {
            Player player = (Player)pAttacker;
            if (pTarget instanceof VampireBaronEntity && ((Boolean)CommonConfig.nobleUniqueUnlock.get()).booleanValue()) {
                float healthPercent = pTarget.getHealth() / pTarget.getMaxHealth();
                int lordRank = FactionPlayerHandler.get((Player)player).getLordLevel();
                IBloodline bloodline = BloodlineManager.get(player).getBloodline();
                if (!Helper.isVampire((Player)player) || lordRank < (Integer)CommonConfig.nobleLordSlayerMinLordRank.get() || bloodline != null || !pTarget.hasEffect(MobEffects.WEAKNESS) || !(healthPercent <= ((Double)CommonConfig.nobleLordslayerBaronHealth.get()).floatValue())) return super.hurtEnemy(pStack, pTarget, pAttacker);
                pTarget.kill();
                pStack.shrink(1);
                BloodlineHelper.joinBloodlineGeneric(player, (IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get(), (Component)Component.translatable((String)"text.bloodlines.noble_join").withStyle(ChatFormatting.DARK_RED));
                return false;
            }
        }
        pAttacker.sendSystemMessage((Component)Component.translatable((String)"text.bloodlines.join_method_disabled", (Object[])new Object[]{((BloodlineNoble)BloodlineRegistry.BLOODLINE_NOBLE.get()).getName()}));
        return super.hurtEnemy(pStack, pTarget, pAttacker);
    }
}

