/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.items;

import com.thedrofdoctoring.bloodlines.core.BloodlinesComponents;
import com.thedrofdoctoring.bloodlines.items.attachments.ChaliceBlood;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.items.BloodBottleFluidHandler;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class BottomlessChaliceFluidHandler
extends BloodBottleFluidHandler {
    public BottomlessChaliceFluidHandler(@NotNull ItemStack container, int capacity) {
        super(container, capacity);
    }

    @NotNull
    public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
        int currentAmt = this.getBlood(this.container);
        if (currentAmt == 0) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = new FluidStack((Fluid)ModFluids.BLOOD.get(), Math.min(currentAmt, BottomlessChaliceFluidHandler.getAdjustedAmount((int)maxDrain)));
        if (action.execute()) {
            this.setBlood(this.container, currentAmt - stack.getAmount());
        }
        return stack;
    }

    public void setBlood(@NotNull ItemStack stack, int amt) {
        stack.set((DataComponentType)BloodlinesComponents.CHALICE_BLOOD.get(), (Object)new ChaliceBlood(amt /= 100));
    }

    public int getBlood(@NotNull ItemStack stack) {
        return ((ChaliceBlood)stack.getOrDefault((DataComponentType)BloodlinesComponents.CHALICE_BLOOD.get(), (Object)ChaliceBlood.EMPTY)).blood() * 100;
    }
}

