/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.items;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodlineManager;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class BloodlineTesterItem
extends Item {
    public BloodlineTesterItem(Item.Properties props) {
        super(props);
    }

    public boolean hurtEnemy(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity source) {
        Optional<IBloodlineManager> optManager = BloodlineHelper.getBloodlineData(target);
        if (source instanceof Player) {
            Player player = (Player)source;
            if (optManager.isPresent()) {
                IBloodlineManager blManager = optManager.get();
                String bloodlineName = blManager.getBloodline().getName();
                player.sendSystemMessage((Component)Component.translatable((String)"text.bloodlines.creature_bloodline", (Object[])new Object[]{bloodlineName, blManager.getRank()}));
            }
        }
        return true;
    }

    public void appendHoverText(@NotNull ItemStack pStack, @NotNull Item.TooltipContext pContext, List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
        pTooltipComponents.add((Component)Component.translatable((String)"text.bloodlines.blood_tester_usage").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }
}

