/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.items;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BloodlineFang
extends Item {
    private final ResourceLocation bloodlineId;

    public BloodlineFang(Item.Properties props, ResourceLocation bloodlineId) {
        super(props);
        this.bloodlineId = bloodlineId;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        IBloodline bloodline = BloodlineHelper.getBloodlineById(this.bloodlineId);
        if (bloodline != null) {
            BloodlineManager bl = BloodlineManager.get(player);
            IPlayableFaction faction = FactionPlayerHandler.get((Player)player).getCurrentFaction();
            if (faction == null) {
                player.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.need_faction"), true);
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)player.getItemInHand(hand));
            }
            if (bl.getBloodline() != null) {
                player.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.bloodline_active"), true);
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)player.getItemInHand(hand));
            }
            if (bloodline.getFaction() != faction) {
                player.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.wrong_faction", (Object[])new Object[]{faction.getNamePlural()}), true);
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)player.getItemInHand(hand));
            }
            BloodlineHelper.joinBloodlineGeneric(player, bloodline, (Component)Component.translatable((String)"text.bloodlines.new_bloodline", (Object[])new Object[]{bloodline.getName()}).withStyle(ChatFormatting.DARK_RED));
            player.getItemInHand(hand).shrink(1);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
    }
}

