/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.entity.entities;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlinesPlayerAttributes;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.hunter.BloodlineGravebound;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class LingeringDevourEntity
extends AreaEffectCloud {
    public LingeringDevourEntity(Level pLevel, double pX, double pY, double pZ) {
        super(pLevel, pX, pY, pZ);
    }

    public LingeringDevourEntity(EntityType<? extends LingeringDevourEntity> entityEntityType, Level level) {
        super(entityEntityType, level);
    }

    public void tick() {
        LivingEntity livingEntity;
        super.tick();
        if (this.getOwner() != null && !this.victims.isEmpty() && (livingEntity = this.getOwner()) instanceof Player) {
            Player owner = (Player)livingEntity;
            IBloodline bloodline = BloodlinesPlayerAttributes.get((Player)owner).bloodline;
            if (bloodline instanceof BloodlineGravebound) {
                BloodlineGravebound gravebound = (BloodlineGravebound)bloodline;
                this.victims.forEach((entity, i) -> {
                    if (owner != entity && gravebound.canDevour((Entity)entity, owner, true, false)) {
                        gravebound.devour((LivingEntity)entity, owner);
                    }
                });
            }
        }
    }
}

