/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.entity;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.IVampSpecialAttributes;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.util.Helper;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class MesmeriseGoal
extends Goal {
    private static final TargetingConditions TEMP_TARGETING = TargetingConditions.forNonCombat().range(15.0).ignoreLineOfSight();
    private final TargetingConditions targetingConditions;
    protected final PathfinderMob mob;
    private Player player;
    private double px;
    private double py;
    private double pz;
    private double pRotX;
    private double pRotY;

    public MesmeriseGoal(PathfinderMob mob) {
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.targetingConditions = TEMP_TARGETING.copy().selector(this::shouldFollow);
    }

    private boolean shouldFollow(LivingEntity mob) {
        if (mob instanceof Player) {
            Player p = (Player)mob;
            if (Helper.isVampire((Entity)mob)) {
                IVampSpecialAttributes specialAttributes = (IVampSpecialAttributes)VampirismPlayerAttributes.get((Player)p).getVampSpecial();
                return specialAttributes.bloodlines$getMesmerise();
            }
        }
        return false;
    }

    public boolean canUse() {
        this.player = this.mob.level().getNearestPlayer(this.targetingConditions, (LivingEntity)this.mob);
        return this.player != null;
    }

    public boolean canContinueToUse() {
        if (this.mob.distanceToSqr((Entity)this.player) < 40.0) {
            if (this.player.distanceToSqr(this.px, this.py, this.pz) > 0.01) {
                return false;
            }
            if (Math.abs((double)this.player.getXRot() - this.pRotX) > 5.0 || Math.abs((double)this.player.getYRot() - this.pRotY) > 5.0) {
                return false;
            }
        } else {
            this.px = this.player.getX();
            this.py = this.player.getY();
            this.pz = this.player.getZ();
        }
        this.pRotX = this.player.getXRot();
        this.pRotY = this.player.getYRot();
        return this.canUse();
    }

    public void start() {
        this.px = this.player.getX();
        this.py = this.player.getY();
        this.pz = this.player.getZ();
    }

    public void stop() {
        this.player = null;
        this.mob.getNavigation().stop();
    }

    public void tick() {
        this.mob.getLookControl().setLookAt((Entity)this.player, (float)(this.mob.getMaxHeadYRot() + 20), (float)this.mob.getMaxHeadXRot());
        if (this.mob.distanceToSqr((Entity)this.player) < 2.25) {
            this.mob.getNavigation().stop();
        } else {
            this.mob.getNavigation().moveTo((Entity)this.player, 0.6);
        }
    }
}

