/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.data.spawn_modifiers;

import com.mojang.datafixers.util.Pair;
import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import com.thedrofdoctoring.bloodlines.data.BloodlinesData;
import com.thedrofdoctoring.bloodlines.data.BloodlinesTagsProviders;
import com.thedrofdoctoring.bloodlines.data.spawn_modifiers.BloodlineSpawnModifier;
import de.teamlapen.vampirism.core.ModEntities;
import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.EntityType;
import net.neoforged.neoforge.common.Tags;

public class BloodlinesSpawnModifiers {
    public static final ResourceKey<BloodlineSpawnModifier> BLOODLINE_NOBLE_SPAWN_MODIFIER = ResourceKey.create(BloodlinesData.BLOODLINE_SPAWN_MODIFIERS, (ResourceLocation)Bloodlines.rl("noble_spawn_modifier"));
    public static final ResourceKey<BloodlineSpawnModifier> BLOODLINE_ECTOTHERM_SPAWN_MODIFIER = ResourceKey.create(BloodlinesData.BLOODLINE_SPAWN_MODIFIERS, (ResourceLocation)Bloodlines.rl("ectotherm_spawn_modifier"));
    public static final ResourceKey<BloodlineSpawnModifier> BLOODLINE_ZEALOT_SPAWN_MODIFIER = ResourceKey.create(BloodlinesData.BLOODLINE_SPAWN_MODIFIERS, (ResourceLocation)Bloodlines.rl("zealot_spawn_modifier"));
    public static final ResourceKey<BloodlineSpawnModifier> BLOODLINE_BLOODKNIGHT_SPAWN_MODIFIERS = ResourceKey.create(BloodlinesData.BLOODLINE_SPAWN_MODIFIERS, (ResourceLocation)Bloodlines.rl("bloodknight_spawn_modifier"));

    public static void createSpawnModifiers(BootstrapContext<BloodlineSpawnModifier> context) {
        HolderGetter biomeLookup = context.lookup(Registries.BIOME);
        context.register(BLOODLINE_NOBLE_SPAWN_MODIFIER, (Object)new BloodlineSpawnModifier((IBloodline)BloodlineRegistry.BLOODLINE_NOBLE.get(), List.of((EntityType)ModEntities.VAMPIRE.get(), (EntityType)ModEntities.ADVANCED_VAMPIRE.get()), List.of(Pair.of((Object)biomeLookup.getOrThrow(BiomeTags.IS_OVERWORLD), (Object)45), Pair.of((Object)biomeLookup.getOrThrow(BloodlinesTagsProviders.BloodlinesBiomeTagProvider.NOBLE_BIOMES), (Object)100)), (Pair<Integer, Integer>)Pair.of((Object)60, (Object)-25)));
        context.register(BLOODLINE_BLOODKNIGHT_SPAWN_MODIFIERS, (Object)new BloodlineSpawnModifier((IBloodline)BloodlineRegistry.BLOODLINE_BLOODKNIGHT.get(), List.of((EntityType)ModEntities.VAMPIRE.get(), (EntityType)ModEntities.ADVANCED_VAMPIRE.get()), List.of(Pair.of((Object)biomeLookup.getOrThrow(BiomeTags.IS_OVERWORLD), (Object)15), Pair.of((Object)biomeLookup.getOrThrow(Tags.Biomes.IS_HOT_OVERWORLD), (Object)20)), (Pair<Integer, Integer>)Pair.of((Object)60, (Object)-25)));
        context.register(BLOODLINE_ECTOTHERM_SPAWN_MODIFIER, (Object)new BloodlineSpawnModifier((IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get(), List.of((EntityType)ModEntities.VAMPIRE.get(), (EntityType)ModEntities.ADVANCED_VAMPIRE.get()), List.of(Pair.of((Object)biomeLookup.getOrThrow(Tags.Biomes.IS_HOT), (Object)-100), Pair.of((Object)biomeLookup.getOrThrow(BiomeTags.IS_OVERWORLD), (Object)25), Pair.of((Object)biomeLookup.getOrThrow(BiomeTags.IS_OCEAN), (Object)50), Pair.of((Object)biomeLookup.getOrThrow(Tags.Biomes.IS_COLD), (Object)50)), (Pair<Integer, Integer>)Pair.of((Object)60, (Object)-50)));
        context.register(BLOODLINE_ZEALOT_SPAWN_MODIFIER, (Object)new BloodlineSpawnModifier((IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get(), List.of((EntityType)ModEntities.VAMPIRE.get(), (EntityType)ModEntities.ADVANCED_VAMPIRE.get()), List.of(Pair.of((Object)biomeLookup.getOrThrow(Tags.Biomes.IS_UNDERGROUND), (Object)100), Pair.of((Object)biomeLookup.getOrThrow(BiomeTags.IS_OVERWORLD), (Object)-50), Pair.of((Object)biomeLookup.getOrThrow(BiomeTags.HAS_ANCIENT_CITY), (Object)100)), (Pair<Integer, Integer>)Pair.of((Object)40, (Object)500)));
    }
}

