/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.data.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thedrofdoctoring.bloodlines.data.loot.BloodlinesLoot;
import java.util.Optional;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.NotNull;

public class MatchWeapon
implements LootItemCondition {
    public static final MapCodec<MatchWeapon> CODEC = RecordCodecBuilder.mapCodec(p -> p.group((App)ItemPredicate.CODEC.optionalFieldOf("weapon_predicate").forGetter(e -> e.weaponPredicate)).apply((Applicative)p, MatchWeapon::new));
    private final Optional<ItemPredicate> weaponPredicate;

    private MatchWeapon(Optional<ItemPredicate> weaponPredicate) {
        this.weaponPredicate = weaponPredicate;
    }

    public MatchWeapon(ItemPredicate.Builder predicateBuilder) {
        this.weaponPredicate = Optional.of(predicateBuilder.build());
    }

    @NotNull
    public LootItemConditionType getType() {
        return (LootItemConditionType)BloodlinesLoot.MATCH_WEAPON.get();
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.getParamOrNull(LootContextParams.ATTACKING_ENTITY);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ItemStack stack = living.getMainHandItem();
            return this.weaponPredicate.isEmpty() || this.weaponPredicate.get().test(stack);
        }
        return false;
    }
}

