/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.data.loot;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.core.BloodlinesItems;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class BloodlinesLootProvider {
    private static final Set<ResourceKey<LootTable>> LOOT_TABLES = Sets.newHashSet();
    public static final ResourceKey<LootTable> CORRUPTED_BLOOD_CHEST_TABLE = BloodlinesLootProvider.register("chests/corrupted_blood");
    public static final ResourceKey<LootTable> CORRUPTED_BLOOD_ENTITY_TABLE = BloodlinesLootProvider.register("entities/corrupted_blood");
    public static final ResourceKey<LootTable> FROZEN_BLOOD_ENTITY_TABLE = BloodlinesLootProvider.register("entities/frozen_blood");

    @NotNull
    public static Set<ResourceKey<LootTable>> getLootTables() {
        return ImmutableSet.copyOf(LOOT_TABLES);
    }

    @NotNull
    static ResourceKey<LootTable> register(@NotNull String resourceName) {
        return BloodlinesLootProvider.register(Bloodlines.rl(resourceName));
    }

    @NotNull
    static ResourceKey<LootTable> register(@NotNull ResourceLocation resourceLocation) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)resourceLocation);
        LOOT_TABLES.add((ResourceKey<LootTable>)key);
        return key;
    }

    public static LootTableProvider getProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProviderFuture) {
        return new LootTableProvider(output, BloodlinesLootProvider.getLootTables(), List.of(new LootTableProvider.SubProviderEntry(BloodlinesGenericLootTables::new, LootContextParamSets.CHEST), new LootTableProvider.SubProviderEntry(BloodlinesInjectEntityLootTables::new, LootContextParamSets.ENTITY)), lookupProviderFuture);
    }

    private record BloodlinesGenericLootTables(HolderLookup.Provider registries) implements LootTableSubProvider
    {
        public void generate(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> builder) {
            builder.accept(CORRUPTED_BLOOD_CHEST_TABLE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)BloodlinesItems.CORRUPTED_BLOOD_SAMPLE.get())).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(5))));
        }
    }

    private record BloodlinesInjectEntityLootTables(HolderLookup.Provider registries) implements LootTableSubProvider
    {
        public void generate(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> builder) {
            builder.accept(CORRUPTED_BLOOD_ENTITY_TABLE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)BloodlinesItems.CORRUPTED_BLOOD_SAMPLE.get())).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(20))));
            builder.accept(FROZEN_BLOOD_ENTITY_TABLE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)BloodlinesItems.FROZEN_BLOOD_SAMPLE.get())).setWeight(20).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(35))));
        }
    }
}

