/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.data;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.core.BloodlinesBlocks;
import com.thedrofdoctoring.bloodlines.core.BloodlinesDamageTypes;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkills;
import com.thedrofdoctoring.bloodlines.tasks.BloodlineTasks;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.ISkillTree;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BloodlinesTagsProviders {
    public static void register(DataGenerator gen, GatherDataEvent event, PackOutput output, CompletableFuture<HolderLookup.Provider> future, ExistingFileHelper existingFileHelper) {
        BloodlinesBlockTagProvider blockTagProvider = new BloodlinesBlockTagProvider(output, future, existingFileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)blockTagProvider);
        gen.addProvider(event.includeServer(), (DataProvider)new BloodlinesItemTagProvider(output, future, blockTagProvider.contentsGetter(), existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new BloodlinesSkillTreeProvider(output, future, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new BloodlinesEntityTypeTagsProvider(output, future, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new BloodlinesTasksTagProvider(output, future, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new BloodlinesBiomeTagProvider(output, future, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new BloodlinesDamageTypesProvider(output, future, existingFileHelper));
    }

    public static class BloodlinesBlockTagProvider
    extends BlockTagsProvider {
        public static final TagKey<Block> ZEALOT_STONE = BlockTags.create((ResourceLocation)Bloodlines.rl("zealot_stone"));
        public static final TagKey<Block> ECTOTHERM_ICE = BlockTags.create((ResourceLocation)Bloodlines.rl("ectotherm_ice"));
        public static final TagKey<Block> GHOSTWALK_BLACKLIST = BlockTags.create((ResourceLocation)Bloodlines.rl("ghostwalk_blacklist"));

        public BloodlinesBlockTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "bloodlines", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            this.tag(ZEALOT_STONE).addTag(Tags.Blocks.STONES).addTag(Tags.Blocks.COBBLESTONES).add((Object)Blocks.DRIPSTONE_BLOCK).addTag(Tags.Blocks.COBBLESTONES_DEEPSLATE);
            this.tag(ECTOTHERM_ICE).add((Object[])new Block[]{Blocks.ICE, Blocks.BLUE_ICE, Blocks.PACKED_ICE, (Block)BloodlinesBlocks.ICE_BLOCK.get()});
            this.tag(GHOSTWALK_BLACKLIST).add((Object[])new Block[]{Blocks.OBSIDIAN, Blocks.CRYING_OBSIDIAN, Blocks.BEDROCK, Blocks.BARRIER, Blocks.END_STONE, Blocks.END_PORTAL_FRAME}).addTag(BlockTags.AIR);
            this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object[])new Block[]{(Block)BloodlinesBlocks.ZEALOT_ALTAR.get(), (Block)BloodlinesBlocks.PHYLACTERY.get()});
            this.tag(BlockTags.NEEDS_DIAMOND_TOOL).add((Object[])new Block[]{(Block)BloodlinesBlocks.ZEALOT_ALTAR.get(), (Block)BloodlinesBlocks.PHYLACTERY.get()});
        }
    }

    public static class BloodlinesItemTagProvider
    extends ItemTagsProvider {
        public static final TagKey<Item> ECTOTHERM_RAW_FISH = ItemTags.create((ResourceLocation)Bloodlines.rl("ectotherm_raw_fish"));
        public static final TagKey<Item> VAMPIRE_SAMPLE_OBTAINING_WEAPONS = ItemTags.create((ResourceLocation)Bloodlines.rl("vampire_sample_obtaining_weapons"));

        public BloodlinesItemTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagsProvider, ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, blockTagsProvider, "bloodlines", existingFileHelper);
        }

        @NotNull
        public String getName() {
            return "bloodlines " + super.getName();
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            this.tag(ECTOTHERM_RAW_FISH).add((Object[])new Item[]{Items.COD, Items.SALMON, Items.TROPICAL_FISH});
            this.tag(VAMPIRE_SAMPLE_OBTAINING_WEAPONS).add((Object[])new Item[]{(Item)ModItems.STAKE.get(), (Item)ModItems.HEART_SEEKER_NORMAL.get(), (Item)ModItems.HEART_SEEKER_ENHANCED.get(), (Item)ModItems.HEART_SEEKER_ULTIMATE.get(), (Item)ModItems.HEART_STRIKER_NORMAL.get(), (Item)ModItems.HEART_STRIKER_ENHANCED.get(), (Item)ModItems.HEART_STRIKER_ULTIMATE.get()});
        }
    }

    public static class BloodlinesSkillTreeProvider
    extends TagsProvider<ISkillTree> {
        public static final TagKey<ISkillTree> BLOODLINE = TagKey.create((ResourceKey)VampirismRegistries.Keys.SKILL_TREE, (ResourceLocation)Bloodlines.rl("type/bloodline"));

        protected BloodlinesSkillTreeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, @javax.annotation.Nullable ExistingFileHelper existingFileHelper) {
            super(output, VampirismRegistries.Keys.SKILL_TREE, provider, "bloodlines", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider pProvider) {
            this.tag(ModTags.SkillTrees.VAMPIRE).add(new ResourceKey[]{BloodlineSkills.Trees.NOBLE, BloodlineSkills.Trees.ZEALOT, BloodlineSkills.Trees.ECTOTHERM, BloodlineSkills.Trees.BLOOD_KNIGHT}).replace(false);
            this.tag(BLOODLINE).add(new ResourceKey[]{BloodlineSkills.Trees.NOBLE, BloodlineSkills.Trees.ZEALOT, BloodlineSkills.Trees.ECTOTHERM, BloodlineSkills.Trees.BLOOD_KNIGHT, BloodlineSkills.Trees.GRAVEBOUND});
            this.tag(ModTags.SkillTrees.HUNTER).add(BloodlineSkills.Trees.GRAVEBOUND);
        }
    }

    public static class BloodlinesEntityTypeTagsProvider
    extends EntityTypeTagsProvider {
        public static final TagKey<EntityType<?>> POSSESSION_WHITELIST = BloodlinesEntityTypeTagsProvider.tag(Bloodlines.rl("possession_whitelist"));

        public BloodlinesEntityTypeTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @javax.annotation.Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "bloodlines", existingFileHelper);
        }

        @NotNull
        private static TagKey<EntityType<?>> tag(@NotNull ResourceLocation resourceLocation) {
            return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)resourceLocation);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider holderLookup) {
            this.tag(POSSESSION_WHITELIST).add((Object[])new EntityType[]{EntityType.ZOMBIE, EntityType.HUSK, EntityType.DROWNED, EntityType.SKELETON, EntityType.BOGGED, EntityType.SILVERFISH, EntityType.WITHER_SKELETON, EntityType.VILLAGER, EntityType.ZOMBIE_VILLAGER, EntityType.CREEPER, EntityType.WOLF, EntityType.ENDERMAN, EntityType.PHANTOM, EntityType.STRAY});
        }
    }

    private static class BloodlinesTasksTagProvider
    extends TagsProvider<Task> {
        public BloodlinesTasksTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
            super(output, VampirismRegistries.Keys.TASK, lookupProvider, "bloodlines", existingFileHelper);
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider pProvider) {
            this.tag(ModTags.Tasks.IS_UNIQUE).add(BloodlineTasks.BLOODLINE_NOBLE_1).add(BloodlineTasks.BLOODLINE_NOBLE_2).add(BloodlineTasks.BLOODLINE_NOBLE_3).add(BloodlineTasks.BLOODLINE_NOBLE_PERK_POINTS).add(BloodlineTasks.BLOODLINE_ZEALOT_1).add(BloodlineTasks.BLOODLINE_ZEALOT_2).add(BloodlineTasks.BLOODLINE_ZEALOT_3).add(BloodlineTasks.BLOODLINE_ZEALOT_PERK_POINTS).add(BloodlineTasks.BLOODLINE_ECTOTHERM_1).add(BloodlineTasks.BLOODLINE_ECTOTHERM_2).add(BloodlineTasks.BLOODLINE_ECTOTHERM_3).add(BloodlineTasks.BLOODLINE_ECTOTHERM_PERK_POINTS).add(BloodlineTasks.BLOODLINE_BLOODKNIGHT_1).add(BloodlineTasks.BLOODLINE_BLOODKNIGHT_2).add(BloodlineTasks.BLOODLINE_BLOODKNIGHT_3).add(BloodlineTasks.BLOODLINE_BLOODKNIGHT_PERK_POINTS).add(BloodlineTasks.BLOODLINE_GRAVEBOUND_1).add(BloodlineTasks.BLOODLINE_GRAVEBOUND_2).add(BloodlineTasks.BLOODLINE_GRAVEBOUND_3).add(BloodlineTasks.BLOODLINE_GRAVEBOUND_PERK_POINTS).add(BloodlineTasks.BLOODLINE_GRAVEBOUND_PERK_POINTS_2).add(BloodlineTasks.BLOODLINE_GRAVEBOUND_PERK_POINTS_3).replace(false);
            this.tag(ModTags.Tasks.IS_VAMPIRE).add(BloodlineTasks.BLOODLINE_NOBLE_1).add(BloodlineTasks.BLOODLINE_NOBLE_2).add(BloodlineTasks.BLOODLINE_NOBLE_3).add(BloodlineTasks.BLOODLINE_NOBLE_PERK_POINTS).add(BloodlineTasks.BLOODLINE_ZEALOT_1).add(BloodlineTasks.BLOODLINE_ZEALOT_2).add(BloodlineTasks.BLOODLINE_ZEALOT_3).add(BloodlineTasks.BLOODLINE_ZEALOT_PERK_POINTS).add(BloodlineTasks.BLOODLINE_ECTOTHERM_1).add(BloodlineTasks.BLOODLINE_ECTOTHERM_2).add(BloodlineTasks.BLOODLINE_ECTOTHERM_3).add(BloodlineTasks.BLOODLINE_ECTOTHERM_PERK_POINTS).add(BloodlineTasks.BLOODLINE_BLOODKNIGHT_1).add(BloodlineTasks.BLOODLINE_BLOODKNIGHT_2).add(BloodlineTasks.BLOODLINE_BLOODKNIGHT_3).add(BloodlineTasks.BLOODLINE_BLOODKNIGHT_PERK_POINTS).replace(false);
            this.tag(ModTags.Tasks.IS_HUNTER).add(BloodlineTasks.BLOODLINE_GRAVEBOUND_1).add(BloodlineTasks.BLOODLINE_GRAVEBOUND_2).add(BloodlineTasks.BLOODLINE_GRAVEBOUND_3).add(BloodlineTasks.BLOODLINE_GRAVEBOUND_PERK_POINTS).add(BloodlineTasks.BLOODLINE_GRAVEBOUND_PERK_POINTS_2).add(BloodlineTasks.BLOODLINE_GRAVEBOUND_PERK_POINTS_3).replace(false);
        }

        @NotNull
        private static TagKey<Task> tag(@NotNull String name) {
            return TagKey.create((ResourceKey)VampirismRegistries.Keys.TASK, (ResourceLocation)Bloodlines.rl(name));
        }
    }

    public static class BloodlinesBiomeTagProvider
    extends BiomeTagsProvider {
        public static final TagKey<Biome> NOBLE_BIOMES = BloodlinesBiomeTagProvider.tag("is_noble_biome");

        public BloodlinesBiomeTagProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pProvider, ExistingFileHelper existingFileHelper) {
            super(pOutput, pProvider, "bloodlines", existingFileHelper);
        }

        @NotNull
        private static TagKey<Biome> tag(@NotNull String name) {
            return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Bloodlines.rl(name));
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            this.tag(NOBLE_BIOMES).addOptional(ResourceLocation.fromNamespaceAndPath((String)"vampirism", (String)"vampire_forest"));
        }
    }

    public static class BloodlinesDamageTypesProvider
    extends TagsProvider<DamageType> {
        public static final TagKey<DamageType> GRAVEBOUND_VULNERABLE = BloodlinesDamageTypesProvider.tag("gravebound_vulnerable");

        public BloodlinesDamageTypesProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, @javax.annotation.Nullable ExistingFileHelper existingFileHelper) {
            super(output, Registries.DAMAGE_TYPE, provider, "bloodlines", existingFileHelper);
        }

        @NotNull
        private static TagKey<DamageType> tag(@NotNull String name) {
            return TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)Bloodlines.rl(name));
        }

        protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider pProvider) {
            this.tag(DamageTypeTags.BYPASSES_ARMOR).add(BloodlinesDamageTypes.DEVOUR_SOUL);
            this.tag(DamageTypeTags.BYPASSES_EFFECTS).add(BloodlinesDamageTypes.DEVOUR_SOUL);
            this.tag(DamageTypeTags.NO_KNOCKBACK).add(BloodlinesDamageTypes.DEVOUR_SOUL);
            this.tag(DamageTypeTags.BYPASSES_RESISTANCE).add(BloodlinesDamageTypes.DEVOUR_SOUL);
            this.tag(GRAVEBOUND_VULNERABLE).add(new ResourceKey[]{DamageTypes.MAGIC, DamageTypes.INDIRECT_MAGIC}).addTag(DamageTypeTags.BYPASSES_INVULNERABILITY).addOptional(VResourceLocation.mod((String)"holy_water"));
        }
    }
}

