/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.core;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.hunter.BloodlineGravebound;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.BloodlineBloodknight;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.BloodlineFrost;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.BloodlineNoble;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.BloodlineZealot;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.core.BloodlinesEffects;
import com.thedrofdoctoring.bloodlines.items.BloodlineFang;
import com.thedrofdoctoring.bloodlines.items.BloodlineTesterItem;
import com.thedrofdoctoring.bloodlines.items.BottomlessChaliceItem;
import com.thedrofdoctoring.bloodlines.items.ElixirItem;
import com.thedrofdoctoring.bloodlines.items.LordslayerInjectionItem;
import com.thedrofdoctoring.bloodlines.items.SoulBinderItem;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class BloodlinesItems {
    private static final Set<DeferredHolder<Item, ? extends Item>> creativeTabItems = new HashSet<DeferredHolder<Item, ? extends Item>>();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"bloodlines");
    public static final DeferredRegister<CreativeModeTab> BLOODLINE_CREATIVE_TAB = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"bloodlines");
    public static final ResourceKey<CreativeModeTab> BLOODLINE_TAB_KEY = ResourceKey.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (ResourceLocation)Bloodlines.rl("bloodlines"));
    public static final DeferredHolder<Item, BloodlineFang> BLOODLINE_FANG_ECTOTHERM = BloodlinesItems.register("bloodline_fang_ectotherm", () -> new BloodlineFang(new Item.Properties().stacksTo(1), BloodlineFrost.ECTOTHERM));
    public static final DeferredHolder<Item, BloodlineFang> BLOODLINE_FANG_ZEALOT = BloodlinesItems.register("bloodline_fang_zealot", () -> new BloodlineFang(new Item.Properties().stacksTo(1), BloodlineZealot.ZEALOT));
    public static final DeferredHolder<Item, BloodlineFang> BLOODLINE_FANG_BLOODKNIGHT = BloodlinesItems.register("bloodline_fang_bloodknight", () -> new BloodlineFang(new Item.Properties().stacksTo(1), BloodlineBloodknight.BLOOD_KNIGHT));
    public static final DeferredHolder<Item, BloodlineFang> BLOODLINE_FANG_NOBLE = BloodlinesItems.register("bloodline_fang_noble", () -> new BloodlineFang(new Item.Properties().stacksTo(1), BloodlineNoble.NOBLE));
    public static final DeferredHolder<Item, BloodlineFang> BLOODLINE_FANG_GRAVEBOUND = BloodlinesItems.register("bloodline_fang_gravebound", () -> new BloodlineFang(new Item.Properties().stacksTo(1), BloodlineGravebound.GRAVEBOUND));
    public static final DeferredHolder<Item, BottomlessChaliceItem> CHALICE_ITEM = BloodlinesItems.register("bottomless_chalice", () -> new BottomlessChaliceItem(new Item.Properties().stacksTo(1)));
    public static final DeferredHolder<Item, Item> PURITY_INJECTION = BloodlinesItems.register("purity_injection", () -> new Item(new Item.Properties().stacksTo(1)));
    public static final DeferredHolder<Item, BloodlineTesterItem> BLOODLINE_TESTER = BloodlinesItems.register("bloodline_tester", () -> new BloodlineTesterItem(new Item.Properties().stacksTo(1)));
    public static final DeferredHolder<Item, LordslayerInjectionItem> LORDSLAYER_INJECTION = BloodlinesItems.register("lordslayer_injection", () -> new LordslayerInjectionItem(new Item.Properties().stacksTo(1)));
    public static final DeferredHolder<Item, Item> CORRUPTED_BLOOD_SAMPLE = BloodlinesItems.register("corrupted_blood_sample", () -> new Item(new Item.Properties().stacksTo(64)));
    public static final DeferredHolder<Item, Item> FROZEN_BLOOD_SAMPLE = BloodlinesItems.register("frozen_blood_sample", () -> new Item(new Item.Properties().stacksTo(64)));
    public static final DeferredHolder<Item, ElixirItem> HEINOUS_ELIXIR = BloodlinesItems.register("heinous_elixir", () -> new ElixirItem(new Item.Properties(), (Holder<MobEffect>)BloodlinesEffects.HEINOUS_CURSE, () -> (Integer)CommonConfig.heinousElixirDurationSeconds.get() * 20));
    public static final DeferredHolder<Item, ElixirItem> COLD_ELIXIR = BloodlinesItems.register("freezing_elixir", () -> new ElixirItem(new Item.Properties(), (Holder<MobEffect>)BloodlinesEffects.COLD_BLOODED, () -> (Integer)CommonConfig.coldBloodedElixirDurationSeconds.get() * 20));
    public static final DeferredHolder<Item, ElixirItem> RENDING_ELIXIR = BloodlinesItems.register("rending_elixir", () -> new ElixirItem(new Item.Properties(), (Holder)BloodlinesEffects.SOUL_RENDING, () -> ((Integer)CommonConfig.heinousElixirDurationSeconds.get() + 5) * 20){

        public void appendHoverText(@NotNull ItemStack pStack, // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull Item.TooltipContext pContext, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pTooltipFlag) {
            super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
            if (ModList.get().isLoaded("emi") && !ModList.get().isLoaded("jei")) {
                pTooltipComponents.add((Component)Component.literal((String)"It appears you are using EMI without JEI. EMI by itself does not come with support for Vampirism recipe types. This means the Rending Elixir recipe will not show.").withStyle(ChatFormatting.BLUE));
            }
        }
    });
    public static final DeferredHolder<Item, Item> ZEALOT_RITUAL_CATALYST = BloodlinesItems.register("zealot_ritual_catalyst", () -> new Item(new Item.Properties().stacksTo(64)));
    public static final DeferredHolder<Item, SoulBinderItem> SOUL_BINDER_REGULAR = BloodlinesItems.register("regular_soul_binder", () -> new SoulBinderItem(false));
    public static final DeferredHolder<Item, SoulBinderItem> SOUL_BINDER_CREATIVE = BloodlinesItems.register("creative_soul_binder", () -> new SoulBinderItem(true));
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> BLOODLINE_TAB = BLOODLINE_CREATIVE_TAB.register(BLOODLINE_TAB_KEY.location().getPath(), () -> CreativeModeTab.builder().displayItems((pParameters, pOutput) -> creativeTabItems.forEach(item -> pOutput.accept((ItemLike)item.get()))).title((Component)Component.translatable((String)"itemGroup.bloodlines")).icon(() -> new ItemStack((ItemLike)BLOODLINE_FANG_ZEALOT.get())).build());

    public static <T extends Item> DeferredHolder<Item, T> register(String id, Supplier<? extends T> itemSupplier) {
        DeferredHolder item = ITEMS.register(id, itemSupplier);
        creativeTabItems.add((DeferredHolder<Item, ? extends Item>)item);
        return item;
    }

    public static void register(IEventBus bus) {
        ITEMS.register(bus);
        BLOODLINE_CREATIVE_TAB.register(bus);
    }
}

