/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.core;

import com.mojang.serialization.MapCodec;
import com.thedrofdoctoring.bloodlines.entity.entities.LingeringDevourEntity;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSubPredicate;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class BloodlinesEntities {
    public static final DeferredRegister<MapCodec<? extends EntitySubPredicate>> ENTITY_SUB_PREDICATES = DeferredRegister.create((ResourceKey)Registries.ENTITY_SUB_PREDICATE_TYPE, (String)"bloodlines");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"bloodlines");
    public static final DeferredHolder<EntityType<?>, EntityType<LingeringDevourEntity>> LINGERING_DEVOUR_ENTITY = BloodlinesEntities.prepareEntityType("lingering_devour", () -> EntityType.Builder.of(LingeringDevourEntity::new, (MobCategory)MobCategory.MISC).sized(6.0f, 0.5f).fireImmune(), false);
    public static final DeferredHolder<MapCodec<? extends EntitySubPredicate>, MapCodec<? extends EntitySubPredicate>> BLOODLINE_SUB_PREDICATE = ENTITY_SUB_PREDICATES.register("bloodline", () -> BloodlineSubPredicate.CODEC);

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> prepareEntityType(String id, @NotNull Supplier<EntityType.Builder<T>> builder, boolean spawnable) {
        return ENTITY_TYPES.register(id, () -> {
            EntityType.Builder type = ((EntityType.Builder)builder.get()).setTrackingRange(80).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true);
            if (!spawnable) {
                type.noSummon();
            }
            return type.build("bloodlines:" + id);
        });
    }
}

