/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.core;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DeathMessageType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BloodlinesDamageTypes {
    public static final ResourceKey<DamageType> DEVOUR_SOUL = BloodlinesDamageTypes.createKey("devour_soul");

    private static ResourceKey<DamageType> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)Bloodlines.rl(name));
    }

    public static void createDamageTypes(BootstrapContext<DamageType> context) {
        context.register(DEVOUR_SOUL, (Object)new DamageType("bloodlines.devour_soul", DamageScaling.NEVER, 0.0f, DamageEffects.HURT, DeathMessageType.DEFAULT));
    }

    public static Holder.Reference<DamageType> getDamageSource(@NotNull Level world, @NotNull ResourceKey<DamageType> damageTypeResourceKey) {
        Optional damageOpt = world.damageSources().damageTypes.getHolder(damageTypeResourceKey);
        if (!damageOpt.isPresent()) {
            Bloodlines.LOGGER.warn("Unable to get Damage Source: {} ", damageTypeResourceKey);
            return null;
        }
        Holder.Reference damageType = (Holder.Reference)damageOpt.get();
        return damageType;
    }
}

