/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.core;

import com.thedrofdoctoring.bloodlines.blocks.PhylacteryBlock;
import com.thedrofdoctoring.bloodlines.blocks.SpecialIceBlock;
import com.thedrofdoctoring.bloodlines.blocks.ZealotAltarBlock;
import com.thedrofdoctoring.bloodlines.core.BloodlinesItems;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class BloodlinesBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"bloodlines");
    public static final DeferredBlock<SpecialIceBlock> ICE_BLOCK = BLOCKS.register("special_ice_block", () -> new SpecialIceBlock(BlockBehaviour.Properties.of().mapColor(MapColor.ICE).friction(0.98f).randomTicks().strength(0.5f).sound(SoundType.GLASS).noOcclusion().isRedstoneConductor((p, t, x) -> false)));
    public static final DeferredBlock<ZealotAltarBlock> ZEALOT_ALTAR = BloodlinesBlocks.registerWithItem("zealot_altar", () -> new ZealotAltarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(4.0f).noOcclusion()));
    public static final DeferredBlock<PhylacteryBlock> PHYLACTERY = BloodlinesBlocks.registerWithItem("phylactery", () -> new PhylacteryBlock(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(6.0f).noOcclusion()));

    private static <T extends Block> DeferredBlock<T> registerWithItem(String name, Supplier<T> supplier, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.Properties properties) {
        DeferredBlock block = BLOCKS.register(name, supplier);
        BloodlinesItems.register(name, () -> new BlockItem((Block)block.get(), properties));
        return block;
    }

    private static <T extends Block> DeferredBlock<T> registerWithItem(String name, Supplier<T> supplier) {
        return BloodlinesBlocks.registerWithItem(name, supplier, new Item.Properties());
    }
}

