/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.commands.BloodlineArgument;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class ChangeBloodlineCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"bloodline").requires(context -> context.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"bloodline", (ArgumentType)new BloodlineArgument()).executes(context -> ChangeBloodlineCommand.setRank((CommandContext<CommandSourceStack>)context, BloodlineArgument.getBloodline((CommandContext<CommandSourceStack>)context, "bloodline"), 1, Lists.newArrayList((Object[])new ServerPlayer[]{((CommandSourceStack)context.getSource()).getPlayerOrException()})))).then(((RequiredArgumentBuilder)Commands.argument((String)"rank", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> ChangeBloodlineCommand.setRank((CommandContext<CommandSourceStack>)context, BloodlineArgument.getBloodline((CommandContext<CommandSourceStack>)context, "bloodline"), IntegerArgumentType.getInteger((CommandContext)context, (String)"rank"), Lists.newArrayList((Object[])new ServerPlayer[]{((CommandSourceStack)context.getSource()).getPlayerOrException()})))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.entities()).executes(context -> ChangeBloodlineCommand.setRank((CommandContext<CommandSourceStack>)context, BloodlineArgument.getBloodline((CommandContext<CommandSourceStack>)context, "bloodline"), IntegerArgumentType.getInteger((CommandContext)context, (String)"rank"), EntityArgument.getPlayers((CommandContext)context, (String)"player"))))));
    }

    private static int setRank(@NotNull CommandContext<CommandSourceStack> context, IBloodline bloodline, int rank, @NotNull Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            if (rank > 4 || rank < 0) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.bloodlines.rank_wrong"));
                continue;
            }
            if (bloodline.getFaction() == FactionPlayerHandler.get((Player)player).getCurrentFaction()) {
                BloodlineManager.getOpt((Player)player).ifPresent(bl -> {
                    IBloodline oldBloodline = bl.getBloodline();
                    int oldRank = bl.getRank();
                    if (rank == 0) {
                        bl.setBloodline(null);
                    } else {
                        bl.setBloodline(bloodline);
                    }
                    bl.setRank(rank);
                    bl.onBloodlineChange(oldBloodline, oldRank);
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.bloodlines.bloodline_success"), true);
                });
                continue;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.bloodlines.faction_wrong", (Object[])new Object[]{bloodline.getFaction().getNamePlural()}));
        }
        return 0;
    }
}

