/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import de.teamlapen.lib.lib.util.BasicCommand;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class BloodlinePerkCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"perk_points").requires(context -> context.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"points", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> BloodlinePerkCommand.addPerkPoints((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"points"), Lists.newArrayList((Object[])new ServerPlayer[]{((CommandSourceStack)context.getSource()).getPlayerOrException()})))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.entities()).executes(context -> BloodlinePerkCommand.addPerkPoints((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"points"), EntityArgument.getPlayers((CommandContext)context, (String)"player")))));
    }

    private static int addPerkPoints(@NotNull CommandContext<CommandSourceStack> context, int additionalPoints, @NotNull Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            BloodlineManager bl = BloodlineManager.get((Player)player);
            if (BloodlineManager.get((Player)player).getBloodline() != null) {
                bl.getSkillHandler().addSkillPoints(additionalPoints);
                bl.onBloodlineChange(bl.getBloodline(), bl.getRank());
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.bloodlines.perk_success"), true);
                continue;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.bloodlines.no_bloodline", (Object[])new Object[]{players.size() > 1 ? player.getDisplayName() : "Player"}));
        }
        return 0;
    }
}

