/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.hunter.BloodlineGravebound;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import de.teamlapen.lib.lib.util.BasicCommand;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class AddSoulsCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"souls").requires(context -> context.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"souls", (ArgumentType)IntegerArgumentType.integer((int)-50)).executes(context -> AddSoulsCommand.addSouls((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"souls"), Lists.newArrayList((Object[])new ServerPlayer[]{((CommandSourceStack)context.getSource()).getPlayerOrException()})))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.entities()).executes(context -> AddSoulsCommand.addSouls((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"souls"), EntityArgument.getPlayers((CommandContext)context, (String)"player")))));
    }

    private static int addSouls(@NotNull CommandContext<CommandSourceStack> context, int souls, @NotNull Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            BloodlineManager bl = BloodlineManager.get((Player)player);
            if (bl.getBloodline() == BloodlineRegistry.BLOODLINE_GRAVEBOUND.get()) {
                BloodlineGravebound.State state = BloodlineGravebound.getGraveboundState((Player)player);
                if (state == null) continue;
                state.addSouls(souls);
                bl.sync(false);
                bl.updatePlayerCache();
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.bloodlines.souls_success", (Object[])new Object[]{souls}), true);
                continue;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"command.bloodlines.not_gravebound", (Object[])new Object[]{players.size() > 1 ? player.getDisplayName() : "Player"}));
        }
        return 0;
    }
}

