/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.client.core;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.core.BloodlinesComponents;
import com.thedrofdoctoring.bloodlines.core.BloodlinesItems;
import com.thedrofdoctoring.bloodlines.items.attachments.ChaliceBlood;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkills;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class BloodlinesItemClient {
    public static void registerItemModelProperties() {
        ItemProperties.register((Item)((Item)BloodlinesItems.CHALICE_ITEM.get()), (ResourceLocation)Bloodlines.rl("chalice_blood"), (stack, world, entity, tint) -> (float)((ChaliceBlood)stack.getOrDefault(BloodlinesComponents.CHALICE_BLOOD, (Object)ChaliceBlood.EMPTY)).blood() / 250.0f);
    }

    public static void handleChaliceHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltips, @NotNull TooltipFlag flag) {
        LocalPlayer player = Minecraft.getInstance().player;
        int blood = ((ChaliceBlood)stack.getOrDefault((DataComponentType)BloodlinesComponents.CHALICE_BLOOD.get(), (Object)ChaliceBlood.EMPTY)).blood();
        if (player != null && Helper.isVampire((Player)player)) {
            if (!VampirePlayer.get((Player)player).getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.NOBLE_CHALICE_SKILL.get())) {
                tooltips.add((Component)Component.translatable((String)"text.bloodlines.chalice").withStyle(ChatFormatting.DARK_PURPLE));
            } else {
                tooltips.add((Component)Component.translatable((String)"text.bloodlines.chalice_blood", (Object[])new Object[]{blood * 100}).withStyle(ChatFormatting.DARK_RED));
            }
        }
    }
}

