/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.client;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlinesPlayerAttributes;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.hunter.BloodlineGravebound;
import com.thedrofdoctoring.bloodlines.capabilities.other.IPossessedEntity;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.core.BloodlinesAttachments;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import com.thedrofdoctoring.bloodlines.mixin.ScreenAccessor;
import com.thedrofdoctoring.bloodlines.networking.packets.from_client.ServerboundPossessionInputPacket;
import com.thedrofdoctoring.bloodlines.networking.packets.from_client.ServerboundPossessionInteractPacket;
import com.thedrofdoctoring.bloodlines.skills.actions.BloodlineActions;
import de.teamlapen.vampirism.api.client.VIngameOverlays;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.client.gui.screens.VampirismContainerScreen;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.Input;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.event.entity.player.PlayerHeartTypeEvent;
import org.jetbrains.annotations.NotNull;

public class ClientEventHandler {
    private int bloodlineRank;
    private String bloodlineName;
    private final Minecraft mc;
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"vampirism", (String)"skills_screen/node");
    public static final ResourceLocation DEVOUR_SOUL_SPRITE = Bloodlines.rl("devour/devour_soul");

    public ClientEventHandler(@NotNull Minecraft mc) {
        this.mc = mc;
    }

    @SubscribeEvent
    public void screenInitEvent(ScreenEvent.Init.Post event) {
        if (event.getScreen() instanceof VampirismContainerScreen) {
            if (this.mc.player == null) {
                return;
            }
            BloodlineManager bl = BloodlineManager.get((Player)this.mc.player);
            if (bl.getBloodline() != null) {
                this.bloodlineRank = bl.getRank();
                this.bloodlineName = bl.getBloodline().getName();
            } else {
                this.bloodlineRank = 0;
                this.bloodlineName = null;
            }
        }
    }

    @SubscribeEvent
    public void screenRenderEvent(ContainerScreenEvent.Render.Foreground event) {
        AbstractContainerScreen abstractContainerScreen = event.getContainerScreen();
        if (abstractContainerScreen instanceof VampirismContainerScreen) {
            VampirismContainerScreen vampScreen = (VampirismContainerScreen)abstractContainerScreen;
            if (this.bloodlineName != null) {
                String blRank = "(" + this.bloodlineRank + ")";
                GuiGraphics graphics = event.getGuiGraphics();
                Font font = ((ScreenAccessor)vampScreen).getFont();
                float x = 53.0f;
                float y = -8.0f;
                graphics.blitSprite(BACKGROUND, 50, -11, 140, 13);
                graphics.drawString(font, this.bloodlineName, x, y, 0x800000, false);
                graphics.drawString(font, blRank, 173.0f, y, 0x800000, false);
            }
        }
    }

    @SubscribeEvent
    public void onRenderFoodBar(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RenderGuiLayerEvent.Pre event) {
        if (this.mc.player == null || !this.mc.player.isAlive() || !BloodlineHelper.hasBloodline((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), (Player)this.mc.player)) {
            return;
        }
        if (this.mc.gameMode != null && event.getName() == VanillaGuiLayers.FOOD_LEVEL && this.mc.gameMode.hasExperience()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderAirSupply(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RenderGuiLayerEvent.Pre event) {
        if (this.mc.player == null || !this.mc.player.isAlive() || !BloodlineHelper.hasBloodline((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), (Player)this.mc.player)) {
            return;
        }
        if (event.getName().equals((Object)VanillaGuiLayers.AIR_LEVEL)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderGUI(RenderGuiLayerEvent.Pre event) {
        ResourceLocation guiLayer;
        if (this.mc.player != null && ((guiLayer = event.getName()).equals((Object)VanillaGuiLayers.EXPERIENCE_BAR) || guiLayer.equals((Object)VanillaGuiLayers.EXPERIENCE_LEVEL) || guiLayer.equals((Object)VIngameOverlays.FACTION_LEVEL_ID)) && BloodlinesPlayerAttributes.get((Player)this.mc.player).getGraveboundData().possessionActive) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderCrosshair(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RenderGuiLayerEvent.Pre event) {
        LivingEntity living;
        EntityHitResult hitResult;
        Entity entity;
        if (event.getName() != VanillaGuiLayers.CROSSHAIR || this.mc.player == null || !this.mc.player.isAlive()) {
            return;
        }
        IBloodline bloodline = BloodlinesPlayerAttributes.get((Player)this.mc.player).bloodline;
        if (bloodline != BloodlineRegistry.BLOODLINE_GRAVEBOUND.get()) {
            return;
        }
        BloodlineGravebound gravebound = (BloodlineGravebound)bloodline;
        HitResult p = Minecraft.getInstance().hitResult;
        if (p != null && p.getType() == HitResult.Type.ENTITY && (entity = (hitResult = (EntityHitResult)p).getEntity()).isAlive() && entity instanceof LivingEntity && gravebound.canDevour((Entity)(living = (LivingEntity)entity), (Player)this.mc.player)) {
            this.renderDevourIcon(event.getGuiGraphics(), this.mc.getWindow().getGuiScaledWidth(), this.mc.getWindow().getGuiScaledHeight());
            event.setCanceled(true);
        }
    }

    private void renderDevourIcon(@NotNull GuiGraphics graphics, int width, int height) {
        if (this.mc.player == null) {
            return;
        }
        int left = width / 2 - 8;
        int top = height / 2 - 4;
        RenderSystem.enableBlend();
        float alpha = HunterPlayer.get((Player)this.mc.player).getActionHandler().isActionOnCooldown((IAction)BloodlineActions.GRAVEBOUND_DEVOUR_SOUL.get()) ? 0.35f : 1.0f;
        graphics.setColor(1.0f, 1.0f, 1.0f, alpha);
        graphics.blitSprite(DEVOUR_SOUL_SPRITE, 16, 16, 0, 0, left, top, 16, 16);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    @SubscribeEvent
    public void gameRenderEvent(ViewportEvent.RenderFog event) {
        if (this.mc.player != null) {
            BloodlinesPlayerAttributes atts = BloodlinesPlayerAttributes.get((Player)this.mc.player);
            boolean inWall = atts.inWall;
            if (inWall) {
                event.setCanceled(true);
                event.setFogShape(FogShape.SPHERE);
                event.setNearPlaneDistance(0.1f);
                event.setFarPlaneDistance(10.0f);
            }
            if (!inWall && atts.bloodline == BloodlineRegistry.BLOODLINE_ECTOTHERM.get()) {
                int rank = atts.bloodlineRank - 1;
                int viewDist = (Integer)((List)CommonConfig.ectothermUnderwaterVisionDistance.get()).get(rank);
                if (viewDist > 0) {
                    event.setCanceled(true);
                    event.setFarPlaneDistance((float)viewDist);
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderHand(@NotNull RenderHandEvent event) {
        if (this.mc.player != null && this.mc.player.isAlive()) {
            BloodlinesPlayerAttributes atts = BloodlinesPlayerAttributes.get((Player)this.mc.player);
            if (atts.getGraveboundData().possessionActive || atts.getGraveboundData().mistForm) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderPlayerPreHigh(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        float partialTicks = event.getPartialTick();
        BloodlinesPlayerAttributes atts = BloodlinesPlayerAttributes.get(player);
        if (atts.getGraveboundData().mistForm) {
            event.setCanceled(true);
            ShulkerBullet mistFormCore = (ShulkerBullet)player.getData(BloodlinesAttachments.MIST_FORM);
            mistFormCore.tickCount = player.tickCount;
            mistFormCore.setXRot(player.getXRot());
            mistFormCore.setYRot(player.getYRot());
            mistFormCore.yRotO = player.yRotO;
            mistFormCore.xRotO = player.xRotO;
            mistFormCore.setInvisible(player.isInvisible());
            float f = Mth.lerp((float)partialTicks, (float)mistFormCore.yRotO, (float)mistFormCore.getYRot());
            EntityRenderer renderer = this.mc.getEntityRenderDispatcher().getRenderer((Entity)mistFormCore);
            renderer.render((Entity)mistFormCore, f, partialTicks, event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
            ModParticles.spawnParticleClient((Level)player.getCommandSenderWorld(), (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)player.getX(), (double)player.getY(), (double)player.getZ(), (double)0.0, (double)0.0, (double)0.0);
        }
    }

    @SubscribeEvent
    public void onHeartType(PlayerHeartTypeEvent event) {
        if (event.getType() == Gui.HeartType.POISIONED && BloodlinesPlayerAttributes.get((Player)event.getEntity()).getGraveboundData().poisonImmunity) {
            event.setType(Gui.HeartType.NORMAL);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(InputEvent.InteractionKeyMappingTriggered event) {
        if (this.mc.player == null) {
            return;
        }
        if (BloodlinesPlayerAttributes.get((Player)this.mc.player).getGraveboundData().possessionActive && (event.isAttack() || event.isUseItem())) {
            this.mc.player.connection.send((CustomPacketPayload)new ServerboundPossessionInteractPacket(event.isAttack()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInput(MovementInputUpdateEvent event) {
        IPossessedEntity possessed;
        Input input = event.getInput();
        if (this.mc.player == null) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof IPossessedEntity && (possessed = (IPossessedEntity)player).bloodlines$isPossessed()) {
            this.stopInput(input);
        }
        BloodlinesPlayerAttributes attributes = BloodlinesPlayerAttributes.get((Player)this.mc.player);
        if (attributes.getGraveboundData().possessionActive && attributes.getGraveboundData().possessedEntity != null) {
            float sidewaysMotion;
            float f = event.getInput().left ? 1.0f : (sidewaysMotion = event.getInput().right ? -1.0f : 0.0f);
            float forwardMotion = event.getInput().up ? 1.0f : (event.getInput().down ? -1.0f : 0.0f);
            boolean sprinting = this.mc.options.keySprint.isDown();
            ServerboundPossessionInputPacket packet = new ServerboundPossessionInputPacket(sidewaysMotion, forwardMotion, this.mc.player.getXRot(), this.mc.player.getYRot(), this.mc.player.getYHeadRot(), input.jumping, input.shiftKeyDown, sprinting);
            this.mc.player.connection.send((CustomPacketPayload)packet);
            this.stopInput(input);
        }
    }

    public void stopInput(Input input) {
        input.up = false;
        input.down = false;
        input.right = false;
        input.left = false;
        input.jumping = false;
        input.forwardImpulse = 0.0f;
        input.leftImpulse = 0.0f;
        input.shiftKeyDown = false;
    }
}

