/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodlineEventReceiver;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlinesPlayerAttributes;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.VampireBloodline;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkills;
import de.teamlapen.vampirism.api.entity.factions.ISkillTree;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.event.BloodDrinkEvent;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.particle.GenericParticleOptions;
import de.teamlapen.vampirism.util.Helper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;

public class BloodlineZealot
extends VampireBloodline
implements IBloodlineEventReceiver {
    public static final ResourceLocation ZEALOT = Bloodlines.rl("zealot");

    @Override
    public Map<Holder<Attribute>, AttributeModifier> getBloodlineAttributes(int rank, LivingEntity entity, boolean cleanup) {
        int realRank = rank - 1;
        HashMap<Holder<Attribute>, AttributeModifier> attributes = new HashMap<Holder<Attribute>, AttributeModifier>();
        attributes.put((Holder<Attribute>)ModAttributes.SUNDAMAGE, new AttributeModifier(Bloodlines.rl("zealot_sun_damage"), ((Double)((List)CommonConfig.zealotSunDamageMultiplier.get()).get(realRank)).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        attributes.put((Holder<Attribute>)ModAttributes.BLOOD_EXHAUSTION, new AttributeModifier(Bloodlines.rl("zealot_exhaustion_decrease"), ((Double)((List)CommonConfig.zealotBloodExhaustionChange.get()).get(realRank)).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ISkillHandler<IVampirePlayer> skillHandler = this.getSkillHandler(player);
            this.updateSpeed(realRank, BloodlinesPlayerAttributes.get(player).getZealotAtts(), skillHandler);
            this.applyConditionalModifier(attributes, (ISkill)BloodlineSkills.ZEALOT_SWIFT_SNEAK.get(), (Holder<Attribute>)Attributes.SNEAKING_SPEED, new AttributeModifier(Bloodlines.rl("zealot_serpent_speed"), ((Double)((List)CommonConfig.zealotSerpentSpeedMultipliers.get()).get(realRank)).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE), skillHandler, cleanup);
        } else {
            attributes.put(Attributes.ATTACK_DAMAGE, new AttributeModifier(Bloodlines.rl("zealot_mob_damage_increase"), ((Double)((List)CommonConfig.zealotMobDamageIncrease.get()).get(realRank)).doubleValue(), AttributeModifier.Operation.ADD_VALUE));
        }
        return attributes;
    }

    @Override
    public void onReceiveDamage(LivingIncomingDamageEvent event, LivingEntity bloodlineMember, int blRank) {
        if (bloodlineMember instanceof Player) {
            Player player = (Player)bloodlineMember;
            SpecialAttributes atts = BloodlinesPlayerAttributes.get(player).getZealotAtts();
            int brightness = player.getCommandSenderWorld().getRawBrightness(player.getOnPos().above(), 0);
            if (atts.hasShadowArmour && brightness <= (Integer)CommonConfig.zealotShadowArmourLightLevel.get()) {
                event.setAmount(event.getAmount() * ((Double)((List)CommonConfig.zealotShadowArmourDamageMultiplier.get()).get(blRank)).floatValue());
                ModParticles.spawnParticlesServer((Level)player.getCommandSenderWorld(), (ParticleOptions)new GenericParticleOptions(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"generic_7"), 40, 0, 0.2f), (double)player.getX(), (double)(player.getY() + 0.5), (double)player.getZ(), (int)10, (double)0.0, (double)0.2f, (double)0.0, (double)0.0);
            }
            if (blRank + 1 >= (Integer)CommonConfig.zealotBrightAreaDamageMultiplierRank.get() && brightness >= (Integer)CommonConfig.zealotBrightAreaDamageMultiplierLightLevel.get()) {
                event.setAmount(Math.min(event.getAmount() * ((Double)CommonConfig.zealotBrightAreaDamageMultiplier.get()).floatValue(), Float.MAX_VALUE));
            }
            if (atts.hasHexProtection && (event.getSource().is(DamageTypes.MAGIC) || event.getSource().is(DamageTypes.INDIRECT_MAGIC))) {
                event.setAmount(event.getAmount() * ((Double)((List)CommonConfig.zealotHexProtectionMultiplier.get()).get(blRank)).floatValue());
            }
        }
    }

    @Override
    public void onBloodlineChange(LivingEntity entity, int rank) {
        super.onBloodlineChange(entity, rank);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            SpecialAttributes atts = BloodlinesPlayerAttributes.get(player).getZealotAtts();
            if (Helper.isVampire((Player)player)) {
                atts.stoneSpeed = 1.0f;
            }
            this.updateSpeed(player, Math.max(rank - 1, 0), atts);
        }
    }

    @Override
    public void onCrit(CriticalHitEvent event) {
        Player player = event.getEntity();
        VampirePlayer vp = VampirePlayer.get((Player)player);
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!event.getTarget().getType().is(EntityTypeTags.UNDEAD) && vp.getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.ZEALOT_POISONED_STRIKE.get())) {
                living.addEffect(new MobEffectInstance(MobEffects.POISON, ((Integer)CommonConfig.zealotPoisonedStrikeDuration.get()).intValue(), 0));
            }
        }
    }

    private void updateSpeed(Player player, int rank, SpecialAttributes attributes) {
        this.updateSpeed(rank, attributes, this.getSkillHandler(player));
    }

    private void updateSpeed(int rank, SpecialAttributes attributes, ISkillHandler<IVampirePlayer> skillHandler) {
        attributes.stoneSpeed = skillHandler != null && skillHandler.isSkillEnabled((ISkill)BloodlineSkills.ZEALOT_STONE_SPEED.get()) ? ((Double)((List)CommonConfig.zealotStoneSpeedMultiplier.get()).get(rank)).floatValue() : 1.0f;
    }

    @Override
    public ResourceLocation getBloodlineId() {
        return ZEALOT;
    }

    @Override
    public ResourceKey<ISkillTree> getSkillTree() {
        return BloodlineSkills.Trees.ZEALOT;
    }

    @Override
    public ModConfigSpec.ConfigValue<List<? extends String>>[] getDefaultEnabledSkills() {
        return CommonConfig.zealotDefaults;
    }

    @Override
    public String getName() {
        return "Zealot";
    }

    @Override
    public void onBloodDrink(BloodDrinkEvent.PlayerDrinkBloodEvent event, int blRank, VampirePlayer bloodlinePlayer) {
    }

    public static class SpecialAttributes {
        public boolean hasShadowArmour;
        public boolean hasHexProtection;
        public boolean hasTunneler;
        public float stoneSpeed;
    }
}

