/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodlineEventReceiver;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlinesPlayerAttributes;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.VampireBloodline;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkills;
import com.thedrofdoctoring.bloodlines.skills.actions.BloodlineActions;
import de.teamlapen.vampirism.api.entity.factions.ISkillTree;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.event.BloodDrinkEvent;
import de.teamlapen.vampirism.core.ModDamageTypes;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;

public class BloodlineFrost
extends VampireBloodline
implements IBloodlineEventReceiver {
    public static final ResourceLocation ECTOTHERM = Bloodlines.rl("ectotherm");
    private static final ResourceLocation reducedMovementSpeed = Bloodlines.rl("ectotherm_biome_reduced_movement_speed");
    private static final ResourceLocation increasedMovementSpeed = Bloodlines.rl("ectotherm_biome_increased_movement_speed");
    private static final ResourceLocation reducedMaxHealth = Bloodlines.rl("ectotherm_biome_reduced_max_haelth");

    @Override
    public Map<Holder<Attribute>, AttributeModifier> getBloodlineAttributes(int rank, LivingEntity entity, boolean cleanup) {
        int realRank = rank - 1;
        HashMap<Holder<Attribute>, AttributeModifier> attributes = new HashMap<Holder<Attribute>, AttributeModifier>();
        double speedMul = 1.0;
        if (entity instanceof Player) {
            ISkillHandler<IVampirePlayer> skillHandler;
            Player player = (Player)entity;
            if (cleanup) {
                BloodlineManager.removeModifier(player.getAttribute(Attributes.MOVEMENT_SPEED), reducedMovementSpeed);
                BloodlineManager.removeModifier(player.getAttribute(Attributes.MAX_HEALTH), reducedMaxHealth);
                BloodlineManager.removeModifier(player.getAttribute(Attributes.MOVEMENT_SPEED), increasedMovementSpeed);
            }
            if ((skillHandler = this.getSkillHandler(player)) != null) {
                speedMul = skillHandler.isSkillEnabled((ISkill)BloodlineSkills.ECTOTHERM_HYDRODYNAMIC_FORM.get()) ? (Double)CommonConfig.ectothermHydrodynamicFormSpeedMultiplier.get() : 1.0;
            }
            this.applyConditionalModifier(attributes, (ISkill)BloodlineSkills.ECTOTHERM_MINING_SPEED_UNDERWATER.get(), (Holder<Attribute>)Attributes.SUBMERGED_MINING_SPEED, new AttributeModifier(Bloodlines.rl("ectotherm_underwater_mining_speed"), ((Double)((List)CommonConfig.ectothermUnderwaterMiningSpeedMultiplier.get()).get(realRank)).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), skillHandler, cleanup);
            this.applyConditionalModifier(attributes, (ISkill)BloodlineSkills.ECTOTHERM_TENTACLES.get(), (Holder<Attribute>)Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(Bloodlines.rl("ectotherm_tentacles"), ((Double)CommonConfig.ectothermTentacleInteractionDistance.get()).doubleValue(), AttributeModifier.Operation.ADD_VALUE), skillHandler, cleanup);
        } else {
            attributes.put(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(Bloodlines.rl("ectotherm_knockback_resistance"), ((Double)((List)CommonConfig.ectothermMobAdditionalKnockbackResistance.get()).get(realRank)).doubleValue(), AttributeModifier.Operation.ADD_VALUE));
        }
        attributes.put((Holder<Attribute>)NeoForgeMod.SWIM_SPEED, new AttributeModifier(Bloodlines.rl("ectotherm_swim_speed"), (Double)((List)CommonConfig.ectothermSwimSpeedMultipliers.get()).get(realRank) * speedMul, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return attributes;
    }

    @Override
    public ResourceLocation getBloodlineId() {
        return ECTOTHERM;
    }

    @Override
    public ResourceKey<ISkillTree> getSkillTree() {
        return BloodlineSkills.Trees.ECTOTHERM;
    }

    @Override
    public ModConfigSpec.ConfigValue<List<? extends String>>[] getDefaultEnabledSkills() {
        return CommonConfig.ectothermDefaults;
    }

    @Override
    public String getName() {
        return "Ectotherm";
    }

    @Override
    public void tick(Player player) {
        if (player.tickCount % 5 == 0) {
            player.setTicksFrozen(0);
        }
        if (player.tickCount % 50 == 0) {
            int rank = BloodlineManager.get(player).getRank() - 1;
            int modifierRank = rank + 1;
            Holder biome = player.level().getBiome(player.getOnPos());
            if (biome.is(Tags.Biomes.IS_HOT) && !biome.is(Tags.Biomes.IS_OCEAN)) {
                if (modifierRank >= (Integer)CommonConfig.ectothermHotBiomeReducedMaxHealthRank.get() && !BloodlineFrost.hasAttributeAlready(player, (Holder<Attribute>)Attributes.MAX_HEALTH, reducedMaxHealth)) {
                    player.getAttribute(Attributes.MAX_HEALTH).addPermanentModifier(new AttributeModifier(reducedMaxHealth, ((Double)((List)CommonConfig.ectothermHotBiomeReducedMaxHealthAmount.get()).get(rank)).doubleValue(), AttributeModifier.Operation.ADD_VALUE));
                }
                if (modifierRank >= (Integer)CommonConfig.ectothermHotBiomeReducedMovementSpeedRank.get() && !BloodlineFrost.hasAttributeAlready(player, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, reducedMovementSpeed)) {
                    player.getAttribute(Attributes.MOVEMENT_SPEED).addPermanentModifier(new AttributeModifier(reducedMovementSpeed, ((Double)((List)CommonConfig.ectothermHotBiomeReducedMovementSpeedMultiplier.get()).get(rank)).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
                }
            } else {
                BloodlineManager.removeModifier(player.getAttribute(Attributes.MOVEMENT_SPEED), reducedMovementSpeed);
                BloodlineManager.removeModifier(player.getAttribute(Attributes.MAX_HEALTH), reducedMaxHealth);
            }
            if (biome.is(Tags.Biomes.IS_COLD)) {
                if (modifierRank >= (Integer)CommonConfig.ectothermColdBiomeIncreasedMovementSpeedRank.get() && !BloodlineFrost.hasAttributeAlready(player, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, increasedMovementSpeed)) {
                    player.getAttribute(Attributes.MOVEMENT_SPEED).addPermanentModifier(new AttributeModifier(increasedMovementSpeed, ((Double)((List)CommonConfig.ectothermColdBiomeSpeedMultiplier.get()).get(rank)).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
                }
            } else {
                BloodlineManager.removeModifier(player.getAttribute(Attributes.MOVEMENT_SPEED), increasedMovementSpeed);
            }
        }
    }

    @Override
    public void onReceiveDamage(LivingIncomingDamageEvent event, LivingEntity bloodlineMember, int blRank) {
        if (event.getSource().is(ModDamageTypes.VAMPIRE_IN_FIRE) || event.getSource().is(ModDamageTypes.VAMPIRE_ON_FIRE)) {
            event.setAmount(Math.min(Float.MAX_VALUE, event.getAmount() * ((Double)((List)CommonConfig.ectothermFireDamageMultipliers.get()).get(blRank)).floatValue()));
        }
        if (event.getSource().is(ModDamageTypes.HOLY_WATER) && bloodlineMember instanceof Player) {
            Player player = (Player)bloodlineMember;
            BloodlinesPlayerAttributes atts = BloodlinesPlayerAttributes.get(player);
            boolean diffusion = atts.getEctothermAtts().hasHolyWaterDiffusion;
            if (diffusion) {
                event.setAmount(event.getAmount() * ((Double)((List)CommonConfig.ectothermHolyWaterDiffusion.get()).get(blRank)).floatValue());
            }
        }
    }

    @Override
    public void onCrit(CriticalHitEvent event) {
        Player player = event.getEntity();
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            VampirePlayer vp = VampirePlayer.get((Player)player);
            if (vp.getActionHandler().isActionActive((ILastingAction)BloodlineActions.ECTOTHERM_FROST_LORD_ACTION.get())) {
                if (vp.getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.ECTOTHERM_FROZEN_ATTACK.get())) {
                    living.setTicksFrozen(((Integer)CommonConfig.ectothermFrozenAttackFreezingAmount.get()).intValue());
                }
                if (vp.getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.ECTOTHERM_SLOWNESS_ATTACK.get())) {
                    living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, ((Integer)CommonConfig.ectothermSlowingAttackSlownessDuration.get()).intValue(), 0));
                }
            }
            if (!event.getTarget().getType().is(EntityTypeTags.UNDEAD) && vp.getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.ZEALOT_POISONED_STRIKE.get())) {
                living.addEffect(new MobEffectInstance(MobEffects.POISON, ((Integer)CommonConfig.zealotPoisonedStrikeDuration.get()).intValue(), 0));
            }
        }
    }

    private static boolean hasAttributeAlready(Player player, Holder<Attribute> att, ResourceLocation rl) {
        return player.getAttribute(att).hasModifier(rl);
    }

    @Override
    public void onBloodDrink(BloodDrinkEvent.PlayerDrinkBloodEvent event, int rank, VampirePlayer bloodlinePlayer) {
    }

    public static class SpecialAttributes {
        public boolean hasHolyWaterDiffusion;
        public boolean icePhasing;
        public boolean frostControl;
        public boolean snowWalker;
    }
}

