/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodlineEventReceiver;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.VampireBloodline;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.core.BloodlinesEffects;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkills;
import com.thedrofdoctoring.bloodlines.skills.actions.BloodlineActions;
import de.teamlapen.vampirism.api.entity.factions.ISkillTree;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IDrinkBloodContext;
import de.teamlapen.vampirism.api.event.BloodDrinkEvent;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.vampire.DrinkBloodContext;
import de.teamlapen.vampirism.util.Helper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import org.jetbrains.annotations.NotNull;

public class BloodlineBloodknight
extends VampireBloodline
implements IBloodlineEventReceiver {
    public static final ResourceLocation BLOOD_KNIGHT = Bloodlines.rl("bloodknight");

    @Override
    public Map<Holder<Attribute>, AttributeModifier> getBloodlineAttributes(int rank, LivingEntity entity, boolean cleanup) {
        int realRank = rank - 1;
        HashMap<Holder<Attribute>, AttributeModifier> attributes = new HashMap<Holder<Attribute>, AttributeModifier>();
        attributes.put((Holder<Attribute>)ModAttributes.BLOOD_EXHAUSTION, new AttributeModifier(Bloodlines.rl("bloodknight_exhaustion_decrease"), ((Double)((List)CommonConfig.bloodknightBloodThirstChange.get()).get(realRank)).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        attributes.put(Attributes.ATTACK_DAMAGE, new AttributeModifier(Bloodlines.rl("bloodknight_damage_increase"), ((Double)((List)CommonConfig.bloodknightDamageIncrease.get()).get(realRank)).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return attributes;
    }

    @Override
    public ResourceLocation getBloodlineId() {
        return BLOOD_KNIGHT;
    }

    @Override
    public ResourceKey<ISkillTree> getSkillTree() {
        return BloodlineSkills.Trees.BLOOD_KNIGHT;
    }

    @Override
    public ModConfigSpec.ConfigValue<List<? extends String>>[] getDefaultEnabledSkills() {
        return CommonConfig.bloodknightDefaults;
    }

    @Override
    public String getName() {
        return "Bloodknight";
    }

    @Override
    public void onCrit(CriticalHitEvent event) {
        if (event.isVanillaCritical()) {
            LivingEntity living;
            Entity living2;
            VampirePlayer vp = VampirePlayer.get((Player)event.getEntity());
            if (vp.asEntity().isCrouching() && vp.getSkillHandler().isSkillEnabled(BloodlineSkills.BLOODKNIGHT_HIDDEN_STRIKE) && vp.getActionHandler().isActionActive((ILastingAction)BloodlineActions.BLOODKNIGHT_BLOOD_HUNT.get())) {
                Entity entity = event.getTarget();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    int slownessDuration = (Integer)CommonConfig.bloodknightHiddenStrikeSlownessDurationPlayer.get();
                    weaknessDuration = (Integer)CommonConfig.bloodknightHiddenStrikeWeaknessDurationPlayer.get();
                    player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, weaknessDuration, 0));
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, slownessDuration, 0));
                } else {
                    Entity slownessDuration = event.getTarget();
                    if (slownessDuration instanceof LivingEntity) {
                        living2 = (LivingEntity)slownessDuration;
                        int slownessDuration2 = (Integer)CommonConfig.bloodknightHiddenStrikeSlownessDurationMob.get();
                        weaknessDuration = (Integer)CommonConfig.bloodknightHiddenStrikeWeaknessDurationMob.get();
                        living2.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, weaknessDuration, 0));
                        living2.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, slownessDuration2, 0));
                    }
                }
                vp.getActionHandler().deactivateAction((ILastingAction)BloodlineActions.BLOODKNIGHT_BLOOD_HUNT.get());
            }
            if (vp.getSkillHandler().isSkillEnabled(BloodlineSkills.BLOODKNIGHT_SAPPING_STRIKE) && (living2 = event.getTarget()) instanceof LivingEntity && Helper.isVampire((Entity)(living = (LivingEntity)living2))) {
                float saturation = ((Double)CommonConfig.bloodknightSappingStrikeSaturation.get()).floatValue();
                DrinkBloodContext emptyCon = DrinkBloodContext.none();
                if (living instanceof Player) {
                    Player player = (Player)living;
                    VampirePlayer targetVP = VampirePlayer.get((Player)player);
                    int amt = (Integer)CommonConfig.bloodknightSappingStrikePlayerDrain.get();
                    targetVP.useBlood(amt, true);
                    vp.drinkBlood(amt, saturation, (IDrinkBloodContext)emptyCon);
                    BloodlineBloodknight.addFrenzy(vp);
                } else {
                    @NotNull Optional c = ExtendedCreature.getSafe((Entity)living);
                    if (c.isPresent()) {
                        ExtendedCreature creature = (ExtendedCreature)c.get();
                        int amt = (Integer)CommonConfig.bloodknightSappingStrikeMobDrain.get();
                        creature.setBlood(creature.getBlood() - amt);
                        vp.drinkBlood(amt, saturation, (IDrinkBloodContext)emptyCon);
                        BloodlineBloodknight.addFrenzy(vp);
                    }
                }
            }
        }
    }

    private static void addFrenzy(VampirePlayer vp) {
        ISkillHandler skillHandler = vp.getSkillHandler();
        Player player = vp.asEntity();
        int duration = 600;
        if (skillHandler.isSkillEnabled((ISkill)BloodlineSkills.BLOODKNIGHT_FEEDING_FRENZY_1.get()) && !skillHandler.isSkillEnabled((ISkill)BloodlineSkills.BLOODKNIGHT_FEEDING_FRENZY_2.get())) {
            player.addEffect(new MobEffectInstance(BloodlinesEffects.BLOOD_FRENZY, duration, 0, false, true, true));
        } else if (skillHandler.isSkillEnabled((ISkill)BloodlineSkills.BLOODKNIGHT_FEEDING_FRENZY_2.get())) {
            player.addEffect(new MobEffectInstance(BloodlinesEffects.BLOOD_FRENZY, duration, 1, false, true, true));
        }
    }

    @Override
    public void onDealDamage(LivingIncomingDamageEvent event, LivingEntity bloodlineMember, LivingEntity victim, int blRank) {
        if (Helper.isVampire((Entity)victim)) {
            event.setAmount(event.getAmount() * ((Double)((List)CommonConfig.bloodknightVampireDamageMult.get()).get(blRank)).floatValue());
        }
    }

    @Override
    public void onReceiveDamage(LivingIncomingDamageEvent event, LivingEntity bloodlineMember, int blRank) {
        LivingEntity entity;
        Entity entity2 = event.getSource().getEntity();
        if (entity2 instanceof LivingEntity && Helper.isHunter((Entity)(entity = (LivingEntity)entity2))) {
            event.setAmount(Math.min(Float.MAX_VALUE, event.getAmount() * ((Double)((List)CommonConfig.bloodknightHunterDamageMult.get()).get(blRank)).floatValue()));
        }
    }

    @Override
    public void onBloodDrink(BloodDrinkEvent.PlayerDrinkBloodEvent event, int rank, VampirePlayer vp) {
        if (event.getBloodSource().getStack().isPresent()) {
            ItemStack stack;
            List<Item> allowed = List.of((Item)ModItems.VAMPIRE_BLOOD_BOTTLE.get(), (Item)ModItems.BLOOD_BOTTLE.get());
            if (!allowed.contains((stack = (ItemStack)event.getBloodSource().getStack().get()).getItem())) {
                event.setAmount((int)((float)event.getAmount() * ((Double)((List)CommonConfig.bloodknightOtherSourceBloodDecrease.get()).get(rank)).floatValue()));
                event.setSaturationModifier(event.getSaturation() * ((Double)((List)CommonConfig.bloodknightOtherSourceBloodDecrease.get()).get(rank)).floatValue());
            }
            if (stack.is((Item)ModItems.VAMPIRE_BLOOD_BOTTLE.get()) && ((Boolean)CommonConfig.bloodBottleFrenzy.get()).booleanValue()) {
                int duration = (Integer)((List)CommonConfig.bloodBottleFrenzyDuration.get()).get(rank) * 20;
                ISkillHandler skillHandler = vp.getSkillHandler();
                Player player = vp.asEntity();
                if (skillHandler.isSkillEnabled((ISkill)BloodlineSkills.BLOODKNIGHT_FEEDING_FRENZY_1.get()) && !skillHandler.isSkillEnabled((ISkill)BloodlineSkills.BLOODKNIGHT_FEEDING_FRENZY_2.get())) {
                    player.addEffect(new MobEffectInstance(BloodlinesEffects.BLOOD_FRENZY, duration, 0, false, true, true));
                } else if (skillHandler.isSkillEnabled((ISkill)BloodlineSkills.BLOODKNIGHT_FEEDING_FRENZY_2.get())) {
                    player.addEffect(new MobEffectInstance(BloodlinesEffects.BLOOD_FRENZY, duration, 1, false, true, true));
                }
            }
        }
        if (event.getBloodSource().getEntity().isPresent()) {
            LivingEntity entity = (LivingEntity)event.getBloodSource().getEntity().get();
            if (!Helper.isVampire((Entity)entity)) {
                event.setAmount((int)((float)event.getAmount() * ((Double)((List)CommonConfig.bloodknightOtherSourceBloodDecrease.get()).get(rank)).floatValue()));
                event.setSaturationModifier(event.getSaturation() * ((Double)((List)CommonConfig.bloodknightOtherSourceBloodDecrease.get()).get(rank)).floatValue());
            } else {
                ISkillHandler skillHandler = vp.getSkillHandler();
                Player player = vp.asEntity();
                int duration = (Integer)((List)CommonConfig.bloodknightBloodFrenzyDurationPerRank.get()).get(rank) * 20;
                if (skillHandler.isSkillEnabled((ISkill)BloodlineSkills.BLOODKNIGHT_FEEDING_FRENZY_1.get()) && !skillHandler.isSkillEnabled((ISkill)BloodlineSkills.BLOODKNIGHT_FEEDING_FRENZY_2.get())) {
                    player.addEffect(new MobEffectInstance(BloodlinesEffects.BLOOD_FRENZY, duration, 0, false, true, true));
                } else if (skillHandler.isSkillEnabled((ISkill)BloodlineSkills.BLOODKNIGHT_FEEDING_FRENZY_2.get())) {
                    player.addEffect(new MobEffectInstance(BloodlinesEffects.BLOOD_FRENZY, duration, 1, false, true, true));
                }
                if (!(entity instanceof Player)) {
                    event.setAmount((int)((float)event.getAmount() * ((Double)((List)CommonConfig.bloodknightVampireBonusBloodMult.get()).get(rank)).floatValue()));
                    event.setSaturationModifier(event.getSaturation() * ((Double)((List)CommonConfig.bloodknightVampireBonusSaturationMult.get()).get(rank)).floatValue());
                }
            }
        }
    }
}

