/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.capabilities.bloodlines.hunter;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.blocks.entities.PhylacteryBlockEntity;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodlineEventReceiver;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlineState;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlinesPlayerAttributes;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.hunter.HunterBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.other.IPossessedEntity;
import com.thedrofdoctoring.bloodlines.config.HunterBloodlinesConfig;
import com.thedrofdoctoring.bloodlines.core.BloodlinesDamageTypes;
import com.thedrofdoctoring.bloodlines.core.BloodlinesStats;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import com.thedrofdoctoring.bloodlines.data.BloodlinesTagsProviders;
import com.thedrofdoctoring.bloodlines.data.datamaps.BloodlinesDataMaps;
import com.thedrofdoctoring.bloodlines.data.datamaps.EntitySoulData;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkills;
import com.thedrofdoctoring.bloodlines.skills.actions.BloodlineActions;
import com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound.GraveboundMistFormAction;
import de.teamlapen.vampirism.api.entity.factions.ISkillTree;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.player.actions.ActionHandler;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BloodlineGravebound
extends HunterBloodline
implements IBloodlineEventReceiver {
    public static final ResourceLocation GRAVEBOUND = Bloodlines.rl("gravebound");

    @Override
    public Map<Holder<Attribute>, AttributeModifier> getBloodlineAttributes(int rank, LivingEntity entity, boolean cleanup) {
        int realRank = rank - 1;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.updateSpeed(player, realRank, BloodlinesPlayerAttributes.get(player).getGraveboundData());
        }
        return Map.of();
    }

    @Override
    public void onBloodlineChange(LivingEntity entity, int rank) {
        super.onBloodlineChange(entity, rank);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.handleSpecialSkills(player, rank);
            SpecialAttributes atts = BloodlinesPlayerAttributes.get(player).getGraveboundData();
            if (Helper.isVampire((Player)player)) {
                atts.soulSpeed = 1.0f;
            }
            this.updateSpeed(player, Math.max(rank - 1, 0), atts);
        }
    }

    private void updateSpeed(Player player, int rank, SpecialAttributes attributes) {
        this.updateSpeed(rank, attributes, this.getSkillHandler(player));
    }

    private void updateSpeed(int rank, SpecialAttributes attributes, ISkillHandler<IHunterPlayer> skillHandler) {
        attributes.soulSpeed = skillHandler != null && skillHandler.isSkillEnabled((ISkill)BloodlineSkills.GRAVEBOUND_SOUL_SPEED.get()) ? ((Double)((List)HunterBloodlinesConfig.graveboundSoulSpeedMultiplier.get()).get(rank)).floatValue() : 1.0f;
    }

    private void handleSpecialSkills(Player player, int newRank) {
        ISkillHandler<IHunterPlayer> handler = this.getSkillHandler(player);
        if (handler == null) {
            return;
        }
        if (newRank >= (Integer)HunterBloodlinesConfig.immortalityGraveboundRank.get()) {
            handler.enableSkill((ISkill)BloodlineSkills.GRAVEBOUND_MIST_FORM.get());
        } else {
            handler.disableSkill((ISkill)BloodlineSkills.GRAVEBOUND_MIST_FORM.get());
        }
    }

    @Override
    public ResourceLocation getBloodlineId() {
        return GRAVEBOUND;
    }

    @Override
    public ResourceKey<ISkillTree> getSkillTree() {
        return BloodlineSkills.Trees.GRAVEBOUND;
    }

    @Override
    public ModConfigSpec.ConfigValue<List<? extends String>>[] getDefaultEnabledSkills() {
        return HunterBloodlinesConfig.graveboundDefaults;
    }

    @Override
    public String getName() {
        return "Gravebound";
    }

    public Optional<State> getNewBloodlineState(Player player) {
        return Optional.of(new State(player));
    }

    @Nullable
    public static State getGraveboundState(Player player) {
        BloodlineManager manager = BloodlineManager.get(player);
        if (manager.getBloodlineState().isPresent() && manager.getBloodline() == BloodlineRegistry.BLOODLINE_GRAVEBOUND.get()) {
            return (State)manager.getBloodlineState().get();
        }
        return null;
    }

    @Override
    public void tick(Player blPlayer) {
        blPlayer.setAirSupply(300);
        int souls = BloodlinesPlayerAttributes.get((Player)blPlayer).getGraveboundData().souls;
        int foodLevel = 10;
        if (souls > (Integer)HunterBloodlinesConfig.slowRegenSoulCount.get()) {
            foodLevel = 18;
        }
        if (souls < (Integer)HunterBloodlinesConfig.noSprintSoulCount.get()) {
            foodLevel = 6;
        }
        blPlayer.getFoodData().setFoodLevel(foodLevel);
    }

    @Override
    public void onCrit(CriticalHitEvent event) {
        Entity entity;
        if (event.isVanillaCritical() && (entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            BloodlinesPlayerAttributes atts = BloodlinesPlayerAttributes.get(event.getEntity());
            if (atts.getGraveboundData().critStrikeActive) {
                event.setDamageMultiplier(event.getDamageMultiplier() + ((Double)HunterBloodlinesConfig.sorcerousStrikeAdditionalDamageMultiplier.get()).floatValue());
                living.addEffect(new MobEffectInstance(MobEffects.WITHER, (Integer)HunterBloodlinesConfig.sorcerousStrikeDuration.get() * 20));
                BloodlinesPlayerAttributes.get((Player)event.getEntity()).getGraveboundData().critStrikeActive = false;
            }
        }
    }

    @Override
    public void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.level().isClientSide) {
                BloodlineManager manager = BloodlineManager.get(player);
                State state = BloodlineGravebound.getGraveboundState(player);
                if (state == null) {
                    return;
                }
                state.mistForm = false;
                state.setSouls(3);
                manager.sync(false);
            }
        }
    }

    @Override
    public void onReceiveDamage(LivingIncomingDamageEvent event, LivingEntity bloodlineMember, int blRank) {
        if (blRank + 1 < (Integer)HunterBloodlinesConfig.immortalityGraveboundRank.get() || bloodlineMember.getCommandSenderWorld().isClientSide) {
            return;
        }
        if (event.getSource().is(BloodlinesTagsProviders.BloodlinesDamageTypesProvider.GRAVEBOUND_VULNERABLE)) {
            event.setAmount(Math.min(event.getAmount() * ((Double)((List)HunterBloodlinesConfig.graveboundMagicDamageMultiplier.get()).get(blRank)).floatValue(), Float.MAX_VALUE));
            if (((Boolean)HunterBloodlinesConfig.graveboundVulnerableDamageTypeMistForm.get()).booleanValue()) {
                return;
            }
            if (event.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                return;
            }
        }
        if (!(bloodlineMember instanceof Player)) {
            return;
        }
        Player player = (Player)bloodlineMember;
        BloodlinesPlayerAttributes atts = BloodlinesPlayerAttributes.get(player);
        SpecialAttributes graveBoundData = atts.getGraveboundData();
        if (graveBoundData.mistForm) {
            event.setCanceled(true);
            return;
        }
        IActionHandler actionHandler = HunterPlayer.get((Player)player).getActionHandler();
        if (event.getAmount() > bloodlineMember.getHealth() && !actionHandler.isActionActive((ILastingAction)BloodlineActions.GRAVEBOUND_MIST_FORM.get()) && !actionHandler.isActionOnCooldown((IAction)BloodlineActions.GRAVEBOUND_MIST_FORM.get())) {
            if (graveBoundData.mistForm) {
                return;
            }
            if (graveBoundData.souls < GraveboundMistFormAction.getRequiredSouls(player, blRank)) {
                return;
            }
            graveBoundData.mistForm = true;
            graveBoundData.lastDamageSource = event.getSource();
            HunterPlayer.get((Player)player).getActionHandler().toggleAction((IAction)BloodlineActions.GRAVEBOUND_MIST_FORM.get(), (IAction.ActivationContext)new ActionHandler.ActivationContext());
            player.setHealth(1.0f);
            event.setCanceled(true);
        }
    }

    public boolean canDevour(Entity entity, Player graveboundPlayer) {
        return this.canDevour(entity, graveboundPlayer, false, false);
    }

    public boolean canDevour(Entity entity, Player graveboundPlayer, boolean ignoreDistance, boolean ignoreDead) {
        if (!ignoreDead && !entity.isAlive()) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            ServerPlayer player;
            int timeAlive;
            LivingEntity target = (LivingEntity)entity;
            if (!ignoreDistance && (double)target.distanceTo((Entity)graveboundPlayer) >= graveboundPlayer.getAttribute(Attributes.ENTITY_INTERACTION_RANGE).getValue() + 1.0) {
                return false;
            }
            float healthPercentage = target.getHealth() / target.getMaxHealth();
            EntitySoulData data = (EntitySoulData)BuiltInRegistries.ENTITY_TYPE.wrapAsHolder((Object)target.getType()).getData(BloodlinesDataMaps.ENTITY_SOULS);
            if (data == null) {
                return false;
            }
            float requiredHealthPercent = this.getDevourHealth(target, graveboundPlayer, data);
            if (healthPercentage > requiredHealthPercent) {
                return false;
            }
            return !(target instanceof ServerPlayer) || (timeAlive = (player = (ServerPlayer)target).getStats().getValue(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_DEATH))) >= (Integer)HunterBloodlinesConfig.playerAliveTimeForDevour.get();
        }
        return false;
    }

    public float getDevourHealth(LivingEntity target, Player graveboundPlayer, EntitySoulData data) {
        float requiredMaxHealthPercent = data.baseDevourHealth();
        BloodlinesPlayerAttributes atts = BloodlinesPlayerAttributes.get(graveboundPlayer);
        if (atts.getGraveboundData().hasPowerfulDevour) {
            requiredMaxHealthPercent += ((Double)HunterBloodlinesConfig.graveboundPowerfulDevourMaxHealthChange.get()).floatValue();
        }
        return requiredMaxHealthPercent;
    }

    public void devour(LivingEntity target, Player graveboundPlayer) {
        this.devour(target, graveboundPlayer, true);
    }

    public void devour(LivingEntity target, Player graveboundPlayer, boolean applyDamage) {
        EntitySoulData soulData = (EntitySoulData)BuiltInRegistries.ENTITY_TYPE.wrapAsHolder((Object)target.getType()).getData(BloodlinesDataMaps.ENTITY_SOULS);
        int souls = soulData.souls();
        BlockPos pos = target.getOnPos();
        if (applyDamage) {
            target.hurt(new DamageSource(BloodlinesDamageTypes.getDamageSource(graveboundPlayer.level(), BloodlinesDamageTypes.DEVOUR_SOUL), (Entity)graveboundPlayer), 1000.0f);
        }
        ModParticles.spawnParticlesServer((Level)graveboundPlayer.level(), (ParticleOptions)ParticleTypes.SOUL, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (int)50, (double)0.0, (double)0.5, (double)0.0, (double)0.1f);
        graveboundPlayer.level().playSound(graveboundPlayer, pos, (SoundEvent)SoundEvents.SOUL_ESCAPE.value(), SoundSource.PLAYERS);
        graveboundPlayer.level().playSound(graveboundPlayer, pos, (SoundEvent)ModSounds.TELEPORT_AWAY.get(), SoundSource.PLAYERS);
        State state = BloodlineGravebound.getGraveboundState(graveboundPlayer);
        state.incrementTotalSoulsDevoured(souls);
        int used = state.addSouls(souls);
        this.onDevour(target, graveboundPlayer, soulData, state, souls, used);
        graveboundPlayer.awardStat((ResourceLocation)BloodlinesStats.SOULS_DEVOURED.get(), souls);
        graveboundPlayer.awardStat((ResourceLocation)BloodlinesStats.MOBS_SOUL_DEVOURED.get());
        BloodlineManager.get(graveboundPlayer).sync(false);
    }

    public void onDevour(LivingEntity target, Player graveboundPlayer, EntitySoulData soulData, State state, int actualSouls, int usedSouls) {
        ISkillHandler<IHunterPlayer> skillHandler = this.getSkillHandler(graveboundPlayer);
        if (skillHandler == null) {
            Bloodlines.LOGGER.warn("Unable to obtain skill handler for {} when devouring soul", (Object)graveboundPlayer.getName());
            return;
        }
        if (skillHandler.isSkillEnabled((ISkill)BloodlineSkills.GRAVEBOUND_REGEN_DEVOUR.get())) {
            float healAmount = soulData.baseDevourHealth() * target.getMaxHealth() / 2.0f;
            graveboundPlayer.heal(healAmount);
        }
        if (state.hasPhylactery() && skillHandler.isSkillEnabled((ISkill)BloodlineSkills.GRAVEBOUND_SOUL_TRANSFER.get())) {
            state.tryGetPhylactery().ifPresent(be -> be.addSouls(actualSouls - usedSouls));
        }
    }

    @Nullable
    public static State getGraveboundState(BloodlineManager manager) {
        if (manager.getBloodlineState().isPresent() && manager.getBloodline() == BloodlineRegistry.BLOODLINE_GRAVEBOUND.get()) {
            return (State)manager.getBloodlineState().get();
        }
        return null;
    }

    public static class SpecialAttributes {
        public int souls;
        public int maxSouls;
        public boolean hasPhylactery;
        public boolean critStrikeActive;
        public boolean hasPowerfulDevour;
        public boolean mistForm;
        public boolean ghostWalk;
        public boolean soulClaimingActive;
        public boolean cheaperResurrection;
        public boolean undeadLord;
        public boolean fasterResurrection;
        public boolean passiveSoulClaiming;
        public boolean poisonImmunity;
        public boolean poisonHealing;
        public float soulSpeed;
        public DamageSource lastDamageSource;
        public boolean possessionActive;
        public LivingEntity possessedEntity;
    }

    public static class State
    extends BloodlineState {
        @Nullable
        private BlockPos phylacteryPos;
        @Nullable
        ResourceLocation phylacteryDimensionID;
        private int souls;
        private int maxSouls;
        private int totalSoulsDevoured;
        private boolean mistForm;
        private boolean possession;
        private UUID possessedEntityUUID;
        private int possessedEntityNetworkID = -1;

        protected State(Player player) {
            super(player);
        }

        public ResourceLocation getPhylacteryDimension() {
            return this.phylacteryDimensionID;
        }

        public void removePhylactery() {
            this.phylacteryPos = null;
        }

        public void setPhylactery(@Nullable BlockPos pos, ResourceLocation dimension) {
            this.phylacteryPos = pos;
            this.phylacteryDimensionID = dimension;
        }

        public boolean isMistForm() {
            return this.mistForm;
        }

        public void setMistForm(boolean mistForm) {
            this.mistForm = mistForm;
        }

        public boolean isPossessing() {
            return this.possession;
        }

        public void setPossession(LivingEntity entity) {
            this.possession = true;
            this.possessedEntityUUID = entity.getUUID();
            this.possessedEntityNetworkID = entity.getId();
        }

        public void clearPossession() {
            ServerLevel level;
            Entity entity;
            Level level2;
            if (this.possessedEntityUUID != null && (level2 = this.player.level()) instanceof ServerLevel && (entity = (level = (ServerLevel)level2).getEntity(this.possessedEntityNetworkID)) instanceof IPossessedEntity) {
                IPossessedEntity possessed = (IPossessedEntity)entity;
                possessed.bloodlines$clearPossession();
            }
            this.possession = false;
            this.possessedEntityUUID = null;
            this.possessedEntityNetworkID = -1;
        }

        public int getTotalSoulsDevoured() {
            return this.totalSoulsDevoured;
        }

        public void incrementTotalSoulsDevoured(int amount) {
            PhylacteryBlockEntity phylactery;
            BlockEntity be;
            this.totalSoulsDevoured += amount;
            if (this.phylacteryPos != null && (be = this.player.level().getBlockEntity(this.phylacteryPos)) instanceof PhylacteryBlockEntity && (phylactery = (PhylacteryBlockEntity)be).getOwnerUUID().equals(this.player.getUUID())) {
                phylactery.determineMaxSouls(this.totalSoulsDevoured);
            }
        }

        public Optional<PhylacteryBlockEntity> tryGetPhylactery() {
            Level level = this.player.level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                if (this.phylacteryPos != null && this.getPhylacteryDimension() != null) {
                    ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)this.getPhylacteryDimension());
                    ServerLevel phylacteryDimension = level2.getServer().getLevel(dimension);
                    if (phylacteryDimension == null) {
                        Bloodlines.LOGGER.warn("Phylactery dimension not null, but failed to retrieve phylactery for player {} in set dimension", (Object)this.player.getName());
                        return Optional.empty();
                    }
                    BlockEntity blockEntity = phylacteryDimension.getBlockEntity(this.phylacteryPos);
                    if (blockEntity instanceof PhylacteryBlockEntity) {
                        PhylacteryBlockEntity phylacteryBlockEntity = (PhylacteryBlockEntity)blockEntity;
                        return Optional.of(phylacteryBlockEntity);
                    }
                }
            }
            return Optional.empty();
        }

        @Nullable
        public BlockPos getPhylacteryPos() {
            return this.phylacteryPos;
        }

        public boolean hasPhylactery() {
            return this.phylacteryPos != null;
        }

        public int getMaxSouls(int rank) {
            if (this.phylacteryPos == null) {
                return 4;
            }
            return (Integer)((List)HunterBloodlinesConfig.graveboundMaxSouls.get()).get(rank - 1);
        }

        public int addSouls(int additional) {
            if (additional > 0) {
                int used = additional;
                if (additional + this.souls > this.maxSouls) {
                    used = this.maxSouls - this.souls;
                }
                this.souls = Math.min(this.maxSouls, this.souls + additional);
                return used;
            }
            if (additional < 0) {
                int used = -additional;
                if (additional + this.souls < 0) {
                    used = this.souls;
                }
                this.souls = Math.max(this.souls - used, 0);
                return used;
            }
            return 0;
        }

        public void setSouls(int value) {
            this.souls = value;
        }

        public int getSouls() {
            return this.souls;
        }

        @Override
        public void deserializeUpdateNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
            if (nbt.contains("gravebound_phylactery") && nbt.contains("phylactery_dimension")) {
                Optional phylacteryPos = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"gravebound_phylactery");
                phylacteryPos.ifPresent(blockPos -> {
                    this.phylacteryPos = blockPos;
                    this.phylacteryDimensionID = ResourceLocation.parse((String)nbt.getString("phylactery_dimension"));
                });
            } else {
                this.phylacteryPos = null;
                this.phylacteryDimensionID = null;
            }
            this.mistForm = nbt.getBoolean("gravebound_mist_form");
            this.possession = nbt.getBoolean("gravebound_possession");
            this.souls = nbt.getInt("gravebound_souls");
            this.totalSoulsDevoured = nbt.getInt("gravebound_total_devoured");
            if (this.possession) {
                this.possessedEntityUUID = nbt.getUUID("gravebound_possession_uuid");
                this.possessedEntityNetworkID = nbt.getInt("gravebound_possession_id");
            } else {
                this.clearPossession();
            }
        }

        @Override
        public CompoundTag serializeUpdateNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
            if (this.phylacteryPos != null && this.phylacteryDimensionID != null) {
                nbt.put("gravebound_phylactery", NbtUtils.writeBlockPos((BlockPos)this.phylacteryPos));
                nbt.putString("phylactery_dimension", this.phylacteryDimensionID.toString());
            }
            nbt.putInt("gravebound_souls", this.souls);
            nbt.putInt("gravebound_total_devoured", this.totalSoulsDevoured);
            nbt.putBoolean("gravebound_mist_form", this.mistForm);
            nbt.putBoolean("gravebound_possession", this.possession);
            if (this.possession) {
                nbt.putUUID("gravebound_possession_uuid", this.possessedEntityUUID);
                nbt.putInt("gravebound_possession_id", this.possessedEntityNetworkID);
            }
            return nbt;
        }

        @Override
        public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
            if (this.phylacteryPos != null && this.phylacteryDimensionID != null) {
                nbt.put("gravebound_phylactery", NbtUtils.writeBlockPos((BlockPos)this.phylacteryPos));
                nbt.putString("phylactery_dimension", this.phylacteryDimensionID.toString());
            }
            if (this.possession) {
                nbt.putUUID("gravebound_possession_uuid", this.possessedEntityUUID);
                nbt.putInt("gravebound_possession_id", this.possessedEntityNetworkID);
            }
            nbt.putInt("gravebound_total_devoured", this.totalSoulsDevoured);
            nbt.putInt("gravebound_souls", this.souls);
            nbt.putBoolean("gravebound_mist_form", this.mistForm);
            nbt.putBoolean("gravebound_possession", this.possession);
            return nbt;
        }

        @Override
        public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, @NotNull CompoundTag nbt) {
            if (nbt.contains("gravebound_phylactery") && nbt.contains("phylactery_dimension")) {
                Optional phylacteryPos = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"gravebound_phylactery");
                phylacteryPos.ifPresent(blockPos -> {
                    this.phylacteryPos = blockPos;
                    this.phylacteryDimensionID = ResourceLocation.parse((String)nbt.getString("phylactery_dimension"));
                });
            } else {
                this.phylacteryPos = null;
                this.phylacteryDimensionID = null;
            }
            this.totalSoulsDevoured = nbt.getInt("gravebound_total_devoured");
            this.souls = nbt.getInt("gravebound_souls");
            this.mistForm = nbt.getBoolean("gravebound_mist_form");
            this.possession = nbt.getBoolean("gravebound_possession");
            if (this.possession) {
                this.possessedEntityUUID = nbt.getUUID("gravebound_possession_uuid");
                this.possessedEntityNetworkID = nbt.getInt("gravebound_possession_id");
            } else {
                this.clearPossession();
            }
        }

        @Override
        public void clear(Level level) {
            this.tryGetPhylactery().ifPresentOrElse(phylactery -> phylactery.setOwner(null), () -> {
                if (this.phylacteryPos != null) {
                    Bloodlines.LOGGER.warn("Failed to retrieve phylactery BE, could not clear owner {}", (Object)this.player.getName());
                }
            });
            this.phylacteryPos = null;
            this.souls = 0;
            this.phylacteryDimensionID = null;
            this.totalSoulsDevoured = 0;
            this.clearPossession();
            this.mistForm = false;
        }

        @Override
        public void updateCache(int rank) {
            BloodlinesPlayerAttributes attributes = BloodlinesPlayerAttributes.get(this.player);
            this.maxSouls = this.getMaxSouls(rank);
            this.souls = Math.min(this.souls, this.maxSouls);
            SpecialAttributes specialAtts = attributes.getGraveboundData();
            specialAtts.maxSouls = this.maxSouls;
            specialAtts.souls = this.souls;
            specialAtts.hasPhylactery = this.hasPhylactery();
            specialAtts.mistForm = this.mistForm;
            if (this.possession && this.possessedEntityNetworkID != -1) {
                this.updatePossessed(specialAtts);
            } else {
                specialAtts.possessionActive = false;
            }
        }

        private void updatePossessed(SpecialAttributes specialAtts) {
            specialAtts.possessionActive = true;
            Entity entity = this.player.level().getEntity(this.possessedEntityNetworkID);
            if (entity instanceof LivingEntity) {
                LivingEntity living;
                specialAtts.possessedEntity = living = (LivingEntity)entity;
                if (living instanceof IPossessedEntity) {
                    IPossessedEntity possessed = (IPossessedEntity)living;
                    possessed.bloodlines$setPossessed(this.player);
                }
            } else {
                specialAtts.possessionActive = false;
            }
        }
    }
}

