/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.capabilities.bloodlines.entity;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlineState;
import com.thedrofdoctoring.bloodlines.core.BloodlinesAttachments;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import de.teamlapen.lib.lib.storage.IAttachment;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import org.jetbrains.annotations.NotNull;

public class BloodlineMobManager
implements IBloodlineManager,
IAttachment {
    public static final String NBT_KEY = "bloodline_mob_manager";
    public static final ResourceLocation BlOODLINE_KEY = Bloodlines.rl("bloodline_mob_manager");
    private int bloodlineRank;
    private final PathfinderMob entity;
    private ResourceLocation bloodlineName;
    private IBloodline bloodline;

    @NotNull
    public static Optional<BloodlineMobManager> getSafe(@NotNull Entity mob) {
        if (mob instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)mob;
            return Optional.of((BloodlineMobManager)pathfinderMob.getData((AttachmentType)BloodlinesAttachments.BLOODLINE_MOB_MANAGER.get()));
        }
        return Optional.empty();
    }

    public static BloodlineMobManager get(PathfinderMob mob) {
        return (BloodlineMobManager)mob.getData((AttachmentType)BloodlinesAttachments.BLOODLINE_MOB_MANAGER.get());
    }

    public String nbtKey() {
        return NBT_KEY;
    }

    public BloodlineMobManager(PathfinderMob entity) {
        this.entity = entity;
    }

    @Override
    public int getRank() {
        return this.bloodlineRank;
    }

    @Override
    public void setRank(int bloodlineRank) {
        this.bloodlineRank = bloodlineRank;
        if (bloodlineRank == 0) {
            this.bloodlineName = null;
            this.bloodline = null;
        }
    }

    @Override
    public IBloodline getBloodline() {
        if (BloodlineRegistry.BLOODLINE_REGISTRY.containsKey(this.bloodlineName)) {
            return (IBloodline)BloodlineRegistry.BLOODLINE_REGISTRY.get(this.bloodlineName);
        }
        return null;
    }

    @Override
    public ResourceLocation getBloodlineId() {
        return this.bloodlineName;
    }

    @Override
    public void setBloodline(IBloodline bloodline) {
        if (bloodline != null) {
            this.bloodline = bloodline;
            this.bloodlineName = bloodline.getBloodlineId();
        } else {
            this.bloodline = null;
            this.bloodlineName = null;
            this.bloodlineRank = 0;
        }
    }

    @Override
    public void updateAttributes(IBloodline oldBloodline) {
        if (oldBloodline != null && oldBloodline != this.bloodline && !this.entity.getCommandSenderWorld().isClientSide) {
            Map<Holder<Attribute>, AttributeModifier> oldAttributes = oldBloodline.getBloodlineAttributes(1, (LivingEntity)this.entity, true);
            oldAttributes.forEach((attribute, modifier) -> {
                AttributeInstance att = this.entity.getAttribute(attribute);
                if (att == null) {
                    return;
                }
                BloodlineMobManager.removeModifier(att, modifier.id());
            });
        }
        if (this.bloodline != null && !this.entity.getCommandSenderWorld().isClientSide) {
            Map<Holder<Attribute>, AttributeModifier> attributes = this.bloodline.getBloodlineAttributes(this.getRank(), (LivingEntity)this.entity, false);
            attributes.forEach((attribute, modifier) -> {
                AttributeInstance att = this.entity.getAttribute(attribute);
                if (att == null) {
                    return;
                }
                BloodlineMobManager.removeModifier(att, modifier.id());
                this.entity.getAttribute(attribute).addPermanentModifier(modifier);
            });
        }
    }

    @Override
    public void onBloodlineChange(IBloodline oldBloodline, int oldRank) {
        if (oldBloodline != null && oldBloodline != this.bloodline) {
            if (this.bloodline != null) {
                oldBloodline.onBloodlineChange((LivingEntity)this.entity, 0);
                this.bloodline.onBloodlineChange((LivingEntity)this.entity, this.getRank());
            }
        } else if (this.bloodlineRank != oldRank && this.bloodline != null) {
            this.bloodline.onBloodlineChange((LivingEntity)this.entity, this.getRank());
        }
        this.updateAttributes(oldBloodline);
        this.sync(true);
    }

    @Override
    public Optional<BloodlineState> getBloodlineState() {
        return Optional.empty();
    }

    public PathfinderMob getEntity() {
        return this.entity;
    }

    private static void removeModifier(@NotNull AttributeInstance att, @NotNull ResourceLocation location) {
        AttributeModifier m = att.getModifier(location);
        if (m != null) {
            att.removeModifier(m);
        }
    }

    public ResourceLocation getAttachedKey() {
        return BlOODLINE_KEY;
    }

    public Entity asEntity() {
        return this.entity;
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
        if (nbt.contains("bloodline")) {
            this.bloodlineRank = nbt.getInt("rank");
            this.bloodlineName = ResourceLocation.parse((String)nbt.getString("bloodline"));
            this.bloodline = this.getBloodline();
        }
    }

    @NotNull
    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        if (this.bloodline != null) {
            nbt.putString("bloodline", this.bloodlineName.toString());
            nbt.putInt("rank", this.bloodlineRank);
        }
        return nbt;
    }

    public void deserializeUpdateNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
        if (nbt.getString("bloodline").isEmpty()) {
            this.bloodline = null;
            this.bloodlineRank = 0;
            this.bloodlineName = null;
        } else {
            this.bloodlineName = ResourceLocation.parse((String)nbt.getString("bloodline"));
            this.bloodline = this.getBloodline();
            this.bloodlineRank = nbt.getInt("rank");
        }
    }

    @NotNull
    public CompoundTag serializeUpdateNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("bloodline", this.bloodline == null ? "" : this.bloodline.getBloodlineId().toString());
        nbt.putInt("rank", this.bloodlineRank);
        return nbt;
    }

    public static class Factory
    implements Function<IAttachmentHolder, BloodlineMobManager> {
        @Override
        public BloodlineMobManager apply(IAttachmentHolder holder) {
            if (holder instanceof PathfinderMob) {
                PathfinderMob mob = (PathfinderMob)holder;
                return new BloodlineMobManager(mob);
            }
            throw new IllegalArgumentException("Cannot create bloodline manager attachment for holder " + String.valueOf(holder.getClass()) + ". Expected PathfinderMob");
        }
    }

    public static class Serializer
    implements IAttachmentSerializer<CompoundTag, BloodlineMobManager> {
        @NotNull
        public BloodlineMobManager read(@NotNull IAttachmentHolder holder, @NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            if (holder instanceof PathfinderMob) {
                PathfinderMob entity = (PathfinderMob)holder;
                BloodlineMobManager handler = new BloodlineMobManager(entity);
                handler.deserializeNBT(provider, tag);
                return handler;
            }
            throw new IllegalStateException("Cannot deserialize Bloodline Manager for non PathfinderMob");
        }

        public CompoundTag write(BloodlineMobManager attachment, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            return attachment.serializeNBT(provider);
        }
    }
}

