/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.capabilities.bloodlines;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineSkillHandler;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlineState;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlinesPlayerAttributes;
import com.thedrofdoctoring.bloodlines.core.BloodlinesAttachments;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import com.thedrofdoctoring.bloodlines.skills.BloodlineParentSkill;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkills;
import de.teamlapen.lib.lib.storage.IAttachment;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import org.jetbrains.annotations.NotNull;

public class BloodlineManager
implements IBloodlineManager,
IAttachment {
    public static final String NBT_KEY = "bloodline_manager";
    public static final ResourceLocation BlOODLINE_KEY = Bloodlines.rl("bloodline_manager");
    private int bloodlineRank;
    private final Player player;
    private ResourceLocation bloodlineName;
    private final BloodlineSkillHandler skillHandler;
    private BloodlineState bloodlineState;
    private IBloodline bloodline;

    @NotNull
    public static BloodlineManager get(@NotNull Player player) {
        return (BloodlineManager)player.getData((AttachmentType)BloodlinesAttachments.BLOODLINE_MANAGER.get());
    }

    @NotNull
    public static Optional<BloodlineManager> getOpt(@NotNull Player player) {
        return Optional.of((BloodlineManager)player.getData((AttachmentType)BloodlinesAttachments.BLOODLINE_MANAGER.get()));
    }

    public String nbtKey() {
        return NBT_KEY;
    }

    public BloodlineManager(Player player) {
        this.player = player;
        this.skillHandler = new BloodlineSkillHandler();
        this.skillHandler.setEnabledSkills(0);
    }

    @Override
    public int getRank() {
        return this.bloodlineRank;
    }

    @Override
    public void setRank(int bloodlineRank) {
        this.bloodlineRank = bloodlineRank;
        if (bloodlineRank == 0) {
            this.bloodlineName = null;
            this.bloodline = null;
            this.skillHandler.setEnabledSkills(0);
            this.skillHandler.clearSkillPoints();
        }
    }

    @Override
    public IBloodline getBloodline() {
        if (this.bloodline == null && BloodlineRegistry.BLOODLINE_REGISTRY.containsKey(this.bloodlineName)) {
            this.bloodline = (IBloodline)BloodlineRegistry.BLOODLINE_REGISTRY.get(this.bloodlineName);
            return this.bloodline;
        }
        return this.bloodline;
    }

    @Override
    public ResourceLocation getBloodlineId() {
        return this.bloodlineName;
    }

    @Override
    public void setBloodline(IBloodline bloodline) {
        if (bloodline != null) {
            this.bloodline = bloodline;
            this.bloodlineName = bloodline.getBloodlineId();
        } else {
            this.bloodline = null;
            this.bloodlineName = null;
            this.bloodlineRank = 0;
            if (this.bloodlineState != null) {
                this.bloodlineState.clear(this.player.level());
            }
            this.bloodlineState = null;
            this.skillHandler.setEnabledSkills(0);
            this.skillHandler.clearSkillPoints();
        }
    }

    @Override
    public void onBloodlineChange(IBloodline oldBloodline, int oldRank) {
        if (oldBloodline != null && oldBloodline != this.bloodline) {
            ArrayList<ISkill<?>> blSkills = BloodlineSkills.getBloodlineTypeSkills(oldBloodline);
            FactionPlayerHandler.get((Player)this.player).getCurrentFactionPlayer().ifPresent(pl -> {
                for (ISkill blSkill : blSkills) {
                    if (!pl.getSkillHandler().isSkillEnabled(blSkill)) continue;
                    pl.getSkillHandler().disableSkill(blSkill);
                }
            });
            FactionPlayerHandler.get((Player)this.player).checkSkillTreeLocks();
            this.skillHandler.clearSkillPoints();
            if (this.bloodlineState != null) {
                this.bloodlineState.clear(this.player.level());
            }
            this.bloodlineState = null;
            if (this.bloodline != null) {
                if (this.bloodline.getNewBloodlineState(this.player).isPresent()) {
                    this.bloodlineState = this.bloodline.getNewBloodlineState(this.player).get();
                }
                oldBloodline.onBloodlineChange((LivingEntity)this.player, 0);
                this.bloodline.onBloodlineChange((LivingEntity)this.player, this.getRank());
                FactionPlayerHandler.get((Player)this.player).checkSkillTreeLocks();
            }
            this.skillHandler.clearSkillPoints();
        } else if (this.bloodlineRank != oldRank && this.bloodline != null) {
            this.bloodline.onBloodlineChange((LivingEntity)this.player, this.getRank());
            if (oldRank == 0) {
                FactionPlayerHandler.get((Player)this.player).checkSkillTreeLocks();
            }
            if (oldRank > this.bloodlineRank) {
                ISkillHandler<?> skillHandler = this.bloodline.getSkillHandler(this.player);
                this.disableUntilEligible(skillHandler);
            }
            if (this.bloodline.getNewBloodlineState(this.player).isPresent() && this.bloodlineState == null) {
                this.bloodlineState = this.bloodline.getNewBloodlineState(this.player).get();
            }
        }
        this.updateAttributes(oldBloodline);
        this.sync(true);
        this.updatePlayerCache();
    }

    @Override
    public Optional<BloodlineState> getBloodlineState() {
        return Optional.ofNullable(this.bloodlineState);
    }

    public void updatePlayerCache() {
        BloodlinesPlayerAttributes attributes = BloodlinesPlayerAttributes.get(this.player);
        attributes.bloodline = this.bloodline;
        attributes.bloodlineRank = this.bloodlineRank;
        if (this.bloodlineState != null) {
            this.bloodlineState.updateCache(this.bloodlineRank);
        }
    }

    private void disableUntilEligible(ISkillHandler<?> skillHandler) {
        for (ISkill<?> skill : BloodlineSkills.getBloodlineTypeSkills(this.bloodline)) {
            BloodlineParentSkill<?> nodesClosestParent;
            if (!skillHandler.isSkillEnabled(skill) || (nodesClosestParent = this.closestParent(skill, skillHandler)) == null || !skillHandler.isSkillEnabled(skill) || nodesClosestParent.getRank() <= this.bloodlineRank) continue;
            skillHandler.disableSkill(skill);
        }
    }

    private BloodlineParentSkill<?> closestParent(ISkill skill, ISkillHandler<?> skillHandler) {
        if (skill instanceof BloodlineParentSkill) {
            BloodlineParentSkill blSkill = (BloodlineParentSkill)skill;
            return blSkill;
        }
        int n = 0;
        ISkill[] parentSkills = skillHandler.getParentSkills(skill);
        ISkill[] iSkillArray = parentSkills;
        int n2 = iSkillArray.length;
        if (n < n2) {
            ISkill parentSkill = iSkillArray[n];
            if (parentSkill instanceof BloodlineParentSkill) {
                BloodlineParentSkill bloodlineParentSkill = (BloodlineParentSkill)parentSkill;
                return bloodlineParentSkill;
            }
            return this.closestParent(parentSkill, skillHandler);
        }
        return null;
    }

    @Override
    public void updateAttributes(IBloodline oldBloodline) {
        if (oldBloodline != null && oldBloodline != this.bloodline && !this.player.getCommandSenderWorld().isClientSide) {
            Map<Holder<Attribute>, AttributeModifier> oldAttributes = oldBloodline.getBloodlineAttributes(1, (LivingEntity)this.player, true);
            oldAttributes.forEach((attribute, modifier) -> BloodlineManager.removeModifier(this.player.getAttribute(attribute), modifier.id()));
        }
        if (this.bloodline != null && !this.player.getCommandSenderWorld().isClientSide) {
            Map<Holder<Attribute>, AttributeModifier> attributes = this.bloodline.getBloodlineAttributes(this.getRank(), (LivingEntity)this.player, false);
            attributes.forEach((attribute, modifier) -> {
                BloodlineManager.removeModifier(this.player.getAttribute(attribute), modifier.id());
                this.player.getAttribute(attribute).addPermanentModifier(modifier);
            });
        }
    }

    public Player getEntity() {
        return this.player;
    }

    public static void removeModifier(@NotNull AttributeInstance att, @NotNull ResourceLocation location) {
        AttributeModifier m = att.getModifier(location);
        if (m != null) {
            att.removeModifier(m);
        }
    }

    public BloodlineSkillHandler getSkillHandler() {
        return this.skillHandler;
    }

    public ResourceLocation getAttachedKey() {
        return BlOODLINE_KEY;
    }

    public Entity asEntity() {
        return this.player;
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
        if (nbt.contains("bloodline")) {
            this.bloodlineRank = nbt.getInt("rank");
            this.bloodlineName = ResourceLocation.parse((String)nbt.getString("bloodline"));
            this.bloodline = BloodlineHelper.getBloodlineById(this.bloodlineName);
            this.skillHandler.deserializeNBT(nbt);
            if (this.bloodlineState == null && this.bloodline.getNewBloodlineState(this.player).isPresent()) {
                this.bloodlineState = this.bloodline.getNewBloodlineState(this.player).get();
            }
            if (this.bloodlineState != null) {
                this.bloodlineState.deserializeNBT(provider, nbt);
            }
            this.onBloodlineChange(this.bloodline, this.bloodlineRank);
            this.updatePlayerCache();
        } else {
            this.bloodline = null;
            this.bloodlineRank = 0;
            this.bloodlineName = null;
            this.bloodlineState = null;
            this.skillHandler.clearSkillPoints();
            this.updatePlayerCache();
        }
    }

    @NotNull
    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        if (this.bloodline != null) {
            nbt.putString("bloodline", this.bloodlineName.toString());
            nbt.putInt("rank", this.bloodlineRank);
            nbt = this.skillHandler.serializeNBT(nbt);
            if (this.bloodlineState != null) {
                nbt = this.bloodlineState.serializeNBT(provider, nbt);
            }
        }
        return nbt;
    }

    public void deserializeUpdateNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
        if (nbt.getString("bloodline").isEmpty()) {
            this.bloodline = null;
            this.bloodlineRank = 0;
            this.bloodlineName = null;
            this.bloodlineState = null;
            this.skillHandler.clearSkillPoints();
            this.updatePlayerCache();
        } else {
            this.bloodlineName = ResourceLocation.parse((String)nbt.getString("bloodline"));
            this.bloodline = BloodlineHelper.getBloodlineById(this.bloodlineName);
            this.bloodlineRank = nbt.getInt("rank");
            this.skillHandler.deserializeUpdateNBT(nbt);
            if (this.bloodlineState == null && this.bloodline.getNewBloodlineState(this.player).isPresent()) {
                this.bloodlineState = this.bloodline.getNewBloodlineState(this.player).get();
            }
            if (this.bloodlineState != null) {
                this.bloodlineState.deserializeUpdateNBT(provider, nbt);
            }
            this.bloodline.onBloodlineChange((LivingEntity)this.player, this.bloodlineRank);
            this.updatePlayerCache();
        }
    }

    @NotNull
    public CompoundTag serializeUpdateNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("bloodline", this.bloodline == null ? "" : this.bloodline.getBloodlineId().toString());
        nbt.putInt("rank", this.bloodlineRank);
        nbt = this.skillHandler.serializeUpdateNBT(nbt);
        if (this.bloodlineState != null) {
            nbt = this.bloodlineState.serializeUpdateNBT(provider, nbt);
        }
        return nbt;
    }

    public static class Factory
    implements Function<IAttachmentHolder, BloodlineManager> {
        @Override
        public BloodlineManager apply(IAttachmentHolder holder) {
            if (holder instanceof Player) {
                Player player = (Player)holder;
                return new BloodlineManager(player);
            }
            throw new IllegalArgumentException("Cannot create bloodline manager attachment for holder " + String.valueOf(holder.getClass()) + ". Expected Player");
        }
    }

    public static class Serializer
    implements IAttachmentSerializer<CompoundTag, BloodlineManager> {
        @NotNull
        public BloodlineManager read(@NotNull IAttachmentHolder holder, @NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            if (holder instanceof Player) {
                Player player = (Player)holder;
                BloodlineManager handler = new BloodlineManager(player);
                handler.deserializeNBT(provider, tag);
                return handler;
            }
            throw new IllegalStateException("Cannot deserialize Bloodline Manager for non player entity");
        }

        public CompoundTag write(BloodlineManager attachment, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider) {
            return attachment.serializeNBT(provider);
        }
    }
}

