/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.capabilities.bloodlines;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlinesPlayerAttributes;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.IBloodlinesPlayer;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.entity.BloodlineMobManager;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;

public class BloodlineHelper {
    public static int getBloodlineRank(Player player) {
        return BloodlineManager.getOpt(player).map(BloodlineManager::getRank).orElse(0);
    }

    public static IBloodline getBloodlineById(ResourceLocation id) {
        if (BloodlineRegistry.BLOODLINE_REGISTRY.containsKey(id)) {
            return (IBloodline)BloodlineRegistry.BLOODLINE_REGISTRY.get(id);
        }
        return null;
    }

    public static boolean hasBloodline(IBloodline bloodline, Player player) {
        BloodlinesPlayerAttributes atts = ((IBloodlinesPlayer)player).bloodlines$getBloodlinesAtts();
        return atts.bloodline == bloodline;
    }

    public static void joinBloodlineGeneric(Player player, IBloodline bloodline, Component joinMessage) {
        if (FactionPlayerHandler.get((Player)player).getCurrentFaction() != bloodline.getFaction()) {
            return;
        }
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSounds.ENTITY_VAMPIRE_SCREAM.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.PLAYERS, 1.0f, 1.0f);
        BloodlineManager bl = BloodlineManager.get(player);
        bl.setRank(1);
        bl.setBloodline(bloodline);
        bl.onBloodlineChange(null, 0);
        player.displayClientMessage(joinMessage, true);
        player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200, 2));
        player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 180, 3));
        player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 200, 2));
    }

    public static Optional<IBloodlineManager> getBloodlineData(LivingEntity entity) {
        if (entity instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)entity;
            return BloodlineMobManager.getSafe((Entity)pathfinderMob).filter(blManager -> blManager.getBloodline() != null).map(blManager -> blManager);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BloodlineManager blManager2 = BloodlineManager.get(player);
            return blManager2.getBloodline() != null ? Optional.of(blManager2) : Optional.empty();
        }
        return Optional.empty();
    }

    public static IBloodlineManager getBloodlineManager(LivingEntity entity) {
        if (entity instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)entity;
            return BloodlineMobManager.get(pathfinderMob);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return BloodlineManager.get(player);
        }
        return null;
    }

    public static boolean lightMatches(int requiredLight, BlockPos pos, Level level, boolean includeShade) {
        int skyLight;
        int blockLight = level.getBrightness(LightLayer.BLOCK, pos);
        int highestLight = Math.max(blockLight, skyLight = level.getBrightness(LightLayer.SKY, pos));
        if (highestLight > requiredLight && !includeShade) {
            return false;
        }
        if (level.isNight() && includeShade && blockLight < requiredLight && skyLight <= 13) {
            return true;
        }
        return highestLight < requiredLight;
    }
}

