/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.capabilities.bloodlines;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.blocks.entities.PhylacteryBlockEntity;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodlineEventReceiver;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlineState;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlinesPlayerAttributes;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.hunter.BloodlineGravebound;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.BloodlineFrost;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.VampireBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.other.IPossessedEntity;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.config.HunterBloodlinesConfig;
import com.thedrofdoctoring.bloodlines.core.BloodlinesBlocks;
import com.thedrofdoctoring.bloodlines.core.BloodlinesEffects;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import com.thedrofdoctoring.bloodlines.data.BloodlinesTagsProviders;
import com.thedrofdoctoring.bloodlines.effects.HeinousCurseEffect;
import com.thedrofdoctoring.bloodlines.entity.GraveboundTargetModifier;
import com.thedrofdoctoring.bloodlines.entity.ZealotTargetGoalModifier;
import com.thedrofdoctoring.bloodlines.networking.packets.from_client.ServerboundIcePacket;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkills;
import com.thedrofdoctoring.bloodlines.skills.actions.BloodlineActions;
import com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound.GraveboundMistFormAction;
import com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound.GraveboundPossessionAction;
import com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound.GraveboundSoulClaimingAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IDrinkBloodContext;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.event.ActionEvent;
import de.teamlapen.vampirism.api.event.BloodDrinkEvent;
import de.teamlapen.vampirism.api.event.PlayerFactionEvent;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModDamageTypes;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.actions.InvisibilityVampireAction;
import de.teamlapen.vampirism.entity.player.vampire.skills.VampireSkills;
import de.teamlapen.vampirism.entity.vampire.DrinkBloodContext;
import de.teamlapen.vampirism.mixin.accessor.GoalSelectorAccessor;
import de.teamlapen.vampirism.mixin.accessor.NearestAttackableTargetGoalAccessor;
import de.teamlapen.vampirism.util.Helper;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="bloodlines")
public class BloodlineEventHandler {
    private static final Object2BooleanMap<String> entityAIReplacementWarnMap = new Object2BooleanArrayMap();

    @SubscribeEvent
    public static void onChangeFaction(PlayerFactionEvent.FactionLevelChanged event) {
        if (event.getPlayer().asEntity().getCommandSenderWorld().isClientSide) {
            return;
        }
        if (event.getNewLevel() == 0 || event.getCurrentFaction() != event.getOldFaction() && event.getOldFaction() != null) {
            BloodlineManager.getOpt(event.getPlayer().asEntity()).ifPresent(bl -> {
                IBloodline bloodline = bl.getBloodline();
                int rank = bl.getRank();
                bl.setBloodline(null);
                bl.setRank(0);
                bl.onBloodlineChange(bloodline, rank);
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            entity = event.getLevel();
            if (entity instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)entity;
                BloodlineManager manager = BloodlineManager.get(player);
                BloodlineGravebound.State state = BloodlineGravebound.getGraveboundState(manager);
                if (state == null || state.getPhylacteryDimension() == null) {
                    return;
                }
                ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)state.getPhylacteryDimension());
                ServerLevel phylacteryDimension = level.getServer().getLevel(dimension);
                if (phylacteryDimension != null && state.getPhylacteryPos() != null) {
                    BlockState block = phylacteryDimension.getBlockState(state.getPhylacteryPos());
                    if (!block.is(BloodlinesBlocks.PHYLACTERY)) {
                        state.setPhylactery(null, null);
                        manager.updatePlayerCache();
                        manager.sync(false);
                    } else {
                        PhylacteryBlockEntity phylactery;
                        BlockEntity blockEntity = phylacteryDimension.getBlockEntity(state.getPhylacteryPos());
                        if (blockEntity instanceof PhylacteryBlockEntity && (phylactery = (PhylacteryBlockEntity)blockEntity).getOwnerUUID() != null && !phylactery.getOwnerUUID().equals(player.getUUID())) {
                            state.setPhylactery(null, null);
                            manager.updatePlayerCache();
                            manager.sync(false);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLeaveWorld(EntityLeaveLevelEvent event) {
        IPossessedEntity possessed;
        Object atts;
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            atts = BloodlinesPlayerAttributes.get(player);
            if (((BloodlinesPlayerAttributes)atts).getGraveboundData().possessionActive) {
                LivingEntity possessed2 = ((BloodlinesPlayerAttributes)atts).getGraveboundData().possessedEntity;
                if (possessed2 != null && possessed2.isAlive()) {
                    ((IPossessedEntity)possessed2).bloodlines$clearPossession();
                }
                GraveboundPossessionAction.clearPossession(player);
                HunterPlayer.get((Player)player).getActionHandler().deactivateAction((ILastingAction)BloodlineActions.GRAVEBOUND_POSSESSION_ACTION.get());
            }
        }
        if ((atts = event.getEntity()) instanceof IPossessedEntity && (possessed = (IPossessedEntity)atts).bloodlines$isPossessed() && possessed.bloodlines$getPossessedPlayer() != null) {
            Player possessor = possessed.bloodlines$getPossessedPlayer();
            BloodlinesPlayerAttributes atts2 = BloodlinesPlayerAttributes.get(possessor);
            atts2.getGraveboundData().possessedEntity = null;
        }
    }

    @SubscribeEvent
    public static void onLeaveWorld(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        BloodlinesPlayerAttributes atts = BloodlinesPlayerAttributes.get(player);
        if (atts.getGraveboundData().possessionActive) {
            LivingEntity possessed = atts.getGraveboundData().possessedEntity;
            if (possessed != null && possessed.isAlive()) {
                ((IPossessedEntity)possessed).bloodlines$clearPossession();
            }
            GraveboundPossessionAction.clearPossession(player);
            HunterPlayer.get((Player)player).getActionHandler().deactivateAction((ILastingAction)BloodlineActions.GRAVEBOUND_POSSESSION_ACTION.get());
        }
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        IPossessedEntity possessed;
        IBloodline iBloodline;
        IBloodlineManager manager = BloodlineHelper.getBloodlineManager(event.getEntity());
        if (manager != null && (iBloodline = manager.getBloodline()) instanceof IBloodlineEventReceiver) {
            IBloodlineEventReceiver eventReceiver = (IBloodlineEventReceiver)((Object)iBloodline);
            eventReceiver.onLivingDeath(event);
        }
        GraveboundSoulClaimingAction.handleSoulClaiming(event);
        iBloodline = event.getEntity();
        if (iBloodline instanceof IPossessedEntity && (possessed = (IPossessedEntity)((Object)iBloodline)).bloodlines$isPossessed() && possessed.bloodlines$getPossessedPlayer() != null) {
            Player possessor = possessed.bloodlines$getPossessedPlayer();
            GraveboundPossessionAction.clearPossession(possessor);
        }
    }

    @SubscribeEvent
    public static void onPotionRemove(MobEffectEvent.Remove event) {
        LivingEntity livingEntity;
        if (event.getEffect() == ModEffects.OBLIVION && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            BloodlineManager.getOpt(player).ifPresent(bl -> {
                if (bl.getBloodline() != null) {
                    bl.getBloodline().onBloodlineChange((LivingEntity)player, bl.getRank());
                }
            });
        }
    }

    @SubscribeEvent
    public static void onExperienceGain(PlayerXpEvent.XpChange event) {
        BloodlinesPlayerAttributes atts = BloodlinesPlayerAttributes.get(event.getEntity());
        if (atts.bloodline == BloodlineRegistry.BLOODLINE_GRAVEBOUND.get()) {
            float xpMult = ((Double)((List)HunterBloodlinesConfig.graveboundRankExperienceMult.get()).get(atts.bloodlineRank - 1)).floatValue();
            event.setAmount((int)((float)event.getAmount() * xpMult));
        }
    }

    @SubscribeEvent
    public static void onBloodDrink(BloodDrinkEvent.PlayerDrinkBloodEvent event) {
        VampirePlayer vp;
        BloodlineManager manager;
        IBloodline iBloodline;
        IVampire iVampire = event.getVampire();
        if (iVampire instanceof VampirePlayer && (iBloodline = (manager = BloodlineManager.get((vp = (VampirePlayer)iVampire).asEntity())).getBloodline()) instanceof VampireBloodline) {
            VampireBloodline vampireBloodline = (VampireBloodline)iBloodline;
            vampireBloodline.onBloodDrink(event, manager.getRank() - 1, vp);
        }
    }

    @SubscribeEvent
    public static void onCrit(CriticalHitEvent event) {
        IBloodline sourceBloodline = BloodlineManager.get(event.getEntity()).getBloodline();
        if (sourceBloodline instanceof IBloodlineEventReceiver) {
            IBloodlineEventReceiver receiver = (IBloodlineEventReceiver)((Object)sourceBloodline);
            receiver.onCrit(event);
        }
    }

    @SubscribeEvent
    public static void onTick(PlayerTickEvent.Post event) {
        IBloodline bl = BloodlinesPlayerAttributes.get((Player)event.getEntity()).bloodline;
        if (bl instanceof IBloodlineEventReceiver) {
            IBloodlineEventReceiver receiver = (IBloodlineEventReceiver)((Object)bl);
            receiver.tick(event.getEntity());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDamage(LivingIncomingDamageEvent event) {
        IBloodlineManager targetManager;
        Object phylacteryOpt;
        if (event.getEntity().getCommandSenderWorld().isClientSide) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getAmount() >= event.getEntity().getHealth()) {
                BloodlineManager bl = BloodlineManager.get(player);
                if (((Boolean)CommonConfig.ectothermUniqueUnlock.get()).booleanValue() && Helper.isVampire((Player)player) && event.getSource().is(ModDamageTypes.SUN_DAMAGE) && bl.getBloodline() == null && player.hasEffect(BloodlinesEffects.COLD_BLOODED) && player.isInWater()) {
                    player.removeEffect(BloodlinesEffects.COLD_BLOODED);
                    player.addEffect(new MobEffectInstance((Holder)ModEffects.SUNSCREEN, 600, 2));
                    BloodlineHelper.joinBloodlineGeneric(player, (IBloodline)BloodlineRegistry.BLOODLINE_ECTOTHERM.get(), (Component)Component.translatable((String)"text.bloodlines.ectotherm_join").withStyle(ChatFormatting.DARK_RED));
                    event.setCanceled(true);
                    return;
                }
                if (((Boolean)HunterBloodlinesConfig.graveboundUniqueUnlock.get()).booleanValue() && player.hasEffect(BloodlinesEffects.SOUL_RENDING) && player.hasEffect(BloodlinesEffects.HEINOUS_CURSE) && Helper.isHunter((Player)player) && bl.getBloodline() == null && ((Optional)(phylacteryOpt = PhylacteryBlockEntity.searchForNearbyPhylactery(player.level(), player.getOnPos().above(), false, -2, 2, -2, 2, -2, 2))).isPresent() && ((PhylacteryBlockEntity)((Object)((Optional)phylacteryOpt).get())).getOwner() == null) {
                    BloodlineState bloodlineState;
                    PhylacteryBlockEntity phylactery = (PhylacteryBlockEntity)((Object)((Optional)phylacteryOpt).get());
                    BlockPos phylacteryPos = phylactery.getBlockPos();
                    BloodlineHelper.joinBloodlineGeneric(player, (IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), (Component)Component.translatable((String)"text.bloodlines.gravebound_join").withStyle(ChatFormatting.DARK_RED));
                    phylactery.setOwner(player);
                    player.removeEffect(BloodlinesEffects.SOUL_RENDING);
                    player.removeEffect(BloodlinesEffects.HEINOUS_CURSE);
                    BloodlineManager manager = BloodlineManager.get(player);
                    if (manager.getBloodlineState().isPresent() && (bloodlineState = manager.getBloodlineState().get()) instanceof BloodlineGravebound.State) {
                        BloodlineGravebound.State state = (BloodlineGravebound.State)bloodlineState;
                        state.setPhylactery(phylacteryPos, player.level().dimension().location());
                        state.setSouls(10);
                        manager.sync(false);
                    }
                    player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, 2));
                    ModParticles.spawnParticlesServer((Level)player.level(), (ParticleOptions)ParticleTypes.SOUL, (double)phylacteryPos.getX(), (double)phylacteryPos.getY(), (double)phylacteryPos.getZ(), (int)100, (double)0.0, (double)1.0, (double)0.0, (double)0.1f);
                    event.setCanceled(true);
                    return;
                }
            }
        }
        if ((targetManager = BloodlineHelper.getBloodlineManager(event.getEntity())) != null && (phylacteryOpt = targetManager.getBloodline()) instanceof IBloodlineEventReceiver) {
            IBloodlineEventReceiver receiver = (IBloodlineEventReceiver)phylacteryOpt;
            receiver.onReceiveDamage(event, event.getEntity(), targetManager.getRank() - 1);
        }
        if ((phylacteryOpt = event.getSource().getEntity()) instanceof LivingEntity) {
            IBloodline iBloodline;
            IBloodlineManager sourceManager;
            LivingEntity source = (LivingEntity)phylacteryOpt;
            if (!event.isCanceled() && (sourceManager = BloodlineHelper.getBloodlineManager(source)) != null && (iBloodline = sourceManager.getBloodline()) instanceof IBloodlineEventReceiver) {
                IBloodlineEventReceiver receiver = (IBloodlineEventReceiver)((Object)iBloodline);
                receiver.onDealDamage(event, source, event.getEntity(), sourceManager.getRank() - 1);
            }
        }
    }

    @SubscribeEvent
    public static void livingFallEvent(LivingFallEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && Helper.isVampire((Player)(player = (Player)livingEntity)) && player.getBlockStateOn().is(BloodlinesTagsProviders.BloodlinesBlockTagProvider.ZEALOT_STONE) && VampirePlayer.get((Player)player).getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.ZEALOT_FALL_DAMAGE.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        BloodlinesPlayerAttributes atts = BloodlinesPlayerAttributes.get(event.getEntity());
        if (atts.getGraveboundData().mistForm) {
            DamageSource lastKnownDamageSource = atts.getGraveboundData().lastDamageSource;
            if (lastKnownDamageSource != null) {
                event.getEntity().hurt(lastKnownDamageSource, 1000.0f);
            } else {
                event.getEntity().kill();
            }
        }
    }

    @SubscribeEvent
    public static void onFoodEatenFinish(LivingEntityUseItemEvent.Finish event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && Helper.isVampire((Player)(player = (Player)livingEntity))) {
            VampirePlayer vp = VampirePlayer.get((Player)player);
            if (event.getItem().is(Items.ROTTEN_FLESH) && vp.getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.ZEALOT_FLESH_EATING.get())) {
                MobEffectInstance hungerEffectInstance = player.getEffect(MobEffects.HUNGER);
                if (hungerEffectInstance != null && hungerEffectInstance.getDuration() == 600) {
                    player.removeEffect(MobEffects.HUNGER);
                }
                vp.drinkBlood(((Integer)CommonConfig.zealotFleshEatingNutrition.get()).intValue(), ((Double)CommonConfig.zealotFleshEatingSaturation.get()).floatValue(), (IDrinkBloodContext)new DrinkBloodContext(event.getItem()));
            }
            if (event.getItem().is(BloodlinesTagsProviders.BloodlinesItemTagProvider.ECTOTHERM_RAW_FISH) && vp.getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.FISHMONGER.get())) {
                vp.drinkBlood(((Integer)CommonConfig.ectothermFishmongerNutrition.get()).intValue(), ((Double)CommonConfig.ectothermFishmongerSaturation.get()).floatValue(), (IDrinkBloodContext)new DrinkBloodContext(event.getItem()));
            }
        }
    }

    @SubscribeEvent
    public static void actionActivatedEvent(ActionEvent.ActionActivatedEvent event) {
        if (event.getAction() instanceof InvisibilityVampireAction) {
            ISkillHandler skillHandler = event.getFactionPlayer().getSkillHandler();
            if (skillHandler.isSkillEnabled((ISkill)BloodlineSkills.NOBLE_INVISIBILITY.get()) && skillHandler.isSkillEnabled((ISkill)VampireSkills.VAMPIRE_INVISIBILITY.get())) {
                event.setDuration((Integer)CommonConfig.bothInvisibilityDuration.get() * 20);
            }
        } else if (!(event.getAction() instanceof ILastingAction) && event.getFactionPlayer().getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.ZEALOT_SHADOW_MASTERY.get())) {
            Player player = event.getFactionPlayer().asEntity();
            if (BloodlineHelper.lightMatches((Integer)CommonConfig.zealotShadowMasteryLightLevel.get(), player.getOnPos().above(), player.getCommandSenderWorld(), false)) {
                int rank = BloodlineHelper.getBloodlineRank(player) - 1;
                event.setCooldown(Math.round((float)event.getCooldown() * ((Double)((List)CommonConfig.zealotShadowMasteryCooldownMultiplier.get()).get(rank)).floatValue()));
            }
        }
    }

    @SubscribeEvent
    public static void actionDeactivatedEvent(ActionEvent.ActionDeactivatedEvent event) {
        int rank;
        ISkillHandler skillHandler;
        Player player = event.getFactionPlayer().asEntity();
        if (event.getAction() instanceof InvisibilityVampireAction && (skillHandler = event.getFactionPlayer().getSkillHandler()).isSkillEnabled((ISkill)BloodlineSkills.NOBLE_INVISIBILITY.get()) && skillHandler.isSkillEnabled((ISkill)VampireSkills.VAMPIRE_INVISIBILITY.get())) {
            event.setCooldown((Integer)CommonConfig.bothInvisibilityCooldown.get() * 20);
        }
        if (event.getFactionPlayer().getSkillHandler().isSkillEnabled((ISkill)BloodlineSkills.ZEALOT_SHADOW_MASTERY.get()) && BloodlineHelper.lightMatches((Integer)CommonConfig.zealotShadowMasteryLightLevel.get(), player.getOnPos().above(), player.getCommandSenderWorld(), false)) {
            int rank2 = BloodlineHelper.getBloodlineRank(player) - 1;
            event.setCooldown(Math.round((float)event.getCooldown() * ((Double)((List)CommonConfig.zealotShadowMasteryCooldownMultiplier.get()).get(rank2)).floatValue()));
        }
        if (player.level().getBiome(player.getOnPos()).is(Tags.Biomes.IS_HOT) && BloodlineManager.get(event.getFactionPlayer().asEntity()).getBloodline() instanceof BloodlineFrost && (rank = BloodlineManager.get(player).getRank() - 1) >= (Integer)CommonConfig.ectothermHotBiomeActionCooldownRank.get()) {
            event.setCooldown(Math.round((float)event.getCooldown() * ((Double)((List)CommonConfig.ectothermHotBiomeActionCooldownMultiplier.get()).get(rank)).floatValue()));
        }
    }

    @SubscribeEvent
    public static void breakSpeed(PlayerEvent.BreakSpeed event) {
        BloodlinesPlayerAttributes atts = BloodlinesPlayerAttributes.get(event.getEntity());
        if (atts.bloodline == BloodlineRegistry.BLOODLINE_ZEALOT.get()) {
            int rank = atts.bloodlineRank - 1;
            float additionalSpeed = 0.0f;
            if (event.getState().is(BloodlinesTagsProviders.BloodlinesBlockTagProvider.ZEALOT_STONE) && atts.getZealotAtts().hasTunneler) {
                additionalSpeed = ((Double)((List)CommonConfig.zealotTunnelerIncrease.get()).get(rank)).floatValue();
            }
            event.setNewSpeed((event.getOriginalSpeed() + additionalSpeed) * ((Double)((List)CommonConfig.zealotMiningSpeedIncrease.get()).get(rank)).floatValue());
        }
    }

    @SubscribeEvent
    public static void interact(PlayerInteractEvent.RightClickEmpty event) {
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        HitResult result = event.getEntity().pick(10.0, 1.0f, true);
        if (!(result instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockResult = (BlockHitResult)result;
        Player player = event.getEntity();
        BlockPos eyePos = BlockPos.containing((Position)player.getEyePosition());
        Level level = event.getLevel();
        if (level.getBlockState(eyePos).is(Blocks.WATER)) {
            return;
        }
        BlockPos pos = blockResult.getBlockPos();
        if (level.getBlockState(pos).is(Blocks.WATER)) {
            BloodlineFrost.SpecialAttributes atts = BloodlinesPlayerAttributes.get(player).getEctothermAtts();
            if (atts.icePhasing && atts.frostControl && Minecraft.getInstance().getConnection() != null) {
                Minecraft.getInstance().getConnection().send((CustomPacketPayload)ServerboundIcePacket.getInstance());
            }
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        Player player;
        LivingEntity living = event.getEntity();
        if (living instanceof Player && Helper.isVampire((Player)(player = (Player)living))) {
            BloodlineEventHandler.removeBloodknightBatMult(player);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        Player player;
        LivingEntity living = event.getEntity();
        if (living instanceof Player && Helper.isVampire((Player)(player = (Player)living))) {
            BloodlineEventHandler.removeBloodknightBatMult(player);
        }
        if (living instanceof Player) {
            player = (Player)living;
            if (event.getEffectInstance() != null && event.getEffectInstance().is(BloodlinesEffects.HEINOUS_CURSE)) {
                HeinousCurseEffect.handleHeinousEnding(player);
            }
        }
    }

    private static void removeBloodknightBatMult(Player player) {
        VampirePlayer vp = VampirePlayer.get((Player)player);
        if (vp.getSpecialAttributes().bat && !vp.getActionHandler().isActionActive((ILastingAction)BloodlineActions.BLOODKNIGHT_SANGUINE_INFUSION.get())) {
            player.getAbilities().setFlyingSpeed(((Double)VampirismConfig.BALANCE.vaBatFlightSpeed.get()).floatValue());
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof Spider) {
            BloodlineEventHandler.makeFriendly(false, "spider", (Spider)event.getEntity(), Spider.SpiderTargetGoal.class, Player.class, 2, type -> type == EntityType.SPIDER || type == EntityType.CAVE_SPIDER);
        }
        if (((Boolean)HunterBloodlinesConfig.graveboundUndeadMobsignore.get()).booleanValue()) {
            if (event.getEntity() instanceof Zombie) {
                BloodlineEventHandler.makeFriendly(true, "zombie", (Zombie)event.getEntity(), NearestAttackableTargetGoal.class, Player.class, 2, type -> type == EntityType.ZOMBIE || type == EntityType.HUSK || type == EntityType.ZOMBIE_VILLAGER || type == EntityType.DROWNED);
            }
            if (event.getEntity() instanceof Skeleton || event.getEntity() instanceof Stray) {
                BloodlineEventHandler.makeFriendly(true, "skeleton", (AbstractSkeleton)event.getEntity(), NearestAttackableTargetGoal.class, Player.class, 2, type -> type == EntityType.SKELETON);
            }
        }
    }

    public static <T extends Mob, S extends LivingEntity, Q extends NearestAttackableTargetGoal<S>> void makeFriendly(boolean gravebound, String name, @NotNull T e, @NotNull Class<Q> targetClass, @NotNull Class<S> targetEntityClass, int attackPriority, @NotNull Predicate<EntityType<? extends T>> typeCheck) {
        Goal target = null;
        for (WrappedGoal t : ((GoalSelectorAccessor)e.targetSelector).getAvailableGoals()) {
            Goal g = t.getGoal();
            if (!targetClass.equals(g.getClass()) || t.getPriority() != attackPriority || !targetEntityClass.equals(((NearestAttackableTargetGoalAccessor)g).getTargetType())) continue;
            target = g;
            break;
        }
        if (target != null) {
            EntityType type = e.getType();
            if (!gravebound && typeCheck.test(type)) {
                ((ZealotTargetGoalModifier)target).bloodlines$ignoreZealotSpiderFriend();
            } else if (typeCheck.test(type)) {
                ((GraveboundTargetModifier)target).bloodlines$ignoreGravebound();
            }
        } else if (entityAIReplacementWarnMap.getOrDefault((Object)name, true)) {
            Bloodlines.LOGGER.warn("Could not modify {} attack target task for {}", (Object)name, (Object)e.getType().getDescription());
            entityAIReplacementWarnMap.put((Object)name, false);
        }
    }

    @SubscribeEvent
    public static void eyeHeight(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityEvent.Size event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (player = (Player)entity).getInventory() != null && event.getEntity().isAlive() && event.getEntity().position().lengthSqr() != 0.0 && event.getEntity().getVehicle() == null && BloodlinesPlayerAttributes.get((Player)((Player)event.getEntity())).getGraveboundData().mistForm) {
            event.setNewSize(GraveboundMistFormAction.MISTFORM_SIZE);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onAttackEntity(@NotNull AttackEntityEvent event) {
        Player player = event.getEntity();
        if (player.isAlive() && BloodlinesPlayerAttributes.get((Player)event.getEntity()).getGraveboundData().mistForm) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockPlaced(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BlockEvent.EntityPlaceEvent event) {
        if (!(event.getEntity() instanceof Player) || !event.getEntity().isAlive()) {
            return;
        }
        if (event.getPlacedBlock().isAir()) {
            return;
        }
        try {
            if (BloodlinesPlayerAttributes.get((Player)((Player)event.getEntity())).getGraveboundData().mistForm) {
                MinecraftServer server;
                BlockEntity t;
                event.setCanceled(true);
                if (event.getPlacedBlock().hasBlockEntity() && (t = event.getLevel().getBlockEntity(event.getPos())) instanceof Container) {
                    ((Container)t).clearContent();
                }
                if (event.getEntity() instanceof ServerPlayer && (server = event.getEntity().level().getServer()) != null) {
                    server.getPlayerList().sendAllPlayerInfo((ServerPlayer)event.getEntity());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.BreakSpeed event) {
        if (BloodlinesPlayerAttributes.get((Player)event.getEntity()).getGraveboundData().mistForm) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onItemPickupPre(@NotNull ItemEntityPickupEvent.Pre event) {
        if (BloodlinesPlayerAttributes.get((Player)event.getPlayer()).getGraveboundData().mistForm) {
            event.setCanPickup(TriState.FALSE);
        }
    }

    @SubscribeEvent
    public static void onItemRightClick(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerInteractEvent.RightClickItem event) {
        if ((event.getItemStack().getItem() instanceof ThrowablePotionItem || event.getItemStack().getItem() instanceof CrossbowItem) && BloodlinesPlayerAttributes.get((Player)event.getEntity()).getGraveboundData().mistForm) {
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)event.getLevel().isClientSide()));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onItemUse(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LivingEntityUseItemEvent.Start event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (BloodlinesPlayerAttributes.get((Player)player).getGraveboundData().mistForm) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onBlockRightClicked(PlayerInteractEvent.RightClickBlock event) {
        if (BloodlinesPlayerAttributes.get((Player)event.getEntity()).getGraveboundData().mistForm) {
            event.setCanceled(true);
        }
    }
}

