/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.blocks.entities;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.core.BloodlinesBlockEntities;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.particle.FlyingBloodParticleOptions;
import de.teamlapen.vampirism.util.Helper;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZealotAltarBlockEntity
extends BlockEntity {
    private static final int TOTAL_DURATION = 700;
    private int currentTick;
    private UUID currentPlayerUUID;
    private Player currentPlayer;

    public ZealotAltarBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BloodlinesBlockEntities.ZEALOT_ALTAR.get(), pPos, pBlockState);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        return this.saveWithoutMetadata(lookupProvider);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void saveAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.saveAdditional(nbt, lookupProvider);
        nbt.putInt("tick", this.currentTick);
        if (this.currentPlayer != null) {
            nbt.putUUID("player_uuid", this.currentPlayer.getUUID());
        }
    }

    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket pkt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        CompoundTag tag = pkt.getTag();
        if (this.hasLevel()) {
            this.loadCustomOnly(tag, lookupProvider);
        }
    }

    public void startRitual(Player player) {
        if (this.level == null) {
            return;
        }
        this.currentPlayer = player;
        this.currentTick = 700;
        this.setChanged();
        if (!this.level.isClientSide) {
            BlockState state = this.level.getBlockState(this.getBlockPos());
            this.level.sendBlockUpdated(this.getBlockPos(), state, state, 3);
        }
    }

    private void progressRitual() {
        int zOffset;
        if (this.currentPlayer == null || !this.currentPlayer.isAlive()) {
            this.currentTick = 1;
            return;
        }
        if (this.currentPlayer.getDeltaMovement().y >= 0.0) {
            this.currentPlayer.setDeltaMovement(0.0, 0.0, 0.0);
        } else {
            this.currentPlayer.setDeltaMovement(0.0, this.currentPlayer.getDeltaMovement().y, 0.0);
            this.currentPlayer.setDeltaMovement(this.currentPlayer.getDeltaMovement().multiply(1.0, 0.5, 1.0));
        }
        if (this.level == null) {
            return;
        }
        if (this.currentTick > 600 && this.currentTick % 15 == 0) {
            BlockPos pos = this.getBlockPos();
            ModParticles.spawnParticlesClient((Level)this.level, (ParticleOptions)new FlyingBloodParticleOptions(60, false, (double)pos.getX(), (double)(pos.getY() + 2), (double)pos.getZ() + 0.5), (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (double)0.0, (double)0.0, (double)0.0, (int)5, (double)0.1, (RandomSource)RandomSource.create());
        }
        if (this.currentTick <= 650 && this.currentTick % 30 == 0) {
            int xOffset = this.level.getRandom().nextInt(-6, 10);
            zOffset = this.level.getRandom().nextInt(-6, 10);
            this.level.playSound(null, this.currentPlayer.getX() + (double)xOffset, this.currentPlayer.getY(), this.currentPlayer.getZ() + (double)zOffset, SoundEvents.ENDERMITE_STEP, SoundSource.BLOCKS);
        }
        if (this.currentTick <= 650 && this.currentTick % 20 == 0 && this.currentTick >= 400) {
            int xOffset = this.level.getRandom().nextInt(-10, 15);
            zOffset = this.level.getRandom().nextInt(-10, 15);
            this.level.playSound(null, this.currentPlayer.getX() + (double)xOffset, this.currentPlayer.getY(), this.currentPlayer.getZ() + (double)zOffset, SoundEvents.BASALT_BREAK, SoundSource.BLOCKS);
        }
        if (this.currentTick <= 400 && this.currentTick % 10 == 0) {
            int xOffset = this.level.getRandom().nextInt(-8, 8);
            zOffset = this.level.getRandom().nextInt(-8, 8);
            this.level.playSound(null, this.currentPlayer.getX() + (double)xOffset, this.currentPlayer.getY(), this.currentPlayer.getZ() + (double)zOffset, SoundEvents.BASALT_BREAK, SoundSource.BLOCKS);
        }
        if (this.currentTick <= 650) {
            this.currentPlayer.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 30, 2));
        }
        if (this.currentTick <= 400 && this.currentTick % 100 == 0) {
            this.level.playSound(null, this.currentPlayer.getX(), this.currentPlayer.getY(), this.currentPlayer.getZ(), (SoundEvent)SoundEvents.AMBIENT_CAVE.value(), SoundSource.BLOCKS);
        }
        if (this.currentTick <= 600) {
            this.currentPlayer.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 30, 2));
        }
        if (this.currentTick == 50) {
            if (!this.level.isClientSide) {
                BloodlineHelper.joinBloodlineGeneric(this.currentPlayer, (IBloodline)BloodlineRegistry.BLOODLINE_ZEALOT.get(), (Component)Component.translatable((String)"text.bloodlines.zealot_join").withStyle(ChatFormatting.DARK_RED));
            }
            this.currentPlayer.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 400, 2));
            this.currentPlayer.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 400, 2));
        }
        if (this.currentTick < 50) {
            this.currentPlayer = null;
            this.currentPlayerUUID = null;
            this.currentTick = 0;
            this.setChanged();
        }
    }

    public static void tick(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ZealotAltarBlockEntity altar) {
        if (altar.currentPlayerUUID != null) {
            if (altar.ritualStateInvalid(altar.currentPlayerUUID)) {
                return;
            }
            altar.currentPlayerUUID = null;
            altar.setChanged();
            level.sendBlockUpdated(pos, state, state, 3);
        }
        if (altar.currentTick == 700 && !level.isClientSide) {
            altar.setChanged();
        }
        if (altar.currentTick > 0) {
            --altar.currentTick;
            altar.progressRitual();
        }
    }

    public void loadAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.loadAdditional(nbt, lookupProvider);
        int tick = nbt.getInt("tick");
        if (tick > 0 && this.currentPlayer == null && nbt.hasUUID("player_uuid")) {
            UUID uuid = nbt.getUUID("player_uuid");
            if (this.ritualStateInvalid(uuid)) {
                this.currentPlayerUUID = uuid;
            }
            this.currentTick = tick;
        }
    }

    private boolean ritualStateInvalid(UUID currentPlayerUUID) {
        if (this.level == null) {
            return true;
        }
        if (this.level.players().isEmpty()) {
            return true;
        }
        this.currentPlayer = this.level.getPlayerByUUID(currentPlayerUUID);
        if (this.currentPlayer == null) {
            this.currentTick = 0;
        }
        return false;
    }

    @NotNull
    public Result canActivate(@NotNull Player player) {
        if (!((Boolean)CommonConfig.zealotUniqueUnlock.get()).booleanValue()) {
            return Result.DISABLED;
        }
        if (this.currentTick > 0) {
            return Result.RUNNING;
        }
        if (!Helper.isVampire((Player)player)) {
            return Result.NOT_VAMPIRE;
        }
        if (BloodlineHelper.getBloodlineRank(player) > 0) {
            return Result.HAS_BLOODLINE;
        }
        this.currentPlayer = null;
        return Result.OK;
    }

    public static enum Result {
        OK,
        HAS_BLOODLINE,
        NOT_VAMPIRE,
        RUNNING,
        DISABLED;

    }
}

