/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.blocks.entities;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.hunter.BloodlineGravebound;
import com.thedrofdoctoring.bloodlines.config.HunterBloodlinesConfig;
import com.thedrofdoctoring.bloodlines.core.BloodlinesBlockEntities;
import com.thedrofdoctoring.bloodlines.core.BloodlinesBlocks;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhylacteryBlockEntity
extends BlockEntity {
    private UUID ownerUUID;
    private Player owner;
    private int storedSouls;
    private int maxStoredSouls;

    public PhylacteryBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BloodlinesBlockEntities.PHYLACTERY.get(), pPos, pBlockState);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        return this.saveWithoutMetadata(lookupProvider);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(@NotNull Connection net, @NotNull ClientboundBlockEntityDataPacket pkt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        CompoundTag tag = pkt.getTag();
        if (this.hasLevel()) {
            this.loadCustomOnly(tag, lookupProvider);
        }
    }

    public void saveAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.saveAdditional(nbt, lookupProvider);
        if (this.ownerUUID != null) {
            nbt.putUUID("player_uuid", this.ownerUUID);
            nbt.putInt("stored_souls", this.storedSouls);
            nbt.putInt("max_stored_souls", this.maxStoredSouls);
        }
    }

    public void loadAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookupProvider) {
        super.loadAdditional(nbt, lookupProvider);
        if (this.owner == null && nbt.hasUUID("player_uuid")) {
            this.ownerUUID = nbt.getUUID("player_uuid");
            this.storedSouls = nbt.getInt("stored_souls");
            this.maxStoredSouls = nbt.getInt("max_stored_souls");
            if (this.level != null) {
                this.owner = this.level.getPlayerByUUID(this.ownerUUID);
            }
        }
    }

    public Player getOwner() {
        if (this.level != null && this.owner == null && this.ownerUUID != null) {
            this.owner = this.level.getPlayerByUUID(this.ownerUUID);
        }
        return this.owner;
    }

    public int getStoredSouls() {
        return this.storedSouls;
    }

    public void determineMaxSouls(int totalSoulsDevoured) {
        List tiers = (List)HunterBloodlinesConfig.phylacteryMaxStorageTierRequirements.get();
        int i = 0;
        boolean foundTier = false;
        if (totalSoulsDevoured >= (Integer)tiers.getLast()) {
            foundTier = true;
            i = tiers.size() - 1;
        }
        while (i < tiers.size() && !foundTier) {
            int tierRequirement = (Integer)tiers.get(i);
            if (totalSoulsDevoured < tierRequirement) {
                foundTier = true;
                --i;
            }
            if (foundTier) continue;
            ++i;
        }
        if (i >= tiers.size()) {
            this.maxStoredSouls = 5;
            Bloodlines.LOGGER.warn("Unable to obtain Phylactery tier");
        }
        this.maxStoredSouls = (Integer)((List)HunterBloodlinesConfig.phylacteryMaxStorageTiers.get()).get(i);
    }

    public int addSouls(int additional) {
        if (additional > 0) {
            int used = additional;
            if (additional + this.storedSouls > this.maxStoredSouls) {
                used = this.maxStoredSouls - this.storedSouls;
            }
            this.storedSouls = Math.min(this.maxStoredSouls, this.storedSouls + additional);
            return used;
        }
        if (additional < 0) {
            int used = -additional;
            if (additional + this.storedSouls < 0) {
                used = this.storedSouls;
            }
            this.storedSouls = Math.max(this.storedSouls - used, 0);
            return used;
        }
        return 0;
    }

    public void setOwner(@Nullable Player player) {
        this.owner = player;
        if (player == null) {
            this.ownerUUID = null;
            this.storedSouls = 0;
            this.maxStoredSouls = 0;
        } else {
            this.ownerUUID = player.getUUID();
            BloodlineGravebound.State state = BloodlineGravebound.getGraveboundState(player);
            if (state != null) {
                this.determineMaxSouls(state.getTotalSoulsDevoured());
            }
        }
        this.setChanged();
    }

    public int getMaxStoredSouls() {
        return this.maxStoredSouls;
    }

    public boolean hasOwner() {
        return this.ownerUUID != null;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public static Optional<PhylacteryBlockEntity> searchForNearbyPhylactery(Level level, BlockPos origin, boolean allowOwned, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        for (int i = minX; i <= maxX; ++i) {
            for (int j = minY; j <= maxY; ++j) {
                for (int k = minZ; k <= maxZ; ++k) {
                    BlockEntity be;
                    BlockPos pos = new BlockPos(origin.getX() + i, origin.getY() + j, origin.getZ() + k);
                    BlockState state = level.getBlockState(pos);
                    if (!state.is(BloodlinesBlocks.PHYLACTERY) || !((be = level.getBlockEntity(pos)) instanceof PhylacteryBlockEntity)) continue;
                    PhylacteryBlockEntity phylactery = (PhylacteryBlockEntity)be;
                    if (allowOwned) {
                        return Optional.of(phylactery);
                    }
                    if (phylactery.getOwner() != null) continue;
                    return Optional.of(phylactery);
                }
            }
        }
        return Optional.empty();
    }
}

