/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.blocks;

import com.mojang.serialization.MapCodec;
import com.thedrofdoctoring.bloodlines.blocks.entities.ZealotAltarBlockEntity;
import com.thedrofdoctoring.bloodlines.core.BloodlinesBlockEntities;
import com.thedrofdoctoring.bloodlines.core.BloodlinesItems;
import de.teamlapen.vampirism.blocks.AltarInfusionBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ZealotAltarBlock
extends BaseEntityBlock {
    public static final MapCodec<AltarInfusionBlock> CODEC = ZealotAltarBlock.simpleCodec(AltarInfusionBlock::new);
    private static final VoxelShape shrineShape = ZealotAltarBlock.makeShape();

    public ZealotAltarBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    private static VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.75, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.75, (double)0.0, (double)1.0, (double)0.875, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.875, (double)0.0, (double)0.125, (double)1.25, (double)0.125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875, (double)0.875, (double)0.0, (double)1.0, (double)1.25, (double)0.125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.875, (double)0.875, (double)0.875, (double)1.0, (double)1.25, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.875, (double)0.875, (double)0.125, (double)1.25, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.75, (double)0.25, (double)0.75, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)1.25, (double)0.375, (double)0.625, (double)1.5, (double)0.625), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return shrineShape;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack pStack, @NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHitResult) {
        ZealotAltarBlockEntity altarBE = (ZealotAltarBlockEntity)pLevel.getBlockEntity(pPos);
        if (pLevel.isClientSide || altarBE == null) {
            return ItemInteractionResult.SUCCESS;
        }
        if (pStack.is((Item)BloodlinesItems.ZEALOT_RITUAL_CATALYST.get())) {
            ZealotAltarBlockEntity.Result result = altarBE.canActivate(pPlayer);
            switch (result) {
                case DISABLED: {
                    pPlayer.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.zealot_altar.disabled").withStyle(ChatFormatting.DARK_RED), true);
                    return ItemInteractionResult.SUCCESS;
                }
                case RUNNING: {
                    pPlayer.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.zealot_altar.already_running").withStyle(ChatFormatting.DARK_RED), true);
                    return ItemInteractionResult.SUCCESS;
                }
                case HAS_BLOODLINE: {
                    pPlayer.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.zealot_altar.has_bloodline").withStyle(ChatFormatting.DARK_RED), true);
                    return ItemInteractionResult.SUCCESS;
                }
                case NOT_VAMPIRE: {
                    pPlayer.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.zealot_altar.not_vampire").withStyle(ChatFormatting.DARK_RED), true);
                    return ItemInteractionResult.SUCCESS;
                }
                case OK: {
                    pStack.shrink(1);
                    altarBE.startRitual(pPlayer);
                    return ItemInteractionResult.SUCCESS;
                }
            }
        } else {
            pPlayer.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.zealot_altar.incorrect_item").withStyle(ChatFormatting.DARK_RED), true);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return ZealotAltarBlock.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)BloodlinesBlockEntities.ZEALOT_ALTAR.get()), ZealotAltarBlockEntity::tick);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new ZealotAltarBlockEntity(pPos, pState);
    }
}

