/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.blocks;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class SpecialIceBlock
extends HalfTransparentBlock {
    public static final MapCodec<SpecialIceBlock> CODEC = SpecialIceBlock.simpleCodec(SpecialIceBlock::new);
    public static final IntegerProperty MELTAGE = IntegerProperty.create((String)"meltage", (int)0, (int)2);
    public static final BooleanProperty WAS_WATER = BooleanProperty.create((String)"was_water");

    @NotNull
    public MapCodec<? extends SpecialIceBlock> codec() {
        return CODEC;
    }

    public SpecialIceBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public static BlockState meltsInto() {
        return Blocks.WATER.defaultBlockState();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{MELTAGE});
        pBuilder.add(new Property[]{WAS_WATER});
    }

    public void playerDestroy(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable BlockEntity pTe, @NotNull ItemStack pStack) {
        super.playerDestroy(pLevel, pPlayer, pPos, pState, pTe, pStack);
        if (((Boolean)pState.getValue((Property)WAS_WATER)).booleanValue()) {
            pLevel.setBlockAndUpdate(pPos, SpecialIceBlock.meltsInto());
        }
    }

    protected void randomTick(BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        if ((Integer)pState.getValue((Property)MELTAGE) < 2) {
            int melt = (Integer)pState.getValue((Property)MELTAGE);
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)MELTAGE, (Comparable)Integer.valueOf(melt + 1)), 2);
        } else {
            this.melt(pState, (Level)pLevel, pPos);
        }
    }

    protected void melt(BlockState pState, Level pLevel, BlockPos pPos) {
        if (((Boolean)pState.getValue((Property)WAS_WATER)).booleanValue()) {
            pLevel.setBlockAndUpdate(pPos, SpecialIceBlock.meltsInto());
            pLevel.neighborChanged(pPos, SpecialIceBlock.meltsInto().getBlock(), pPos);
        } else {
            pLevel.setBlockAndUpdate(pPos, Blocks.AIR.defaultBlockState());
            pLevel.neighborChanged(pPos, Blocks.AIR, pPos);
        }
    }
}

