/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.blocks;

import com.mojang.serialization.MapCodec;
import com.thedrofdoctoring.bloodlines.blocks.entities.PhylacteryBlockEntity;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.hunter.BloodlineGravebound;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import com.thedrofdoctoring.bloodlines.items.SoulBinderItem;
import de.teamlapen.vampirism.core.ModParticles;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhylacteryBlock
extends BaseEntityBlock {
    public static final MapCodec<PhylacteryBlock> CODEC = PhylacteryBlock.simpleCodec(PhylacteryBlock::new);
    private static final VoxelShape phylacteryShape = PhylacteryBlock.makeShape();

    public PhylacteryBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    private static VoxelShape makeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.375, (double)0.25, (double)0.75, (double)0.875, (double)0.75), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.40625, (double)0.0, (double)0.40625, (double)0.59375, (double)0.375, (double)0.59375), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return phylacteryShape;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public void playerDestroy(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable BlockEntity pBlockEntity, @NotNull ItemStack pTool) {
        for (int i = 0; i < 5; ++i) {
            pLevel.playSound(null, pPos, (SoundEvent)SoundEvents.SOUL_ESCAPE.value(), SoundSource.BLOCKS);
        }
        ModParticles.spawnParticlesServer((Level)pLevel, (ParticleOptions)ParticleTypes.SOUL, (double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ(), (int)50, (double)0.0, (double)0.5, (double)0.0, (double)0.1f);
        if (!pLevel.isClientSide()) {
            this.syncDestroy((PhylacteryBlockEntity)pBlockEntity);
        }
        super.playerDestroy(pLevel, pPlayer, pPos, pState, pBlockEntity, pTool);
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull BlockHitResult pHitResult) {
        if (pPlayer.getMainHandItem().getItem() instanceof SoulBinderItem) {
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof PhylacteryBlockEntity) {
            PhylacteryBlockEntity phylactery = (PhylacteryBlockEntity)blockEntity;
            if (!pLevel.isClientSide && pPlayer.getUUID().equals(phylactery.getOwnerUUID()) && BloodlineHelper.hasBloodline((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), pPlayer)) {
                int amount;
                BloodlineManager manager = BloodlineManager.get(pPlayer);
                BloodlineGravebound.State state = BloodlineGravebound.getGraveboundState(manager);
                if (state == null) {
                    return InteractionResult.FAIL;
                }
                int n = amount = pPlayer.isShiftKeyDown() ? 5 : 1;
                if (phylactery.getStoredSouls() <= 0) {
                    pPlayer.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.phylactery_souls", (Object[])new Object[]{phylactery.getStoredSouls()}), true);
                    return InteractionResult.SUCCESS;
                }
                int used = phylactery.addSouls(-amount);
                int usedAfter = state.addSouls(used);
                phylactery.addSouls(used - usedAfter);
                phylactery.setChanged();
                phylactery.requestModelDataUpdate();
                pPlayer.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.phylactery_souls", (Object[])new Object[]{phylactery.getStoredSouls()}), true);
                state.updateCache(manager.getRank());
                manager.sync(false);
                return InteractionResult.SUCCESS;
            }
        }
        return super.useWithoutItem(pState, pLevel, pPos, pPlayer, pHitResult);
    }

    protected void onRemove(@NotNull BlockState pState, Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pNewState, boolean pMovedByPiston) {
        BlockEntity blockEntity;
        if (!pLevel.isClientSide() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof PhylacteryBlockEntity) {
            PhylacteryBlockEntity phylactery = (PhylacteryBlockEntity)blockEntity;
            if (!pMovedByPiston) {
                this.syncDestroy(phylactery);
            }
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    private void syncDestroy(PhylacteryBlockEntity phylactery) {
        if (phylactery != null && phylactery.hasOwner()) {
            BloodlineManager manager = BloodlineManager.get(phylactery.getOwner());
            phylactery.getOwner().displayClientMessage((Component)Component.translatable((String)"text.bloodlines.phylactery_destroyed").withStyle(ChatFormatting.DARK_RED), true);
            BloodlineGravebound.State state = BloodlineGravebound.getGraveboundState(manager);
            if (state != null) {
                state.removePhylactery();
                manager.sync(false);
                state.updateCache(manager.getRank());
            }
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return new PhylacteryBlockEntity(pPos, pState);
    }
}

