/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.entity.BloodlineMobManager;
import com.thedrofdoctoring.bloodlines.capabilities.other.VampExtendedCreature;
import com.thedrofdoctoring.bloodlines.commands.BloodlineCommands;
import com.thedrofdoctoring.bloodlines.compat.guide.BloodlinesGuideBook;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.config.HunterBloodlinesConfig;
import com.thedrofdoctoring.bloodlines.core.BloodlinesAttachments;
import com.thedrofdoctoring.bloodlines.core.BloodlinesBlockEntities;
import com.thedrofdoctoring.bloodlines.core.BloodlinesBlocks;
import com.thedrofdoctoring.bloodlines.core.BloodlinesComponents;
import com.thedrofdoctoring.bloodlines.core.BloodlinesEffects;
import com.thedrofdoctoring.bloodlines.core.BloodlinesEntities;
import com.thedrofdoctoring.bloodlines.core.BloodlinesItems;
import com.thedrofdoctoring.bloodlines.core.BloodlinesStats;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import com.thedrofdoctoring.bloodlines.data.BloodlineSelector;
import com.thedrofdoctoring.bloodlines.data.BloodlineSkillTreeProvider;
import com.thedrofdoctoring.bloodlines.data.BloodlinesData;
import com.thedrofdoctoring.bloodlines.data.BloodlinesDataMapsProvider;
import com.thedrofdoctoring.bloodlines.data.BloodlinesRecipeProviders;
import com.thedrofdoctoring.bloodlines.data.BloodlinesTagsProviders;
import com.thedrofdoctoring.bloodlines.data.datamaps.BloodlinesDataMaps;
import com.thedrofdoctoring.bloodlines.data.loot.BloodlinesLoot;
import com.thedrofdoctoring.bloodlines.data.loot.BloodlinesLootModifiersProvider;
import com.thedrofdoctoring.bloodlines.data.loot.BloodlinesLootProvider;
import com.thedrofdoctoring.bloodlines.data.spawn_modifiers.BloodlineRankDistribution;
import com.thedrofdoctoring.bloodlines.data.spawn_modifiers.BloodlineSpawnModifier;
import com.thedrofdoctoring.bloodlines.items.BottomlessChaliceFluidHandler;
import com.thedrofdoctoring.bloodlines.networking.ServerPayloadHandler;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkillType;
import com.thedrofdoctoring.bloodlines.skills.BloodlineSkills;
import com.thedrofdoctoring.bloodlines.skills.actions.BloodlineActions;
import com.thedrofdoctoring.bloodlines.tasks.BloodlineTasks;
import com.thedrofdoctoring.bloodlines.world.structures.BloodlineStructures;
import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillType;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.datamaps.RegisterDataMapTypesEvent;
import org.slf4j.Logger;

@Mod(value="bloodlines")
public class Bloodlines {
    public static final String MODID = "bloodlines";
    public static boolean onServer = true;
    public static final Logger LOGGER = LogUtils.getLogger();

    public Bloodlines(IEventBus modEventBus, ModContainer container) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.COMMON_CONFIG);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)HunterBloodlinesConfig.HUNTER_BLOODLINES_CONFIG, "bloodlines-hunter_bloodlines.toml");
        modEventBus.addListener(this::loadComplete);
        modEventBus.addListener(this::enqueueIMC);
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(this::registerRegistries);
        modEventBus.addListener(this::registerDatapackRegistries);
        modEventBus.addListener(this::registerDataMapTypes);
        modEventBus.addListener(ServerPayloadHandler::registerPayloads);
        BloodlineRegistry.BLOODLINES.register(modEventBus);
        BloodlineCommands.COMMAND_ARGUMENT_TYPES.register(modEventBus);
        BloodlinesItems.register(modEventBus);
        BloodlinesBlocks.BLOCKS.register(modEventBus);
        BloodlineSkills.SKILLS.register(modEventBus);
        BloodlinesEntities.ENTITY_SUB_PREDICATES.register(modEventBus);
        BloodlineActions.ACTIONS.register(modEventBus);
        BloodlinesAttachments.ATTACHMENT_TYPES.register(modEventBus);
        BloodlineTasks.TASK_REWARDS.register(modEventBus);
        BloodlineTasks.TASK_UNLOCKER.register(modEventBus);
        BloodlinesComponents.DATA_COMPONENTS.register(modEventBus);
        BloodlineTasks.TASK_REWARD_INSTANCES.register(modEventBus);
        BloodlinesLoot.GLOBAL_LOOT_MODIFIER_SERIALIZERS.register(modEventBus);
        BloodlinesLoot.LOOT_CONDITION_TYPES.register(modEventBus);
        BloodlinesEffects.EFFECTS.register(modEventBus);
        BloodlinesBlockEntities.BLOCK_ENTITY_TYPES.register(modEventBus);
        BloodlinesEntities.ENTITY_TYPES.register(modEventBus);
        BloodlinesStats.CUSTOM_STAT.register(modEventBus);
        BloodlineStructures.STRUCTURE_TYPES.register(modEventBus);
        BloodlineStructures.STRUCTURE_PIECES.register(modEventBus);
        if (ModList.get().isLoaded("guideapi_vp")) {
            NeoForge.EVENT_BUS.addListener(BloodlinesGuideBook::createCategoriesEvent);
        }
        NeoForge.EVENT_BUS.addListener(this::onCommandsRegister);
    }

    public void onCommandsRegister(RegisterCommandsEvent event) {
        BloodlineCommands.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    public void registerRegistries(NewRegistryEvent event) {
        event.register(BloodlineRegistry.BLOODLINE_REGISTRY);
    }

    public void registerDatapackRegistries(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(BloodlinesData.BLOODLINE_AI_SELECTORS, BloodlineSelector.CODEC.codec(), null);
        event.dataPackRegistry(BloodlinesData.BLOODLINE_SPAWN_MODIFIERS, BloodlineSpawnModifier.CODEC.codec(), null);
        event.dataPackRegistry(BloodlinesData.BLOODLINE_RANK_DISTRIBUTION, BloodlineRankDistribution.CODEC.codec(), null);
    }

    public void registerDataMapTypes(RegisterDataMapTypesEvent event) {
        event.register(BloodlinesDataMaps.ENTITY_SOULS);
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        DatapackBuiltinEntriesProvider provider = new DatapackBuiltinEntriesProvider(packOutput, lookupProvider, BloodlinesData.DATA_BUILDER, Set.of(MODID));
        generator.addProvider(event.includeServer(), (DataProvider)provider);
        lookupProvider = provider.getRegistryProvider();
        BloodlinesTagsProviders.register(generator, event, packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)new BloodlineSkillTreeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new BloodlinesDataMapsProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new BloodlinesRecipeProviders(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)BloodlinesLootProvider.getProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new BloodlinesLootModifiersProvider(packOutput, lookupProvider));
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.FluidHandler.ITEM, (item, b) -> new BottomlessChaliceFluidHandler((ItemStack)item, 25000), new ItemLike[]{(ItemLike)BloodlinesItems.CHALICE_ITEM.get()});
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        VampirismAPI.skillManager().registerSkillType((ISkillType)BloodlineSkillType.NOBLE);
        VampirismAPI.skillManager().registerSkillType((ISkillType)BloodlineSkillType.ZEALOT);
        VampirismAPI.skillManager().registerSkillType((ISkillType)BloodlineSkillType.ECTOTHERM);
        VampirismAPI.skillManager().registerSkillType((ISkillType)BloodlineSkillType.BLOODKNIGHT);
        VampirismAPI.skillManager().registerSkillType((ISkillType)BloodlineSkillType.GRAVEBOUND);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        HelperRegistry.registerSyncablePlayerCapability((AttachmentType)((AttachmentType)BloodlinesAttachments.BLOODLINE_MANAGER.get()), BloodlineManager.class);
        HelperRegistry.registerSyncableEntityCapability((AttachmentType)((AttachmentType)BloodlinesAttachments.BLOODLINE_MOB_MANAGER.get()), BloodlineMobManager.class);
        HelperRegistry.registerSyncableEntityCapability((AttachmentType)((AttachmentType)BloodlinesAttachments.VAMP_EXTENDED_CREATURE.get()), VampExtendedCreature.class);
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

