/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.util;

import com.google.common.collect.Multimap;
import de.maxanier.guideapi.GuideConfig;
import de.maxanier.guideapi.api.GuideAPI;
import de.maxanier.guideapi.api.IGuideItem;
import de.maxanier.guideapi.api.IGuideLinked;
import de.maxanier.guideapi.api.IInfoRenderer;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;

@EventBusSubscriber(modid="guideapi_vp")
public class EventHandler {
    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.getEntity().getCommandSenderWorld().isClientSide && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            CompoundTag tag = EventHandler.getModTag(player, "guideapi_vp");
            if (((Boolean)GuideConfig.COMMON.canSpawnWithBook.get()).booleanValue()) {
                for (Book book : GuideAPI.getBooks().values()) {
                    ModConfigSpec.BooleanValue bookSpawnConfig = GuideConfig.COMMON.SPAWN_BOOKS.get(book);
                    if (bookSpawnConfig != null && !((Boolean)bookSpawnConfig.get()).booleanValue() || tag.getBoolean("hasInitial" + book.getRegistryName().toString())) continue;
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)GuideAPI.getStackFromBook(book));
                    tag.putBoolean("hasInitial" + book.getRegistryName().toString(), true);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void renderOverlay(RenderGuiLayerEvent.Pre event) {
        Multimap<Block, IInfoRenderer> bookRenderers;
        IGuideLinked linked;
        ResourceLocation entryKey;
        ItemStack heldStack;
        if (event.getName() != VanillaGuiLayers.CROSSHAIR) {
            return;
        }
        HitResult rayTrace = Minecraft.getInstance().hitResult;
        if (rayTrace == null || rayTrace.getType() != HitResult.Type.BLOCK) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        ClientLevel world = Minecraft.getInstance().level;
        ItemStack held = ItemStack.EMPTY;
        Book book = null;
        for (InteractionHand hand : InteractionHand.values()) {
            heldStack = player.getItemInHand(hand);
            if (!(heldStack.getItem() instanceof IGuideItem)) continue;
            held = heldStack;
            book = ((IGuideItem)heldStack.getItem()).getBook(heldStack);
            break;
        }
        if (book == null) {
            return;
        }
        BlockPos rayTracePos = ((BlockHitResult)rayTrace).getBlockPos();
        BlockState state = world.getBlockState(rayTracePos);
        Component linkedEntry = null;
        heldStack = state.getBlock();
        if (heldStack instanceof IGuideLinked && (entryKey = (linked = (IGuideLinked)heldStack).getLinkedEntry((Level)world, rayTracePos, (Player)player, held)) != null) {
            for (CategoryAbstract category : book.getCategoryList()) {
                if (!category.entries.containsKey(entryKey)) continue;
                linkedEntry = category.getEntry(entryKey).getName();
                break;
            }
        }
        GuiGraphics graphics = event.getGuiGraphics();
        if (linkedEntry != null) {
            Font fontRenderer = Minecraft.getInstance().font;
            int drawX = Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2 + 10;
            int drawY = Minecraft.getInstance().getWindow().getGuiScaledHeight() / 2 - 8;
            graphics.renderItem(held, drawX, drawY);
            graphics.drawString(fontRenderer, (Component)(linkedEntry instanceof MutableComponent ? ((MutableComponent)linkedEntry).withStyle(ChatFormatting.WHITE) : linkedEntry), drawX += 20, drawY -= 2, 0, true);
            graphics.drawString(fontRenderer, (Component)Component.translatable((String)"guideapi.text.linked.open").withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.ITALIC}), drawX, drawY + 12, 0, true);
        }
        if (state.getBlock() instanceof IInfoRenderer.Block) {
            IInfoRenderer infoRenderer = ((IInfoRenderer.Block)state.getBlock()).getInfoRenderer(book, (Level)world, rayTracePos, state, rayTrace, (Player)player);
            if (book == ((IInfoRenderer.Block)state.getBlock()).getBook() && infoRenderer != null) {
                infoRenderer.drawInformation(graphics, book, (Level)world, rayTracePos, state, rayTrace, (Player)player);
            }
        }
        if ((bookRenderers = GuideAPI.getInfoRenderers().get(book)) == null) {
            return;
        }
        Collection renderers = bookRenderers.get((Object)state.getBlock());
        for (IInfoRenderer renderer : renderers) {
            renderer.drawInformation(graphics, book, (Level)world, rayTracePos, state, rayTrace, (Player)player);
        }
    }

    public static CompoundTag getModTag(Player player, String modName) {
        CompoundTag modTag;
        CompoundTag persistTag;
        CompoundTag tag = player.getPersistentData();
        if (tag.contains("PlayerPersisted")) {
            persistTag = tag.getCompound("PlayerPersisted");
        } else {
            persistTag = new CompoundTag();
            tag.put("PlayerPersisted", (Tag)persistTag);
        }
        if (persistTag.contains(modName)) {
            modTag = persistTag.getCompound(modName);
        } else {
            modTag = new CompoundTag();
            persistTag.put(modName, (Tag)modTag);
        }
        return modTag;
    }
}

