/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.util;

import com.google.common.collect.Lists;
import de.maxanier.guideapi.api.GuideAPI;
import de.maxanier.guideapi.api.GuideBook;
import de.maxanier.guideapi.api.IGuideBook;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.util.APISetter;
import de.maxanier.guideapi.util.LogHelper;
import java.util.Collection;
import java.util.List;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.Type;

public class AnnotationHandler {
    public static final List<Pair<Book, IGuideBook>> BOOK_CLASSES = Lists.newArrayList();
    private static final Type GUIDE = Type.getType(GuideBook.class);

    public static void gatherBooks() {
        List<ModFileScanData.AnnotationData> annotations = ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> GUIDE.equals((Object)a.annotationType())).toList();
        for (EventPriority priority : EventPriority.values()) {
            for (ModFileScanData.AnnotationData data : annotations) {
                try {
                    IGuideBook guideBook;
                    Book book;
                    Class<?> genericClass;
                    EventPriority priority1 = data.annotationData().getOrDefault("priority", EventPriority.NORMAL);
                    if (priority != priority1 || !IGuideBook.class.isAssignableFrom(genericClass = Class.forName(data.clazz().getClassName())) || (book = (guideBook = (IGuideBook)genericClass.newInstance()).buildBook()) == null) continue;
                    APISetter.registerBook(book);
                    BOOK_CLASSES.add((Pair<Book, IGuideBook>)Pair.of((Object)book, (Object)guideBook));
                }
                catch (Exception e) {
                    LogHelper.error("Error registering book for class " + data.clazz().getClassName());
                    e.printStackTrace();
                }
            }
        }
        APISetter.setIndexedBooks(Lists.newArrayList(GuideAPI.getBooks().values()));
    }
}

