/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.page;

import de.maxanier.guideapi.api.IRecipeRenderer;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.Page;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.api.util.IngredientCycler;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.gui.EntryScreen;
import de.maxanier.guideapi.page.reciperenderer.FurnaceRecipeRenderer;
import de.maxanier.guideapi.page.reciperenderer.ShapedRecipesRenderer;
import de.maxanier.guideapi.page.reciperenderer.ShapelessRecipesRenderer;
import de.maxanier.guideapi.util.LogHelper;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PageIRecipe
extends Page {
    private final IngredientCycler ingredientCycler = new IngredientCycler();
    public Recipe<?> recipe;
    public IRecipeRenderer iRecipeRenderer;
    protected boolean isValid;

    @Nullable
    public static IRecipeRenderer getRenderer(Recipe<?> recipe) {
        if (recipe == null) {
            LogHelper.error("Cannot get renderer for null recipe.");
            return null;
        }
        if (recipe instanceof ShapedRecipe) {
            return new ShapedRecipesRenderer((ShapedRecipe)recipe);
        }
        if (recipe instanceof ShapelessRecipe) {
            return new ShapelessRecipesRenderer((ShapelessRecipe)recipe);
        }
        if (recipe instanceof SmeltingRecipe) {
            return new FurnaceRecipeRenderer((SmeltingRecipe)recipe);
        }
        return null;
    }

    public PageIRecipe(Recipe<?> recipe) {
        this(recipe, PageIRecipe.getRenderer(recipe));
    }

    public PageIRecipe(Recipe<?> recipe, IRecipeRenderer iRecipeRenderer) {
        this.recipe = recipe;
        this.iRecipeRenderer = iRecipeRenderer;
        this.isValid = recipe != null && iRecipeRenderer != null;
    }

    @Override
    public boolean canSee(Book book, CategoryAbstract category, EntryAbstract entry, Player player, ItemStack bookStack, EntryScreen guiEntry) {
        return this.isValid;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(GuiGraphics graphics, RegistryAccess registryAccess, Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, BaseScreen guiBase, Font fontRendererObj) {
        if (this.isValid) {
            super.draw(graphics, registryAccess, book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRendererObj);
            this.ingredientCycler.tick(guiBase.getMinecraft());
            this.iRecipeRenderer.draw(graphics, registryAccess, book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRendererObj, this.ingredientCycler);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawExtras(GuiGraphics graphics, Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, BaseScreen guiBase, Font fontRendererObj) {
        if (this.isValid) {
            super.drawExtras(graphics, book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRendererObj);
            this.iRecipeRenderer.drawExtras(graphics, book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRendererObj);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PageIRecipe)) {
            return false;
        }
        PageIRecipe that = (PageIRecipe)o;
        if (!super.equals(o)) {
            return false;
        }
        if (!Objects.equals(this.recipe, that.recipe)) {
            return false;
        }
        return Objects.equals(this.iRecipeRenderer, that.iRecipeRenderer);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.recipe != null ? this.recipe.hashCode() : 0);
        result = 31 * result + (this.iRecipeRenderer != null ? this.iRecipeRenderer.hashCode() : 0);
        return result;
    }
}

