/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.info;

import de.maxanier.guideapi.api.IInfoRenderer;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.util.GuiHelper;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;

public class InfoRendererDescription
implements IInfoRenderer {
    private final ItemStack itemStack;
    private final Component description;
    private boolean tiny;
    private int yOffset;

    public InfoRendererDescription(ItemStack stack, Component description) {
        this.itemStack = stack;
        this.description = description;
    }

    @Override
    public void drawInformation(GuiGraphics graphics, Book book, Level world, BlockPos pos, BlockState state, HitResult rayTrace, Player player) {
        if (this.tiny) {
            graphics.pose().pushPose();
            graphics.pose().scale(0.5f, 0.5f, 0.5f);
        }
        Font fontRenderer = Minecraft.getInstance().font;
        int scaleMulti = this.tiny ? 2 : 1;
        GuiHelper.drawItemStack(graphics, this.itemStack, (Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2 + 55) * scaleMulti, (Minecraft.getInstance().getWindow().getGuiScaledHeight() / 2 - (this.tiny ? 20 : 30) + this.yOffset) * scaleMulti);
        int y = 0;
        List cutLines = fontRenderer.split((FormattedText)this.description, 100 * scaleMulti);
        for (FormattedCharSequence cut : cutLines) {
            graphics.drawString(fontRenderer, cut, (Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2 + 20) * scaleMulti, (Minecraft.getInstance().getWindow().getGuiScaledHeight() / 2 - 10 - y) * scaleMulti + this.yOffset, Color.WHITE.getRGB(), true);
            y -= 10 / scaleMulti;
        }
        if (this.tiny) {
            graphics.pose().popPose();
        }
    }

    public InfoRendererDescription setOffsetY(int yOffset) {
        this.yOffset = yOffset;
        return this;
    }

    public InfoRendererDescription setTiny(boolean tiny) {
        this.tiny = tiny;
        return this;
    }
}

