/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.gui;

import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.button.ButtonNext;
import de.maxanier.guideapi.button.ButtonPrev;
import de.maxanier.guideapi.button.ButtonSearch;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.gui.SearchScreen;
import de.maxanier.guideapi.network.ReadingStatePayload;
import de.maxanier.guideapi.wrapper.CategoryWrapper;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class HomeScreen
extends BaseScreen {
    public ResourceLocation outlineTexture;
    public ResourceLocation pageTexture;
    public Book book;
    public HashMultimap<Integer, CategoryWrapper> categoryWrapperMap = HashMultimap.create();
    public ButtonNext buttonNext;
    public ButtonPrev buttonPrev;
    public ButtonSearch buttonSearch;
    public int categoryPage;

    public HomeScreen(Book book, Player player, ItemStack bookStack) {
        super(book.getTitle(), player, bookStack);
        this.book = book;
        this.pageTexture = book.getPageTexture();
        this.outlineTexture = book.getOutlineTexture();
        this.categoryPage = 0;
    }

    public void init() {
        this.categoryWrapperMap.clear();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.buttonNext = new ButtonNext(this.guiLeft + 4 * this.xSize / 6, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.categoryPage + 1 < this.categoryWrapperMap.asMap().size()) {
                this.nextPage();
            }
        }, this);
        this.addRenderableWidget((GuiEventListener)this.buttonNext);
        this.buttonPrev = new ButtonPrev(this.guiLeft + this.xSize / 5, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.categoryPage > 0) {
                this.prevPage();
            }
        }, this);
        this.addRenderableWidget((GuiEventListener)this.buttonPrev);
        this.buttonSearch = new ButtonSearch(this.guiLeft + this.xSize / 6 - 25, this.guiTop + 5, btn -> this.minecraft.setScreen((Screen)new SearchScreen(this.book, this.player, this.bookStack, this)), this);
        this.addRenderableWidget((GuiEventListener)this.buttonSearch);
        int cX = this.guiLeft + 55;
        int cY = this.guiTop + 40;
        int i = 0;
        int pageNumber = 0;
        for (CategoryAbstract category : this.book.getCategoryList()) {
            if (category.entries.isEmpty()) continue;
            category.onInit(this.book, this, this.player, this.bookStack);
            int x = i % 5;
            int y = i / 5;
            this.categoryWrapperMap.put((Object)pageNumber, (Object)new CategoryWrapper(this.book, category, cX + x * 27, cY + y * 30, 23, 23, this.player, this.font, false, this.bookStack));
            if (++i < 20) continue;
            i = 0;
            ++pageNumber;
        }
    }

    @Override
    public boolean keyPressed(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        if ((keyCode == 265 || keyCode == 262) && this.categoryPage + 1 < this.categoryWrapperMap.asMap().size()) {
            this.nextPage();
        } else if ((keyCode == 264 || keyCode == 263) && this.categoryPage > 0) {
            this.prevPage();
        }
        return super.keyPressed(keyCode, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int typeofClick) {
        if (!super.mouseClicked(mouseX, mouseY, typeofClick)) {
            for (CategoryWrapper wrapper : this.categoryWrapperMap.get((Object)this.categoryPage)) {
                if (!wrapper.isMouseOnWrapper(mouseX, mouseY) || !wrapper.canPlayerSee()) continue;
                if (typeofClick == 0) {
                    wrapper.category.onLeftClicked(this.book, mouseX, mouseY, this.player, this.bookStack);
                } else if (typeofClick == 1) {
                    wrapper.category.onRightClicked(this.book, mouseX, mouseY, this.player, this.bookStack);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (pScrollY < 0.0) {
            this.nextPage();
        } else if (pScrollY > 0.0) {
            this.prevPage();
        }
        return pScrollY != 0.0 || super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    public void nextPage() {
        if (this.categoryPage != this.categoryWrapperMap.asMap().size() - 1 && !this.categoryWrapperMap.asMap().isEmpty()) {
            ++this.categoryPage;
        }
    }

    public void onClose() {
        super.onClose();
        PacketDistributor.sendToServer((CustomPacketPayload)new ReadingStatePayload(this.categoryPage, Optional.empty(), Optional.empty()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void prevPage() {
        if (this.categoryPage != 0) {
            --this.categoryPage;
        }
    }

    public void renderBackground(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderBackground(graphics, pMouseX, pMouseY, pPartialTick);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.blit(this.pageTexture, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        graphics.setColor((float)this.book.getColor().getRed() / 255.0f, (float)this.book.getColor().getGreen() / 255.0f, (float)this.book.getColor().getBlue() / 255.0f, 1.0f);
        graphics.blit(this.outlineTexture, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float renderPartialTicks) {
        super.render(graphics, mouseX, mouseY, renderPartialTicks);
        this.drawCenteredStringWithoutShadow(graphics, this.font, this.book.getHeader().getVisualOrderText(), this.guiLeft + this.xSize / 2 + 1, this.guiTop + 15, 0);
        this.categoryPage = Mth.clamp((int)this.categoryPage, (int)0, (int)(this.categoryWrapperMap.size() - 1));
        for (CategoryWrapper wrapper : this.categoryWrapperMap.get((Object)this.categoryPage)) {
            if (!wrapper.canPlayerSee()) continue;
            wrapper.draw(graphics, Minecraft.getInstance().level.registryAccess(), mouseX, mouseY, this);
        }
        for (CategoryWrapper wrapper : this.categoryWrapperMap.get((Object)this.categoryPage)) {
            if (!wrapper.canPlayerSee()) continue;
            wrapper.drawExtras(graphics, mouseX, mouseY, this);
        }
        this.drawCenteredStringWithoutShadow(graphics, this.font, String.format("%d/%d", this.categoryPage + 1, this.categoryWrapperMap.asMap().size()), this.guiLeft + this.xSize / 2, this.guiTop + 5 * this.ySize / 6, 0);
        graphics.drawCenteredString(this.font, this.book.getTitle(), this.guiLeft + this.xSize / 2, this.guiTop - 10, Color.WHITE.getRGB());
        this.buttonPrev.visible = this.categoryPage != 0;
        this.buttonNext.visible = this.categoryPage != this.categoryWrapperMap.asMap().size() - 1 && !this.categoryWrapperMap.asMap().isEmpty();
    }
}

