/*
 * Decompiled with CFR 0.152.
 */
package de.maxanier.guideapi.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxanier.guideapi.api.IPage;
import de.maxanier.guideapi.api.impl.Book;
import de.maxanier.guideapi.api.impl.abstraction.CategoryAbstract;
import de.maxanier.guideapi.api.impl.abstraction.EntryAbstract;
import de.maxanier.guideapi.button.ButtonBack;
import de.maxanier.guideapi.button.ButtonNext;
import de.maxanier.guideapi.button.ButtonPrev;
import de.maxanier.guideapi.button.ButtonSearch;
import de.maxanier.guideapi.gui.BaseScreen;
import de.maxanier.guideapi.gui.CategoryScreen;
import de.maxanier.guideapi.gui.SearchScreen;
import de.maxanier.guideapi.network.ReadingStatePayload;
import de.maxanier.guideapi.wrapper.PageWrapper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class EntryScreen
extends BaseScreen {
    public ResourceLocation outlineTexture;
    public ResourceLocation pageTexture;
    public Book book;
    public CategoryAbstract category;
    public EntryAbstract entry;
    public List<PageWrapper> pageWrapperList = new ArrayList<PageWrapper>();
    public ButtonBack buttonBack;
    public ButtonNext buttonNext;
    public ButtonPrev buttonPrev;
    public ButtonSearch buttonSearch;
    public int pageNumber;

    public EntryScreen(Book book, CategoryAbstract category, EntryAbstract entry, Player player, ItemStack bookStack) {
        super(entry.name, player, bookStack);
        this.book = book;
        this.category = category;
        this.entry = entry;
        this.pageTexture = book.getPageTexture();
        this.outlineTexture = book.getOutlineTexture();
        this.pageNumber = 0;
    }

    public void init() {
        super.init();
        this.entry.onInit(this.book, this.category, null, this.player, this.bookStack);
        this.pageWrapperList.clear();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.buttonBack = new ButtonBack(this.guiLeft + this.xSize / 6, this.guiTop, btn -> this.minecraft.setScreen((Screen)new CategoryScreen(this.book, this.category, this.player, this.bookStack, this.entry)), this);
        this.addRenderableWidget((GuiEventListener)this.buttonBack);
        this.buttonNext = new ButtonNext(this.guiLeft + 4 * this.xSize / 6, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.pageNumber + 1 < this.pageWrapperList.size()) {
                this.nextPage();
            }
        }, this);
        this.addRenderableWidget((GuiEventListener)this.buttonNext);
        this.buttonPrev = new ButtonPrev(this.guiLeft + this.xSize / 5, this.guiTop + 5 * this.ySize / 6, btn -> {
            if (this.pageNumber > 0) {
                this.prevPage();
            }
        }, this);
        this.addRenderableWidget((GuiEventListener)this.buttonPrev);
        this.buttonSearch = new ButtonSearch(this.guiLeft + this.xSize / 6 - 25, this.guiTop + 5, btn -> this.minecraft.setScreen((Screen)new SearchScreen(this.book, this.player, this.bookStack, this)), this);
        this.addRenderableWidget((GuiEventListener)this.buttonSearch);
        if (this.entry.pageList.size() == 0) {
            throw new IllegalStateException("Empty book entry " + this.entry.name.toString());
        }
        for (IPage page : this.entry.pageList) {
            page.onInit(this.book, this.category, this.entry, this.player, this.bookStack, this);
            this.pageWrapperList.add(new PageWrapper(this, this.book, this.category, this.entry, page, this.guiLeft, this.guiTop, this.player, this.font, this.bookStack));
        }
    }

    @Override
    public boolean keyPressed(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (keyCode == 259 || keyCode == this.minecraft.options.keyUse.getKey().getValue()) {
            this.minecraft.setScreen((Screen)new CategoryScreen(this.book, this.category, this.player, this.bookStack, this.entry));
            return true;
        }
        if ((keyCode == 265 || keyCode == 262) && this.pageNumber + 1 < this.pageWrapperList.size()) {
            this.nextPage();
            return true;
        }
        if ((keyCode == 264 || keyCode == 263) && this.pageNumber > 0) {
            this.prevPage();
            return true;
        }
        return super.keyPressed(keyCode, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int typeofClick) {
        if (!super.mouseClicked(mouseX, mouseY, typeofClick)) {
            for (PageWrapper wrapper : this.pageWrapperList) {
                if (!wrapper.isMouseOnWrapper(mouseX, mouseY) || !wrapper.canPlayerSee()) continue;
                if (typeofClick == 0) {
                    this.pageWrapperList.get((int)this.pageNumber).page.onLeftClicked(this.book, this.category, this.entry, mouseX, mouseY, this.player, this);
                    return true;
                }
                if (typeofClick != 1) continue;
                this.pageWrapperList.get((int)this.pageNumber).page.onRightClicked(this.book, this.category, this.entry, mouseX, mouseY, this.player, this);
                return true;
            }
            if (typeofClick == 1) {
                this.minecraft.setScreen((Screen)new CategoryScreen(this.book, this.category, this.player, this.bookStack, this.entry));
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (pScrollY < 0.0) {
            this.nextPage();
        } else if (pScrollY > 0.0) {
            this.prevPage();
        }
        return pScrollY != 0.0 || super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    public void nextPage() {
        if (this.pageNumber != this.pageWrapperList.size() - 1 && !this.pageWrapperList.isEmpty()) {
            ++this.pageNumber;
        }
    }

    public void onClose() {
        super.onClose();
        for (IPage page : this.entry.pageList) {
            page.onClose();
        }
        ResourceLocation key = null;
        for (Map.Entry<ResourceLocation, EntryAbstract> mapEntry : this.category.entries.entrySet()) {
            if (!mapEntry.getValue().equals(this.entry)) continue;
            key = mapEntry.getKey();
        }
        if (key != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ReadingStatePayload(this.pageNumber, Optional.of(this.book.getCategoryList().indexOf(this.category)), Optional.of(key)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void prevPage() {
        if (this.pageNumber != 0) {
            --this.pageNumber;
        }
    }

    public void renderBackground(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderBackground(graphics, pMouseX, pMouseY, pPartialTick);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.blit(this.pageTexture, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        graphics.setColor((float)this.book.getColor().getRed() / 255.0f, (float)this.book.getColor().getGreen() / 255.0f, (float)this.book.getColor().getBlue() / 255.0f, 1.0f);
        graphics.blit(this.outlineTexture, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float renderPartialTicks) {
        super.render(graphics, mouseX, mouseY, renderPartialTicks);
        this.pageNumber = Mth.clamp((int)this.pageNumber, (int)0, (int)(this.pageWrapperList.size() - 1));
        if (this.pageNumber < this.pageWrapperList.size() && this.pageWrapperList.get(this.pageNumber).canPlayerSee()) {
            this.pageWrapperList.get(this.pageNumber).draw(graphics, Minecraft.getInstance().level.registryAccess(), mouseX, mouseY, this);
            this.pageWrapperList.get(this.pageNumber).drawExtras(graphics, mouseX, mouseY, this);
        }
        this.drawCenteredStringWithoutShadow(graphics, this.font, String.format("%d/%d", this.pageNumber + 1, this.pageWrapperList.size()), this.guiLeft + this.xSize / 2, this.guiTop + 5 * this.ySize / 6, 0);
        graphics.drawCenteredString(this.font, this.entry.getName(), this.guiLeft + this.xSize / 2, this.guiTop - 10, Color.WHITE.getRGB());
        this.buttonPrev.visible = this.pageNumber != 0;
        this.buttonNext.visible = this.pageNumber != this.pageWrapperList.size() - 1 && !this.pageWrapperList.isEmpty();
    }
}

